/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.datamanager;

import com.fredtargaryen.fragileglass.DataReference;
import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.EntityConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.data.BreakerData;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.DataManager;
import com.fredtargaryen.fragileglass.entity.capability.IBreakCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class EntityDataManager
extends DataManager<EntityType, BreakerData> {
    private ConfigLoader entityConfigLoader;
    private static final String[] defaultFileData = new String[]{"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n", "@FRAGILE GLASS AND THIN ICE CONFIG FILE - ENTITIES@\n", "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n", "@THINK VERY CAREFULLY AND BACK UP YOUR WORLDS BEFORE ADDING ENTRIES HERE!\n", "@(You probably don't really want to make ZOMBIES ABLE TO BREAK EVERYTHING, for example.)\n", "@Here is where you can configure the speeds required for each entity to break a fragile block.\n", "\n@--Limitations--\n", "@* This will not work for entities which only appear on the client, such as particles.\n", "@* If your entry is not for a valid block, the mod will assume you entered a tile entity. However it\n", "@  cannot check if tile entities are valid, so you won't be warned. Check your spellings carefully.\n", "\n@--How to customise--\n", "@To add a comment to the file, start the line with a @ symbol.\n", "@To make an entity able to break fragile blocks, add a new row in this file following this format:\n", "@modid:ID minSpeed maxSpeed extraValues\n", "@* 'modid:ID' is the ResourceLocation string used to register the entity with Forge.\n", "@  - You can usually find this by looking at the entity in-game with the F3 menu on.\n", "@* minSpeed is a minimum speed (must be decimal). The entity must be moving above this speed\n", "@  for a block to potentially break. Speed is measured in blocks per tick, which is metres per second\n", "@  divided by 20. The minimum for this value is 0.0, i.e. any movement could break a block.\n", "@* maxSpeed is a maximum speed (must be decimal). The entity must be moving below this speed\n", "@  for a block to potentially break. Speed is measured in blocks per tick, which is metres per second\n", "@  divided by 20. The maximum for this value is 5.893: beyond this is faster than chunks can even load.\n", "@  - If the max speed is less than the min speed they will be switched around internally.\n", "@* You can add extra values of any format, separated by spaces, for any mod entities that might require\n", "@  them.\n", "\n@--Tips--\n", "@* Certain entities will get a default break speed if not in this file, just so that the file doesn't\n", "@  become totally huge. This applies to: mobs and animals; arrows; fireballs; minecarts; firework\n", "@  rockets; boats; primed TNT; falling blocks. Writing an entity in here will override the default.\n", "@* It is more realistic if the smaller the mob, the larger the break speed.\n", "@* Giving a mob a minimum speed of 0 is risky; a single step towards a fragile block will break it.\n", "\n@--Example lines which you might want to uncomment--\n", "@Lets raiders break fragile blocks\n", "@#minecraft:raiders 0.05 6.0\n\n"};

    public EntityDataManager() {
        super("entities");
        this.entityConfigLoader = new EntityConfigLoader(this, this.data);
    }

    public void addCapabilityIfPossible(Entity e, AttachCapabilitiesEvent<Entity> evt) {
        BreakerData breakerData = (BreakerData)this.data.get(e.func_200600_R());
        if (breakerData == null && (e instanceof LivingEntity || e instanceof ArrowEntity || e instanceof FireballEntity || e instanceof MinecartEntity || e instanceof FireworkRocketEntity || e instanceof BoatEntity || e instanceof TNTEntity || e instanceof FallingBlockEntity)) {
            breakerData = new BreakerData(0.07562500000000001, 34.72273476, new String[0]);
            this.data.put(e.func_200600_R(), breakerData);
        }
        if (breakerData != null) {
            ICapabilityProvider iCapProv = new ICapabilityProvider(){
                IBreakCapability inst = new IBreakCapability(){

                    @Override
                    public void init(Entity e) {
                    }

                    @Override
                    public void update(Entity e) {
                    }

                    @Override
                    public double getSpeedSquared(Entity e) {
                        Vec3d motion = e.func_213322_ci();
                        return motion.field_72450_a * motion.field_72450_a + motion.field_72448_b * motion.field_72448_b + motion.field_72449_c * motion.field_72449_c;
                    }

                    @Override
                    public boolean isAbleToBreak(Entity e, double speedSq) {
                        BreakerData breakerData = (BreakerData)EntityDataManager.this.data.get(e.func_200600_R());
                        if (breakerData == null) {
                            return false;
                        }
                        return speedSq >= breakerData.getMinSpeedSquared() && speedSq <= breakerData.getMaxSpeedSquared();
                    }

                    @Override
                    public double getMotionX(Entity e) {
                        return e.func_213322_ci().field_72450_a;
                    }

                    @Override
                    public double getMotionY(Entity e) {
                        return e.func_213322_ci().field_72448_b;
                    }

                    @Override
                    public double getMotionZ(Entity e) {
                        return e.func_213322_ci().field_72449_c;
                    }

                    @Override
                    public byte getNoOfBreaks(Entity e) {
                        return 1;
                    }
                };

                @Nullable
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                    return capability == FragileGlassBase.BREAKCAP ? LazyOptional.of(() -> this.inst) : LazyOptional.empty();
                }
            };
            evt.addCapability(DataReference.BREAK_LOCATION, iCapProv);
        }
    }

    @Override
    protected String[] getDefaultConfigFileText() {
        return defaultFileData;
    }

    @Override
    public boolean loadData() {
        return this.loadDataFromConfigDir(this.entityConfigLoader);
    }

    @Override
    public void parseConfigLine(String configLine) throws ConfigLoader.ConfigLoadException {
        this.entityConfigLoader.parseArbitraryString(configLine);
    }

    @Override
    public void removeBehaviour(EntityType key, @Nullable FragilityData.FragileBehaviour behaviour) {
        this.data.remove(key);
    }

    @Override
    public String stringifyBehaviour(EntityType key, @Nullable FragilityData.FragileBehaviour behaviour) {
        return key.getRegistryName() + " " + ((BreakerData)this.data.get(key)).toString();
    }
}

