/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import com.fredtargaryen.fragileglass.config.behaviour.data.WaitData;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.BlockDataManager;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.EntityDataManager;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.TileEntityDataManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BreakSystem
extends WorldSavedData {
    private World world;
    private BlockDataManager blockDataManager;
    private EntityDataManager entityDataManager;
    private TileEntityDataManager tileEntityDataManager;
    public HashMap<BlockPos, BehaviourQueue> queuedBehaviours = new HashMap();

    public BreakSystem() {
        super("fragileglassft");
    }

    public static BreakSystem forWorld(World world) {
        ServerWorld serverWorld = world.func_73046_m().func_71218_a(world.field_73011_w.func_186058_p());
        DimensionSavedDataManager storage = serverWorld.func_217481_x();
        return (BreakSystem)storage.func_215752_a(BreakSystem::new, "fragileglassft");
    }

    public void func_76184_a(CompoundNBT nbt) {
        for (int i = 0; i < nbt.func_186856_d(); ++i) {
            CompoundNBT queue = nbt.func_74775_l(Integer.toString(i));
            BlockPos bp = NBTUtil.func_186861_c((CompoundNBT)queue.func_74775_l("pos"));
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)queue.func_74775_l("state"));
            if (state == null) {
                FragileGlassBase.warn("Ignored a pending break system behaviour with a block state that doesn't exist. Are you missing a mod which you had last session?");
                continue;
            }
            String rl = queue.func_74779_i("tileentitytype");
            if (rl.equals("null")) {
                BehaviourQueue bq = new BehaviourQueue(queue.func_74762_e("countdown"), NBTUtil.func_190008_d((CompoundNBT)queue.func_74775_l("state")), null, queue.func_74769_h("speedsquared"), queue.func_74762_e("nextbehaviour"));
                this.queuedBehaviours.put(bp, bq);
                continue;
            }
            String[] rlParts = rl.split(":");
            if (rlParts.length == 2) {
                TileEntityType tet = (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation(rlParts[0], rlParts[1]));
                if (tet != null) {
                    BehaviourQueue bq = new BehaviourQueue(queue.func_74762_e("countdown"), NBTUtil.func_190008_d((CompoundNBT)queue.func_74775_l("state")), tet, queue.func_74769_h("speedsquared"), queue.func_74762_e("nextbehaviour"));
                    this.queuedBehaviours.put(bp, bq);
                }
                FragileGlassBase.warn("Ignored a pending break system behaviour with a tile entity type that doesn't exist. Are you missing a mod which you had last session?");
                continue;
            }
            FragileGlassBase.warn("Ignored a queued BreakSystem behaviour with invalid TileEntityType. Please do not manually edit the BreakSystem NBT.");
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        int i = 0;
        for (BlockPos bp : this.queuedBehaviours.keySet()) {
            BehaviourQueue bq = this.queuedBehaviours.get(bp);
            CompoundNBT queue = new CompoundNBT();
            queue.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)bp));
            queue.func_74768_a("countdown", bq.countdown);
            queue.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)bq.state));
            queue.func_74778_a("tileentitytype", bq.tileEntityType == null ? "null" : bq.tileEntityType.getRegistryName().toString());
            queue.func_74780_a("speedsquared", bq.speedSq);
            queue.func_74768_a("nextbehaviour", bq.nextBehaviourIndex);
            compound.func_218657_a(Integer.toString(i), (INBT)queue);
            ++i;
        }
        return compound;
    }

    public void init(World world) {
        this.world = world;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.blockDataManager = FragileGlassBase.getBlockDataManager();
        this.entityDataManager = FragileGlassBase.getEntityDataManager();
        this.tileEntityDataManager = FragileGlassBase.getTileEntityDataManager();
    }

    public void end(World world) {
        if (this.world == world) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void breakCheck(TickEvent.WorldTickEvent event) {
        if (event.world == this.world && event.phase == TickEvent.Phase.START) {
            Iterator<BlockPos> posIterator = this.queuedBehaviours.keySet().iterator();
            while (posIterator.hasNext()) {
                BlockPos pos = posIterator.next();
                if (this.updateBehaviourQueue(pos, this.queuedBehaviours.get(pos))) continue;
                posIterator.remove();
            }
            CopyOnWriteArrayList entityList = new CopyOnWriteArrayList(((ServerWorld)event.world).getEntities().collect(Collectors.toList()));
            for (Entity e : entityList) {
                if (e.field_70128_L) continue;
                e.getCapability(FragileGlassBase.BREAKCAP).ifPresent(ibc -> {
                    ibc.update(e);
                    double speedSq = ibc.getSpeedSquared(e);
                    if (this.isValidMoveSpeedSquared(speedSq) && ibc.isAbleToBreak(e, speedSq)) {
                        this.breakBlocksInWay(e, ibc.getMotionX(e), ibc.getMotionY(e), ibc.getMotionZ(e), speedSq, ibc.getNoOfBreaks(e));
                    }
                });
            }
        }
    }

    private void breakBlocksInWay(Entity e, double xToUse, double yToUse, double zToUse, double speedSq, byte noOfBreaks) {
        AxisAlignedBB originalAABB = e.func_174813_aQ();
        if (originalAABB != null) {
            double distance = Math.sqrt(speedSq);
            for (byte breaks = 0; breaks < noOfBreaks; breaks = (byte)(breaks + 1)) {
                AxisAlignedBB aabb = originalAABB;
                double xComp = xToUse / distance;
                double yComp = yToUse / distance;
                double zComp = zToUse / distance;
                while (distance > 1.0) {
                    aabb = aabb.func_72317_d(xComp, yComp, zComp);
                    this.breakNearbyFragileBlocks(e, aabb, (distance -= 1.0) * distance);
                }
                originalAABB = originalAABB.func_72317_d(xToUse, yToUse, zToUse);
                this.breakNearbyFragileBlocks(e, originalAABB, distance * distance);
            }
        }
    }

    private void breakNearbyFragileBlocks(Entity e, AxisAlignedBB aabb, double speedSq) {
        for (double x = Math.floor(aabb.field_72340_a); x < Math.ceil(aabb.field_72336_d); x += 1.0) {
            for (double y = Math.floor(aabb.field_72338_b); y < Math.ceil(aabb.field_72337_e); y += 1.0) {
                for (double z = Math.floor(aabb.field_72339_c); z < Math.ceil(aabb.field_72334_f); z += 1.0) {
                    ArrayList fragilityDataList;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockState state = e.field_70170_p.func_180495_p(blockPos);
                    Block block = state.func_177230_c();
                    if (block.isAir(state, (IBlockReader)e.field_70170_p, blockPos)) continue;
                    TileEntity te = e.field_70170_p.func_175625_s(blockPos);
                    if (te == null) {
                        fragilityDataList = (ArrayList)this.blockDataManager.getData(state);
                        if (fragilityDataList == null) continue;
                        this.initialUpdateFragilityDataList(state, null, blockPos, e, speedSq, fragilityDataList);
                        continue;
                    }
                    fragilityDataList = (ArrayList)this.tileEntityDataManager.getData(te.func_200662_C());
                    if (fragilityDataList == null) continue;
                    this.initialUpdateFragilityDataList(state, te, blockPos, e, speedSq, fragilityDataList);
                }
            }
        }
    }

    private void initialUpdateFragilityDataList(BlockState state, @Nullable TileEntity te, BlockPos pos, Entity e, double speedSq, ArrayList<FragilityData> fragDataList) {
        int listSize = fragDataList.size();
        boolean stop = false;
        for (int i = 0; !stop && i < listSize; ++i) {
            FragilityData fData = fragDataList.get(i);
            if (fData.getBehaviour() == FragilityData.FragileBehaviour.WAIT) {
                if (this.queuedBehaviours.containsKey(pos)) continue;
                if (speedSq >= fData.getBreakSpeedSq()) {
                    this.queuedBehaviours.put(pos, new BehaviourQueue(((WaitData)fData).getTicks(), state, te == null ? null : te.func_200662_C(), speedSq, i + 1));
                }
                stop = true;
                continue;
            }
            fData.onCrash(this.world, state, te, pos, e, speedSq);
        }
    }

    private boolean isValidMoveSpeedSquared(double blocksPerTick) {
        return blocksPerTick <= 34.72273476;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateBehaviourQueue(BlockPos pos, BehaviourQueue bq) {
        if (bq.countdown == 0) {
            int i;
            ArrayList fragDataList = bq.tileEntityType == null ? (ArrayList)this.blockDataManager.getData(bq.state) : (ArrayList)this.tileEntityDataManager.getData(bq.tileEntityType);
            if (fragDataList == null || bq.nextBehaviourIndex >= fragDataList.size()) return false;
            boolean stop = false;
            for (i = bq.nextBehaviourIndex; !stop && i < fragDataList.size(); ++i) {
                FragilityData fd = (FragilityData)fragDataList.get(i);
                if (fd.getBehaviour() == FragilityData.FragileBehaviour.WAIT) {
                    if (!(bq.speedSq > fd.getBreakSpeedSq())) continue;
                    bq.countdown = ((WaitData)fd).getTicks();
                    bq.nextBehaviourIndex = i + 1;
                    stop = true;
                    continue;
                }
                if (!fd.canBeQueued()) continue;
                fd.onCrash(this.world, bq.state, null, pos, null, bq.speedSq);
            }
            this.func_76185_a();
            if (i != fragDataList.size()) return true;
            return false;
        }
        --bq.countdown;
        this.func_76185_a();
        return true;
    }

    private class BehaviourQueue {
        public int countdown;
        public BlockState state;
        public TileEntityType<?> tileEntityType;
        public double speedSq;
        public int nextBehaviourIndex;

        public BehaviourQueue(int countdown, BlockState state, TileEntityType<?> tileEntityType, double speedSq, int nextBehaviourIndex) {
            this.countdown = countdown;
            this.state = state;
            this.tileEntityType = tileEntityType;
            this.speedSq = speedSq;
            this.nextBehaviourIndex = nextBehaviourIndex;
        }
    }
}

