/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension;

import androsa.gaiadimension.client.ClientEvents;
import androsa.gaiadimension.client.GaiaDimensionRenderInfo;
import androsa.gaiadimension.data.GaiaAdvancements;
import androsa.gaiadimension.data.GaiaBiomes;
import androsa.gaiadimension.data.GaiaBlockStates;
import androsa.gaiadimension.data.GaiaBlockTags;
import androsa.gaiadimension.data.GaiaConfiguredFeatures;
import androsa.gaiadimension.data.GaiaFluidTags;
import androsa.gaiadimension.data.GaiaItemModels;
import androsa.gaiadimension.data.GaiaItemTags;
import androsa.gaiadimension.data.GaiaLootTables;
import androsa.gaiadimension.data.GaiaRecipes;
import androsa.gaiadimension.registry.GaiaBiomeFeatures;
import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModContainers;
import androsa.gaiadimension.registry.ModDimensions;
import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.registry.ModFluids;
import androsa.gaiadimension.registry.ModGaiaConfig;
import androsa.gaiadimension.registry.ModItems;
import androsa.gaiadimension.registry.ModParticles;
import androsa.gaiadimension.registry.ModRecipes;
import androsa.gaiadimension.registry.ModTileEntities;
import androsa.gaiadimension.registry.ModWorldgen;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gaiadimension")
public class GaiaDimensionMod {
    public static final String MODID = "gaiadimension";
    public static final String MODEL_DIR = "gaiadimension:textures/entity/";
    public static final Logger LOGGER = LogManager.getLogger((String)"gaiadimension");
    public static ModGaiaConfig.ClientConfig clientConfig;
    public static ModGaiaConfig.CommonConfig commonConfig;
    public static final CreatureAttribute GAIAN;
    public static final CreatureAttribute CORRUPT;
    public static final DamageSource CORRUPTION;

    public GaiaDimensionMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        ModRecipes.registerRecipeTypes();
        ModBiomes.BIOMES.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        ModDimensions.POI_TYPES.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        ModTileEntities.TILE_ENTITIES.register(modEventBus);
        ModWorldgen.FEATURES.register(modEventBus);
        ModWorldgen.STRUCTURES.register(modEventBus);
        ModWorldgen.SURFACE_BUILDERS.register(modEventBus);
        ModWorldgen.WORLD_CARVERS.register(modEventBus);
        Pair specPairC = new ForgeConfigSpec.Builder().configure(ModGaiaConfig.ClientConfig::new);
        Pair specPairB = new ForgeConfigSpec.Builder().configure(ModGaiaConfig.CommonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)specPairC.getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)specPairB.getRight());
        clientConfig = (ModGaiaConfig.ClientConfig)specPairC.getLeft();
        commonConfig = (ModGaiaConfig.CommonConfig)specPairB.getLeft();
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PointOfInterestType.func_221052_a((PointOfInterestType)((PointOfInterestType)ModDimensions.GAIA_PORTAL.get()));
            PointOfInterestType.field_234167_x_.addAll(((PointOfInterestType)ModDimensions.GAIA_PORTAL.get()).field_221075_w);
            GaiaBiomeFeatures.registerConfiguredWorldgen();
            ModDimensions.initDimension();
            ModWorldgen.StructureTypes.init();
            ModBlocks.addStripping();
            ModBlocks.registerDispenserBehaviour();
        });
        ModBlocks.addPlants();
        ModEntities.registerSpawnPlacement();
        ModBiomes.addBiomeTypes();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        GaiaDimensionRenderInfo gaia = new GaiaDimensionRenderInfo();
        DimensionRenderInfo.field_239208_a_.put((Object)new ResourceLocation(MODID, "gaia"), (Object)gaia);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModContainers::registerScreens);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModEntities::registerEntityRender);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModParticles::forgeClassLoadingIsFuckedThisShouldntBeHereButHereItIs);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::registerBlockColors);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::registerItemColors);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::registerBlockRenderers);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModItems::addItemProperties);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        GaiaBlockTags blocktags = new GaiaBlockTags(generator, event.getExistingFileHelper());
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new GaiaBlockStates(generator, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new GaiaItemModels(generator, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new GaiaLootTables(generator));
            generator.func_200390_a((IDataProvider)new GaiaRecipes(generator));
            generator.func_200390_a((IDataProvider)new GaiaConfiguredFeatures(generator));
            generator.func_200390_a((IDataProvider)new GaiaBiomes(generator));
            generator.func_200390_a((IDataProvider)new GaiaAdvancements(generator));
            generator.func_200390_a((IDataProvider)blocktags);
            generator.func_200390_a((IDataProvider)new GaiaItemTags(generator, blocktags, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new GaiaFluidTags(generator, event.getExistingFileHelper()));
        }
    }

    static {
        GAIAN = new CreatureAttribute();
        CORRUPT = new CreatureAttribute();
        CORRUPTION = new DamageSource("corruption").func_76348_h();
    }
}

