/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.fluids.SuperhotMagmaFluid;
import androsa.gaiadimension.registry.GaiaTags;
import androsa.gaiadimension.registry.ModBlocks;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class GaiaFluidBlock
extends FlowingFluidBlock {
    public GaiaFluidBlock(Supplier<? extends FlowingFluid> fluid, AbstractBlock.Properties builder) {
        super(fluid, builder.func_200942_a().func_200943_b(100.0f).func_222380_e());
    }

    public boolean func_204515_c(World world, BlockPos pos, BlockState state) {
        for (Direction side : Direction.values()) {
            if (side == Direction.DOWN) continue;
            FluidState offset = world.func_204610_c(pos.func_177972_a(side));
            if (this.getFluid().func_207185_a(GaiaTags.Fluids.LIQUID_AURA)) {
                if (!offset.func_206884_a((ITag)FluidTags.field_206960_b) || offset.func_206884_a(GaiaTags.Fluids.SUPERHOT_MAGMA) || offset.func_206884_a(GaiaTags.Fluids.LIQUID_BISMUTH)) continue;
                this.setMixedBlock(world, pos, (Supplier<Block>)ModBlocks.sparkling_rock);
                return false;
            }
            if (this.getFluid().func_207185_a(GaiaTags.Fluids.SUPERHOT_MAGMA)) {
                if (offset.func_206884_a(GaiaTags.Fluids.SWEET_MUCK)) {
                    this.setMixedBlock(world, pos, (Supplier<Block>)ModBlocks.primal_mass);
                    return false;
                }
                if (offset.func_206884_a(GaiaTags.Fluids.LIQUID_AURA)) {
                    this.setMixedBlock(world, pos, (Supplier<Block>)ModBlocks.aura_block);
                    return false;
                }
                if (!offset.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                this.setMixedBlock(world, pos, (Supplier<Block>)ModBlocks.gaia_cobblestone);
                return false;
            }
            if (!this.getFluid().func_207185_a(GaiaTags.Fluids.LIQUID_BISMUTH)) continue;
            if (offset.func_206884_a(GaiaTags.Fluids.SWEET_MUCK) || offset.func_206884_a(GaiaTags.Fluids.SUPERHOT_MAGMA)) {
                this.setMixedBlock(world, pos, (Supplier<Block>)ModBlocks.active_rock);
                return false;
            }
            if (offset.func_206884_a(GaiaTags.Fluids.LIQUID_AURA)) {
                this.setMixedBlock(world, pos, (Supplier<Block>)ModBlocks.tektite_block);
                return false;
            }
            if (!offset.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            this.setMixedBlock(world, pos, (Supplier<Block>)ModBlocks.impure_rock);
            return false;
        }
        return super.func_204515_c(world, pos, state);
    }

    private void setMixedBlock(World world, BlockPos pos, Supplier<Block> block) {
        world.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)world, (BlockPos)pos, (BlockPos)pos, (BlockState)block.get().func_176223_P()));
        this.triggerMixEffects((IWorld)world, pos);
    }

    private void triggerMixEffects(IWorld worldIn, BlockPos pos) {
        worldIn.func_217379_c(1501, pos, 0);
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (this.getFluid().func_207185_a((ITag)FluidTags.field_206960_b)) {
            if (this.getFluid() instanceof SuperhotMagmaFluid && !entityIn.func_230279_az_()) {
                entityIn.func_70097_a(DamageSource.field_76372_a, 5.0f);
            }
            entityIn.func_70015_d(15);
        }
    }
}

