/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModDimensions;
import androsa.gaiadimension.registry.ModGaiaConfig;
import androsa.gaiadimension.registry.ModParticles;
import androsa.gaiadimension.world.GaiaTeleporter;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ITeleporter;

public class GaiaPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public GaiaPortalBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean tryToCreatePortal(World worldIn, BlockPos pos) {
        Size gaiaPortalSize = this.isPortal((IWorld)worldIn, pos);
        if (gaiaPortalSize != null && this.canCreatePortalByWorld(worldIn, pos)) {
            gaiaPortalSize.placePortalBlocks();
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(World world, BlockPos pos) {
        if (world.func_234923_W_().func_240901_a_().equals((Object)ModGaiaConfig.startDimRL)) {
            if (((Boolean)ModGaiaConfig.portalCheck.get()).booleanValue()) {
                Optional biome = world.func_242406_i(pos);
                ModGaiaConfig.ListType listtype = (ModGaiaConfig.ListType)((Object)ModGaiaConfig.listType.get());
                ModGaiaConfig.BiomeType biometype = (ModGaiaConfig.BiomeType)((Object)ModGaiaConfig.biomeType.get());
                if (biome.isPresent()) {
                    switch (biometype) {
                        case BIOME: {
                            return listtype == ModGaiaConfig.ListType.WHITELIST == ((List)ModGaiaConfig.biomeList.get()).contains(((RegistryKey)biome.get()).func_240901_a_().toString());
                        }
                        case CATEGORY: {
                            return listtype == ModGaiaConfig.ListType.WHITELIST == ((List)ModGaiaConfig.categoryList.get()).contains(world.func_226691_t_(pos).func_201856_r().toString());
                        }
                        case TYPE: {
                            for (String type : (List)ModGaiaConfig.typeList.get()) {
                                if (!BiomeDictionary.hasType((RegistryKey)((RegistryKey)biome.get()), (BiomeDictionary.Type)BiomeDictionary.Type.getType((String)type, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]))) continue;
                                return listtype == ModGaiaConfig.ListType.WHITELIST;
                            }
                            return listtype == ModGaiaConfig.ListType.BLACKLIST;
                        }
                    }
                }
                GaiaDimensionMod.LOGGER.warn("The biome doesn't appear to exist. Portal could not be created. If this issue persists, disable biome checking in the world's config.");
                return false;
            }
            return true;
        }
        return world.func_234923_W_() == ModDimensions.gaia_world;
    }

    @Nullable
    public Size isPortal(IWorld world, BlockPos pos) {
        Size gaiaPortalSizeX = new Size(world, pos, Direction.Axis.X);
        if (gaiaPortalSizeX.isValid() && gaiaPortalSizeX.portalBlockCount == 0) {
            return gaiaPortalSizeX;
        }
        Size gaiaPortalSizeZ = new Size(world, pos, Direction.Axis.Z);
        return gaiaPortalSizeZ.isValid() && gaiaPortalSizeZ.portalBlockCount == 0 ? gaiaPortalSizeZ : null;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis directionAxis = facing.func_176740_k();
        Direction.Axis directionAxis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = directionAxis1 != directionAxis && directionAxis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, directionAxis1).canCreatePortal() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Deprecated
    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.func_242280_ah()) {
                entity.func_242279_ag();
            } else {
                RegistryKey<World> registrykey;
                ServerWorld serverworld;
                MinecraftServer minecraftserver;
                ServerWorld serverworld1;
                if (!entity.field_70170_p.func_201670_d() && !pos.equals((Object)entity.field_242271_ac)) {
                    entity.field_242271_ac = pos.func_185334_h();
                }
                if (entity.field_70170_p instanceof ServerWorld && (serverworld1 = (minecraftserver = (serverworld = (ServerWorld)entity.field_70170_p).func_73046_m()).func_71218_a(registrykey = entity.field_70170_p.func_234923_W_() == ModDimensions.gaia_world ? ModGaiaConfig.startDimRK : ModDimensions.gaia_world)) != null && !entity.func_184218_aH()) {
                    entity.func_242279_ag();
                    entity.changeDimension(serverworld1, (ITeleporter)new GaiaTeleporter(serverworld1));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (float)pos.func_177958_n() + rand.nextFloat();
            double y = (float)pos.func_177956_o() + rand.nextFloat();
            double z = (float)pos.func_177952_p() + rand.nextFloat();
            double sX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int mul = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)mul;
                sX = rand.nextFloat() * 2.0f * (float)mul;
            } else {
                z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)mul;
                sZ = rand.nextFloat() * 2.0f * (float)mul;
            }
            worldIn.func_195594_a((IParticleData)ModParticles.PORTAL, x, y, z, sX, sY, sZ);
        }
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private static final AbstractBlock.IPositionPredicate FRAME_TEST = (state, reader, pos) -> state.func_177230_c() == ModBlocks.keystone_block.get();
        private final Block PORTAL = (Block)ModBlocks.gaia_portal.get();

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis facing) {
            this.world = worldIn;
            this.axis = facing;
            this.rightDir = facing == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.calculateBottomLeft(pos);
            if (this.bottomLeft == null) {
                this.bottomLeft = pos;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.calculatePortalWidth();
                if (this.width > 0) {
                    this.height = this.calculatePortalHeight();
                }
            }
        }

        @Nullable
        private BlockPos calculateBottomLeft(BlockPos pos) {
            int i = Math.max(0, pos.func_177956_o() - 21);
            while (pos.func_177956_o() > i && this.isEmptyBlock(this.world.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            Direction direction = this.rightDir.func_176734_d();
            int j = this.getDistanceUntilEdge(pos, direction) - 1;
            return j < 0 ? null : pos.func_177967_a(direction, j);
        }

        private int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int i = 0; i < 22; ++i) {
                mutable.func_189533_g((Vector3i)pos).func_189534_c(facing, i);
                BlockState state = this.world.func_180495_p((BlockPos)mutable);
                if (!this.isEmptyBlock(state)) {
                    if (!FRAME_TEST.test(state, (IBlockReader)this.world, (BlockPos)mutable)) break;
                    return i;
                }
                BlockState state1 = this.world.func_180495_p((BlockPos)mutable.func_189536_c(Direction.DOWN));
                if (!FRAME_TEST.test(state1, (IBlockReader)this.world, (BlockPos)mutable)) break;
            }
            return 0;
        }

        private int calculatePortalWidth() {
            int dist = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            return dist >= 2 && dist <= 21 ? dist : 0;
        }

        private int calculatePortalHeight() {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            int dist = this.getDistanceUntilTop(mutable);
            return dist >= 3 && dist <= 21 && this.hasTopFrame(mutable, dist) ? dist : 0;
        }

        private int getDistanceUntilTop(BlockPos.Mutable mutable) {
            for (int i = 0; i < 21; ++i) {
                mutable.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, -1);
                if (!FRAME_TEST.test(this.world.func_180495_p((BlockPos)mutable), (IBlockReader)this.world, (BlockPos)mutable)) {
                    return i;
                }
                mutable.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, this.width);
                if (!FRAME_TEST.test(this.world.func_180495_p((BlockPos)mutable), (IBlockReader)this.world, (BlockPos)mutable)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    mutable.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, j);
                    BlockState blockstate = this.world.func_180495_p((BlockPos)mutable);
                    if (!this.isEmptyBlock(blockstate)) {
                        return i;
                    }
                    if (blockstate.func_177230_c() != this.PORTAL) continue;
                    ++this.portalBlockCount;
                }
            }
            return 21;
        }

        private boolean hasTopFrame(BlockPos.Mutable mutable, int offset) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.Mutable mutablepos = mutable.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, offset).func_189534_c(this.rightDir, i);
                if (FRAME_TEST.test(this.world.func_180495_p((BlockPos)mutablepos), (IBlockReader)this.world, (BlockPos)mutablepos)) continue;
                return false;
            }
            return true;
        }

        private boolean isEmptyBlock(BlockState state) {
            Block block = state.func_177230_c();
            return state.func_196958_f() || block == ModBlocks.gold_fire.get() || block == this.PORTAL;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            BlockState state = (BlockState)this.PORTAL.func_176223_P().func_206870_a(AXIS, (Comparable)this.axis);
            BlockPos.func_218278_a((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.func_177967_a(Direction.UP, this.height - 1).func_177967_a(this.rightDir, this.width - 1)).forEach(pos -> this.world.func_180501_a(pos, state, 18));
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount == this.width * this.height;
        }
    }
}

