/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.tileentity;

import androsa.gaiadimension.block.PurifierBlock;
import androsa.gaiadimension.block.container.PurifierContainer;
import androsa.gaiadimension.block.tileentity.RestructurerTileEntity;
import androsa.gaiadimension.recipe.PurifierRecipe;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModItems;
import androsa.gaiadimension.registry.ModRecipes;
import androsa.gaiadimension.registry.ModTileEntities;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class PurifierTileEntity
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{4, 1, 2, 3, 5};
    private static final int[] slotsSides = new int[]{1, 2, 3};
    private NonNullList<ItemStack> purifyingItemStacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private int burnTime;
    private int recipesUsed;
    private int cookTime;
    private int cookTimeTotal;
    protected final IIntArray slotsArray = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return PurifierTileEntity.this.burnTime;
                }
                case 1: {
                    return PurifierTileEntity.this.recipesUsed;
                }
                case 2: {
                    return PurifierTileEntity.this.cookTime;
                }
                case 3: {
                    return PurifierTileEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    PurifierTileEntity.this.burnTime = value;
                }
                case 1: {
                    PurifierTileEntity.this.recipesUsed = value;
                }
                case 2: {
                    PurifierTileEntity.this.cookTime = value;
                }
                case 3: {
                    PurifierTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private final Map<ResourceLocation, Integer> recipeMap = Maps.newHashMap();
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public PurifierTileEntity() {
        super((TileEntityType)ModTileEntities.PURIFIER.get());
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("gaiadimension.container.purifier", new Object[]{0});
    }

    protected Container func_213906_a(int id, PlayerInventory inventory) {
        return new PurifierContainer(id, inventory, (IInventory)this, this.slotsArray);
    }

    public static Map<Item, Integer> getThirdFuelBurnTime() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        PurifierTileEntity.addItemToMap(map, (IItemProvider)ModItems.bismuth_residue.get(), 200);
        PurifierTileEntity.addItemToMap(map, (IItemProvider)ModItems.bismuth_crystal.get(), 1800);
        PurifierTileEntity.addItemToMap(map, (IItemProvider)ModBlocks.bismuth_block.get(), 16200);
        PurifierTileEntity.addItemToMap(map, (IItemProvider)ModItems.black_residue.get(), 100);
        PurifierTileEntity.addItemToMap(map, (IItemProvider)ModItems.tektite.get(), 900);
        PurifierTileEntity.addItemToMap(map, (IItemProvider)ModBlocks.tektite_block.get(), 8100);
        return map;
    }

    private static void addItemToMap(Map<Item, Integer> map, IItemProvider provider, int ticks) {
        map.put(provider.func_199767_j(), ticks);
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.purifyingItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.purifyingItemStacks);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.recipesUsed = this.getItemBurnTime((ItemStack)this.purifyingItemStacks.get(1), (ItemStack)this.purifyingItemStacks.get(2), (ItemStack)this.purifyingItemStacks.get(3));
        int i = compound.func_74765_d("RecipesUsedSize");
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.func_74779_i("RecipeLocation" + j));
            int k = compound.func_74762_e("RecipeAmount" + j);
            this.recipeMap.put(resourcelocation, k);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.purifyingItemStacks);
        compound.func_74777_a("RecipesUsedSize", (short)this.recipeMap.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipeMap.entrySet()) {
            compound.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            compound.func_74768_a("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
        return compound;
    }

    public void func_73660_a() {
        boolean burning = this.isBurning();
        boolean burn = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.func_201670_d()) {
            ItemStack goldStack = (ItemStack)this.purifyingItemStacks.get(1);
            ItemStack essenceStack = (ItemStack)this.purifyingItemStacks.get(2);
            ItemStack bismuthStack = (ItemStack)this.purifyingItemStacks.get(3);
            if (this.isBurning() || !goldStack.func_190926_b() && !essenceStack.func_190926_b() && !bismuthStack.func_190926_b() && !((ItemStack)this.purifyingItemStacks.get(0)).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipes.PURIFYING, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canChange(irecipe)) {
                    this.recipesUsed = this.burnTime = this.getItemBurnTime(goldStack, essenceStack, bismuthStack);
                    if (this.isBurning()) {
                        ItemStack item1;
                        Item item;
                        burn = true;
                        if (!goldStack.func_190926_b()) {
                            item = goldStack.func_77973_b();
                            goldStack.func_190918_g(1);
                            if (goldStack.func_190926_b()) {
                                item1 = item.getContainerItem(goldStack);
                                this.purifyingItemStacks.set(1, (Object)item1);
                            }
                        }
                        if (!essenceStack.func_190926_b()) {
                            item = essenceStack.func_77973_b();
                            essenceStack.func_190918_g(1);
                            if (essenceStack.func_190926_b()) {
                                item1 = item.getContainerItem(essenceStack);
                                this.purifyingItemStacks.set(2, (Object)item1);
                            }
                        }
                        if (!bismuthStack.func_190926_b()) {
                            item = bismuthStack.func_77973_b();
                            bismuthStack.func_190918_g(1);
                            if (bismuthStack.func_190926_b()) {
                                item1 = item.getContainerItem(bismuthStack);
                                this.purifyingItemStacks.set(3, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canChange(irecipe)) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.cookingTime();
                        this.changeItem(irecipe);
                        burn = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (burning != this.isBurning()) {
                burn = true;
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)PurifierBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())));
            }
        }
        if (burn) {
            this.func_70296_d();
        }
    }

    private boolean canChange(IRecipe<?> recipe) {
        if (!((ItemStack)this.purifyingItemStacks.get(0)).func_190926_b() && recipe != null) {
            ItemStack slot1 = ((PurifierRecipe)recipe).func_77571_b();
            ItemStack slot2 = ((PurifierRecipe)recipe).getByproduct();
            if (slot1.func_190926_b() && slot2.func_190926_b() || slot1.func_190926_b()) {
                return false;
            }
            ItemStack output = (ItemStack)this.purifyingItemStacks.get(4);
            ItemStack byproduct = (ItemStack)this.purifyingItemStacks.get(5);
            if (output.func_190926_b() && byproduct.func_190926_b()) {
                return true;
            }
            if (!output.func_77969_a(slot1) || !byproduct.func_77969_a(slot2)) {
                return false;
            }
            if (output.func_190916_E() + slot1.func_190916_E() <= this.func_70297_j_() && output.func_190916_E() + slot1.func_190916_E() <= output.func_77976_d() && byproduct.func_190916_E() + slot2.func_190916_E() <= this.func_70297_j_() && byproduct.func_190916_E() + slot2.func_190916_E() <= byproduct.func_77976_d()) {
                return true;
            }
            return output.func_190916_E() + slot1.func_190916_E() <= output.func_77976_d() && byproduct.func_190916_E() + slot2.func_190916_E() <= byproduct.func_77976_d();
        }
        return false;
    }

    public void changeItem(IRecipe<?> recipe) {
        if (recipe != null && this.canChange(recipe)) {
            ItemStack input = (ItemStack)this.purifyingItemStacks.get(0);
            ItemStack slot1 = ((PurifierRecipe)recipe).func_77571_b();
            ItemStack slot2 = ((PurifierRecipe)recipe).getByproduct();
            ItemStack output = (ItemStack)this.purifyingItemStacks.get(4);
            ItemStack byproduct = (ItemStack)this.purifyingItemStacks.get(5);
            if (output.func_190926_b()) {
                this.purifyingItemStacks.set(4, (Object)slot1.func_77946_l());
            } else if (output.func_77973_b() == slot1.func_77973_b()) {
                output.func_190917_f(slot1.func_190916_E());
            }
            if (!slot2.func_190926_b()) {
                if (byproduct.func_190926_b()) {
                    this.purifyingItemStacks.set(5, (Object)slot2.func_77946_l());
                } else if (byproduct.func_77973_b() == slot2.func_77973_b()) {
                    byproduct.func_190917_f(slot2.func_190916_E());
                }
            }
            if (!this.field_145850_b.func_201670_d()) {
                this.func_193056_a(recipe);
            }
            if (input.func_190916_E() <= 0) {
                this.purifyingItemStacks.set(0, (Object)ItemStack.field_190927_a);
            }
            input.func_190918_g(1);
        }
    }

    public int getItemBurnTime(ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return 0;
        }
        Item itemGlitter = stack1.func_77973_b();
        Item itemShine = stack2.func_77973_b();
        Item itemNull = stack3.func_77973_b();
        return (RestructurerTileEntity.getFuelBurnTime().get(itemGlitter) + RestructurerTileEntity.getSecondFuelBurnTime().get(itemShine) + PurifierTileEntity.getThirdFuelBurnTime().get(itemNull)) / 3;
    }

    private int cookingTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(ModRecipes.PURIFYING, (IInventory)this, this.field_145850_b).map(PurifierRecipe::getCookTime).orElse(200);
    }

    public static boolean isItemFuel(ItemStack stack) {
        Item item = stack.func_77973_b();
        return RestructurerTileEntity.getFuelBurnTime().get(item) != null || RestructurerTileEntity.getSecondFuelBurnTime().get(item) != null || PurifierTileEntity.getThirdFuelBurnTime().get(item) != null;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return slotsBottom;
        }
        return side == Direction.UP ? slotsTop : slotsSides;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1 || index == 2 || index == 3) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public int func_70302_i_() {
        return this.purifyingItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.purifyingItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.purifyingItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.purifyingItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.purifyingItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.purifyingItemStacks.get(index);
        boolean burning = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.purifyingItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !burning) {
            this.cookTimeTotal = 200;
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 4 && index != 5 && (index == 0 || PurifierTileEntity.isItemFuel(stack));
    }

    public void func_174888_l() {
        this.purifyingItemStacks.clear();
    }

    public void func_193056_a(IRecipe<?> recipe) {
        if (recipe != null) {
            this.recipeMap.compute(recipe.func_199560_c(), (location, integer) -> 1 + (integer == null ? 0 : integer));
        }
    }

    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity player) {
    }

    public void unlockRecipe(PlayerEntity player) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipeMap.entrySet()) {
            player.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                PurifierTileEntity.grantExperience(player, (Integer)entry.getValue(), ((PurifierRecipe)recipe).getExperience());
            });
        }
        player.func_195065_a((Collection)list);
        this.recipeMap.clear();
    }

    private static void grantExperience(PlayerEntity player, int amount, float multiplier) {
        if (multiplier == 0.0f) {
            amount = 0;
        } else if (multiplier < 1.0f) {
            int i = MathHelper.func_76141_d((float)((float)amount * multiplier));
            if (i < MathHelper.func_76123_f((float)((float)amount * multiplier)) && Math.random() < (double)((float)amount * multiplier - (float)i)) {
                ++i;
            }
            amount = i;
        }
        while (amount > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)amount);
            amount -= j;
            player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.purifyingItemStacks) {
            helper.func_194112_a(itemstack);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

