/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.tileentity.boss;

import androsa.gaiadimension.registry.ModParticles;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractSpawnerTileEntity<T extends MobEntity>
extends TileEntity
implements ITickableTileEntity {
    private final EntityType<T> bossEntity;
    private boolean spawnedBoss = false;
    private Random random = new Random();

    public AbstractSpawnerTileEntity(TileEntityType<?> type, EntityType<T> boss) {
        super(type);
        this.bossEntity = boss;
    }

    public void func_73660_a() {
        if (this.isInRange() && !this.spawnedBoss) {
            World world = this.func_145831_w();
            if (world.func_201670_d()) {
                float r = (float)(this.getColor() >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.getColor() >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.getColor() >> 0 & 0xFF) / 255.0f;
                double xPos = (double)this.field_174879_c.func_177958_n() + 0.5 + (this.random.nextDouble() - 0.5);
                double yPos = (double)this.field_174879_c.func_177956_o() + 0.5 + (this.random.nextDouble() - 0.5);
                double zPos = (double)this.field_174879_c.func_177952_p() + 0.5 + (this.random.nextDouble() - 0.5);
                world.func_195594_a((IParticleData)ModParticles.SPAWNER_CORE, xPos, yPos, zPos, (double)r, (double)g, (double)b);
            } else if (world.func_175659_aa() != Difficulty.PEACEFUL && this.canSpawnBoss((ServerWorld)world)) {
                world.func_175655_b(this.func_174877_v(), false);
                this.spawnedBoss = true;
            }
        }
    }

    public boolean isInRange() {
        return this.func_145831_w().func_217358_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.getSpawnerRange());
    }

    public abstract double getSpawnerRange();

    public abstract int getColor();

    private boolean canSpawnBoss(ServerWorld world) {
        MobEntity entity = (MobEntity)this.bossEntity.func_200721_a((World)world);
        entity.func_174828_a(this.func_174877_v(), 0.0f, 0.0f);
        entity.func_213386_a((IServerWorld)world, world.func_175649_E(this.func_174877_v()), SpawnReason.SPAWNER, null, null);
        entity.func_213390_a(this.func_174877_v(), this.getHomeDistance());
        return world.func_217376_c((Entity)entity);
    }

    public abstract int getHomeDistance();

    public boolean func_183000_F() {
        return true;
    }
}

