/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.client;

import androsa.gaiadimension.registry.ModGaiaConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ISkyRenderHandler;

public class GaiaSkyRender
implements ISkyRenderHandler {
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("minecraft:textures/environment/sun.png");
    private VertexBuffer starVBO;
    private final VertexFormat vertexBufferFormat = DefaultVertexFormats.field_181705_e;

    public GaiaSkyRender() {
        this.generateStars();
    }

    public void render(int ticks, float partialTicks, MatrixStack matrix, ClientWorld world, Minecraft mc) {
        WorldRenderer renderer = mc.field_71438_f;
        RenderSystem.disableTexture();
        Vector3d skycol = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float sRed = (float)skycol.field_72450_a;
        float sGreen = (float)skycol.field_72448_b;
        float sBlue = (float)skycol.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)sRed, (float)sGreen, (float)sBlue);
        renderer.field_175012_t.func_177359_a();
        this.vertexBufferFormat.func_227892_a_(0L);
        renderer.field_175012_t.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.vertexBufferFormat.func_227895_d_();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] setcol = world.func_239132_a_().func_230492_a_(world.func_242415_f(partialTicks), partialTicks);
        if (setcol != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrix.func_227860_a_();
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float ssRed = setcol[0];
            float ssGreen = setcol[1];
            float ssBlue = setcol[2];
            Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(ssRed, ssGreen, ssBlue, setcol[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * setcol[3]).func_227885_a_(setcol[0], setcol[1], setcol[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrix.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrix.func_227860_a_();
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_242415_f(partialTicks) * 360.0f));
        Matrix4f matrix4f1 = matrix.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        renderer.field_72770_i.func_110577_a(SUN_TEXTURES);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = this.getStarBrightness(world, partialTicks);
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.starVBO.func_177359_a();
            this.vertexBufferFormat.func_227892_a_(0L);
            this.starVBO.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.vertexBufferFormat.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrix.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double y = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_72912_H().func_239159_f_();
        if (y < 0.0) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 12.0, 0.0);
            renderer.field_175011_u.func_177359_a();
            this.vertexBufferFormat.func_227892_a_(0L);
            renderer.field_175011_u.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.vertexBufferFormat.func_227895_d_();
            matrix.func_227865_b_();
        }
        RenderSystem.color3f((float)(sRed * 0.2f + 0.04f), (float)(sGreen * 0.2f + 0.04f), (float)(sBlue * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        this.starVBO = new VertexBuffer(this.vertexBufferFormat);
        Random random = new Random(10842L);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double x = random.nextFloat() * 2.0f - 1.0f;
            double y = random.nextFloat() * 2.0f - 1.0f;
            double z = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double area = x * x + y * y + z * z;
            if (!(area < 1.0) || !(area > 0.01)) continue;
            area = 1.0 / Math.sqrt(area);
            double xPos = (x *= area) * 100.0;
            double yPos = (y *= area) * 100.0;
            double zPos = (z *= area) * 100.0;
            double d8 = Math.atan2(x, z);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(x * x + z * z), y);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferbuilder.func_225582_a_(xPos + d25, yPos + d23, zPos + d26).func_181675_d();
            }
        }
        bufferbuilder.func_178977_d();
        this.starVBO.func_227875_a_(bufferbuilder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStarBrightness(ClientWorld world, float par1) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Optional biome = world.func_242406_i(new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()));
        return biome.filter(ModGaiaConfig::canDisplayStars).map(biomeRegistryKey -> Float.valueOf(0.5f)).orElseGet(() -> Float.valueOf(world.func_228330_j_(par1))).floatValue();
    }
}

