/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.restructurer;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.compat.jei.JEICompat;
import androsa.gaiadimension.recipe.RestructurerRecipe;
import androsa.gaiadimension.registry.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;

public class RestructurerRecipeMaker {
    private RestructurerRecipeMaker() {
    }

    public static List<RestructurerRecipe> getRestructurerRecipes() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        ArrayList<RestructurerRecipe> recipeList = new ArrayList<RestructurerRecipe>();
        for (IRecipe iInventoryIRecipe : JEICompat.getRecipes(recipeManager, ModRecipes.RESTRUCTURING)) {
            RestructurerRecipe recipe = (RestructurerRecipe)iInventoryIRecipe;
            if (!RestructurerRecipeMaker.isRecipeValid(recipe)) continue;
            recipeList.add(recipe);
        }
        return recipeList;
    }

    private static boolean isRecipeValid(RestructurerRecipe recipe) {
        ItemStack recipeOutput = recipe.func_77571_b();
        if (recipeOutput != null && !recipeOutput.func_190926_b()) {
            NonNullList<Ingredient> ingredients = recipe.func_192400_c();
            if (ingredients == null) {
                GaiaDimensionMod.LOGGER.error("Recipe has no input Ingredients.");
                return false;
            }
            int inputCount = RestructurerRecipeMaker.getInputCount(ingredients);
            if (inputCount == -1) {
                return false;
            }
            if (inputCount > 1) {
                GaiaDimensionMod.LOGGER.error("Recipe has too many inputs.");
                return false;
            }
            if (inputCount == 0) {
                GaiaDimensionMod.LOGGER.error("Recipe has no inputs.");
                return false;
            }
            return true;
        }
        GaiaDimensionMod.LOGGER.error("Recipe has no output. {}", (Object)recipeOutput);
        return false;
    }

    private static int getInputCount(List<Ingredient> ingredientList) {
        int inputCount = 0;
        for (Ingredient ingredient : ingredientList) {
            ItemStack[] input = ingredient.func_193365_a();
            if (input == null) {
                return -1;
            }
            ++inputCount;
        }
        return inputCount;
    }
}

