/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data;

import androsa.gaiadimension.data.provider.GaiaBiomeProvider;
import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.registry.ModEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;

public class GaiaBiomes
extends GaiaBiomeProvider {
    public GaiaBiomes(DataGenerator generator) {
        super(generator);
    }

    @Override
    protected Map<RegistryKey<Biome>, Biome> registerBiomes() {
        ImmutableMap.Builder biomes = ImmutableMap.builder();
        biomes.put(ModBiomes.pink_agate_forest, (Object)GaiaBiomes.makePinkAgateForest());
        biomes.put(ModBiomes.blue_agate_taiga, (Object)GaiaBiomes.makeBlueAgateTaiga());
        biomes.put(ModBiomes.green_agate_jungle, (Object)GaiaBiomes.makeGreenAgateJungle());
        biomes.put(ModBiomes.purple_agate_swamp, (Object)GaiaBiomes.makePurpleAgateSwamp());
        biomes.put(ModBiomes.fossil_woodland, (Object)GaiaBiomes.makeFossilWoodland());
        biomes.put(ModBiomes.mutant_agate_wildwood, (Object)GaiaBiomes.makeMutantAgateWildwood());
        biomes.put(ModBiomes.volcanic_lands, (Object)GaiaBiomes.makeVolcanicLands());
        biomes.put(ModBiomes.static_wasteland, (Object)GaiaBiomes.makeStaticWasteland());
        biomes.put(ModBiomes.goldstone_lands, (Object)GaiaBiomes.makeGoldstoneLands());
        biomes.put(ModBiomes.crystal_plains, (Object)GaiaBiomes.makeCrystalPlains());
        biomes.put(ModBiomes.salt_dunes, (Object)GaiaBiomes.makeSaltDunes());
        biomes.put(ModBiomes.smoldering_bog, (Object)GaiaBiomes.makeSmolderingBog());
        biomes.put(ModBiomes.shining_grove, (Object)GaiaBiomes.makeShiningGrove());
        biomes.put(ModBiomes.mineral_reservoir, (Object)GaiaBiomes.makeMineralReservoir());
        biomes.put(ModBiomes.mineral_river, (Object)GaiaBiomes.makeMineralRiver());
        return biomes.build();
    }

    public static Biome makePinkAgateForest() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(15901620, 13016408, 15381216), GaiaBiomes.pinkAgateForest(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.GROWTH_SAPPER, 20, 3, 5)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.AGATE_GOLEM, 15, 1, 3)))).func_205421_a(0.1f).func_205420_b(0.1f).func_205414_c(0.66f));
    }

    public static Biome makeBlueAgateTaiga() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(6851272, 9815527, 15381216), GaiaBiomes.blueAgateTaiga(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.HOWLITE_WOLF, 15, 2, 4)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.BLUE_HOWLITE_WOLF, 1, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.GROWTH_SAPPER, 20, 3, 5)))).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.4f));
    }

    public static Biome makeGreenAgateJungle() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(4961870, 8437662, 15381216), GaiaBiomes.greenAgateJungle(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.GROWTH_SAPPER, 20, 3, 5)).func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners(ModEntities.MARKUZAR_PLANT, 15, 2, 4)))).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.75f));
    }

    public static Biome makePurpleAgateSwamp() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(8417209, 11234801, 15381216), GaiaBiomes.purpleAgateSwamp(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.GROWTH_SAPPER, 20, 3, 5)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.SPELLBOUND_ELEMENTAL, 10, 2, 4)))).func_205421_a(0.0f).func_205420_b(0.05f).func_205414_c(0.66f));
    }

    public static Biome makeFossilWoodland() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(12298105, 13016408, 15381216), GaiaBiomes.fossilWoodland(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.ANCIENT_LAGRAHK, 10, 1, 2)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.ROCKY_LUGGEROTH, 10, 4, 5)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.RUGGED_LURMORUS, 10, 1, 3)))).func_205421_a(0.1f).func_205420_b(0.05f).func_205414_c(0.66f));
    }

    public static Biome makeMutantAgateWildwood() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(13948848, 15833793, 15381216), GaiaBiomes.mutantAgateWildwood(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.GROWTH_SAPPER, 40, 3, 5)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.MUTANT_GROWTH_EXTRACTOR, 5, 2, 4)))).func_205421_a(0.1f).func_205420_b(0.1f).func_205414_c(0.66f));
    }

    public static Biome makeVolcanicLands() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(0x232323, 4922905, 16086896), GaiaBiomes.volcanicLands(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.LESSER_SPITFIRE, 10, 2, 4)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 3)))).func_205421_a(1.0f).func_205420_b(0.7f).func_205414_c(0.9f));
    }

    public static Biome makeStaticWasteland() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(2837910, 2633554, 5690794), GaiaBiomes.staticWasteland(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.LESSER_SHOCKSHOOTER, 10, 2, 4)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 3)))).func_205421_a(3.0f).func_205420_b(0.05f).func_205414_c(0.4f));
    }

    public static Biome makeGoldstoneLands() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(0x232323, 0x222222, 12352044), GaiaBiomes.goldstoneLands(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.CORRUPT_SAPPER, 20, 2, 4)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.CONTORTED_NAGA, 10, 2, 3)))).func_205421_a(0.125f).func_205420_b(0.05f).func_205414_c(0.55f));
    }

    public static Biome makeCrystalPlains() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(15901620, 13016408, 15381216), GaiaBiomes.crystalPlains(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.GROWTH_SAPPER, 20, 4, 6)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.CRYSTAL_GOLEM, 15, 1, 3)))).func_205421_a(0.05f).func_205420_b(0.05f).func_205414_c(0.66f));
    }

    public static Biome makeSaltDunes() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(15901620, 13016408, 15381216), GaiaBiomes.saltDunes(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 3)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.SALTION, 15, 1, 3)))).func_205421_a(0.2f).func_205420_b(0.05f).func_205414_c(0.8f));
    }

    public static Biome makeSmolderingBog() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(0x262627, 0x111112, 0x322B33, 8284598), GaiaBiomes.smolderingBog(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.BISMUTH_ULETRUS, 20, 2, 3)))).func_205421_a(0.2f).func_205420_b(0.02f).func_205414_c(0.9f));
    }

    public static Biome makeShiningGrove() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(7982765, 0xDDF7FF, 15004627, 16764489), GaiaBiomes.shiningGrove(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)))).func_205421_a(0.4f).func_205420_b(0.05f).func_205414_c(0.5f));
    }

    public static Biome makeMineralReservoir() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(15901620, 13016408, 15381216), GaiaBiomes.mineralBiome(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns().func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners(ModEntities.MINERAL_ARENTHIS, 10, 1, 4)))).func_205421_a(-1.8f).func_205420_b(0.1f).func_205414_c(0.66f));
    }

    public static Biome makeMineralRiver() {
        return GaiaBiomes.buildBiome(GaiaBiomes.createBuilder(GaiaBiomes.createAmbience(15901620, 13016408, 15381216), GaiaBiomes.mineralBiome(), GaiaBiomes.buildSpawns(GaiaBiomes.createSpawns())).func_205421_a(-0.5f).func_205420_b(0.0f).func_205414_c(0.66f));
    }
}

