/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data;

import androsa.gaiadimension.data.provider.GaiaBlockLootTableProvider;
import androsa.gaiadimension.data.provider.GaiaEntityLootTableProvider;
import androsa.gaiadimension.registry.GaiaChestTables;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.registry.ModItems;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class GaiaLootTables
extends LootTableProvider {
    public static final float[] leaf_chances = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public GaiaLootTables(DataGenerator generator) {
        super(generator);
    }

    public String func_200397_b() {
        return "Gaia Dimension Loot Tables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(Entities::new, (Object)LootParameterSets.field_216263_d), (Object)Pair.of(Chests::new, (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationresults) {
    }

    public static class Chests
    extends ChestLootTables {
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_AMETHYST, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.purple_geode_slice.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.pyrite.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.scaynyx_ingot.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.sugilite_axe.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.proustite.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModBlocks.amethyst_bricks.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)9.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.old_bow.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.agate_arrow.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.white_opal.get())))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_COPAL, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.pink_geode_slice.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.pyrite.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.scaynyx_ingot.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.sugilite_axe.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.leucite.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModBlocks.copal_bricks.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)9.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.old_bow.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.agate_arrow.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.white_opal.get())))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_JADE, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.green_geode_slice.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.pyrite.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.scaynyx_ingot.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.sugilite_axe.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.euclase.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModBlocks.jade_bricks.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)9.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.old_bow.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.agate_arrow.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.white_opal.get())))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_JET, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.blue_geode_slice.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.pyrite.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.scaynyx_ingot.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.sugilite_axe.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ixiolite.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModBlocks.jet_bricks.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)9.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.old_bow.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.agate_arrow.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.white_opal.get())))));
            consumer.accept(GaiaChestTables.CHESTS_MALACHITE_WATCHTOWER, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModBlocks.malachite_bricks.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModBlocks.malachite_floor_tiles.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModBlocks.malachite_pillar.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.pyrite.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ixiolite_sword.get())).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.euclase_sword.get())).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.tiligr.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.proustite_helmet.get())).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.leucite_helmet.get())).func_216086_a(2))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ixiolite.get())).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.proustite.get())).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.euclase.get())).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.leucite.get())).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.green_opal.get())).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.white_opal.get())).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))));
        }
    }

    public static class Entities
    extends GaiaEntityLootTableProvider {
        public static final ResourceLocation PINK_SAPPER_TABLE = new ResourceLocation("gaiadimension", "entities/common_sapper");
        public static final ResourceLocation BLUE_SAPPER_TABLE = new ResourceLocation("gaiadimension", "entities/chilled_sapper");
        public static final ResourceLocation GREEN_SAPPER_TABLE = new ResourceLocation("gaiadimension", "entities/nutrient_sapper");
        public static final ResourceLocation PURPLE_SAPPER_TABLE = new ResourceLocation("gaiadimension", "entities/mystified_sapper");

        protected void addTables() {
            this.func_218582_a(ModEntities.AGATE_GOLEM, this.blankTable());
            this.func_218582_a(ModEntities.ANCIENT_LAGRAHK, this.blankTable());
            this.func_218582_a(ModEntities.ARCHAIC_WARRIOR, this.warriorTable());
            this.func_218582_a(ModEntities.BISMUTH_ULETRUS, this.blankTable());
            this.func_218582_a(ModEntities.CAVERN_TICK, this.singleDropTable((Supplier<Item>)ModItems.fine_thread, 0.0f, 1.0f));
            this.func_218582_a(ModEntities.CONTORTED_NAGA, this.singleDropTable((Supplier<Item>)ModItems.goldstone, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.CORRUPT_SAPPER, this.singleDropTable((Supplier<Item>)ModItems.goldstone_residue, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.CRYSTAL_GOLEM, this.blankTable());
            this.func_218582_a(ModEntities.GROWTH_SAPPER, this.blankTable());
            this.func_218585_a(PINK_SAPPER_TABLE, this.sapperTable((Supplier<Item>)ModItems.pink_geode));
            this.func_218585_a(BLUE_SAPPER_TABLE, this.sapperTable((Supplier<Item>)ModItems.blue_geode));
            this.func_218585_a(GREEN_SAPPER_TABLE, this.sapperTable((Supplier<Item>)ModItems.green_geode));
            this.func_218585_a(PURPLE_SAPPER_TABLE, this.sapperTable((Supplier<Item>)ModItems.purple_geode));
            this.func_218582_a(ModEntities.HOWLITE_WOLF, this.blankTable());
            this.func_218582_a(ModEntities.LESSER_SHOCKSHOOTER, this.singleDropTable((Supplier<Item>)ModItems.crystallized_lapis_lazuli, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.LESSER_SPITFIRE, this.singleDropTable((Supplier<Item>)ModItems.crystallized_redstone, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.MARKUZAR_PLANT, this.singleDropTable((Supplier<Item>)ModItems.markuzar_mint, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.MINERAL_ARENTHIS, this.cookableDoubleDropTable((Supplier<Item>)ModItems.large_tentacle, (Supplier<Item>)ModItems.sugar_cluster, 0.0f, 3.0f, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.MUCKLING, this.singleDropTable((Supplier<Item>)ModItems.sweet_muckball, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.MUTANT_GROWTH_EXTRACTOR, this.extractorTable());
            this.func_218582_a(ModEntities.NOMADIC_LAGRAHK, this.blankTable());
            this.func_218582_a(ModEntities.PRIMAL_BEAST, this.blankTable());
            this.func_218582_a(ModEntities.ROCKY_LUGGEROTH, this.cookableSingleDropTable((Supplier<Item>)ModItems.luggeroth_chop, 0.0f, 3.0f));
            this.func_218582_a(ModEntities.RUGGED_LURMORUS, this.cookableSingleDropTable((Supplier<Item>)ModItems.lurmorus_meat, 0.0f, 3.0f));
            this.func_218582_a(ModEntities.SALTION, this.singleDropTable((Supplier<Item>)ModItems.fine_thread, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.SHALLOW_ARENTHIS, this.cookableDoubleDropTable((Supplier<Item>)ModItems.small_tentacle, (Supplier<Item>)ModItems.sugar_crystals, 0.0f, 3.0f, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.SHALURKER, this.blankTable());
            this.func_218582_a(ModEntities.SPELLBOUND_ELEMENTAL, this.blankTable());
            this.func_218582_a(ModEntities.MALACHITE_DRONE, this.blankTable());
            this.func_218582_a(ModEntities.BLUE_HOWLITE_WOLF, this.blankTable());
            this.func_218582_a(ModEntities.MALACHITE_GUARD, this.malachiteGuardTable());
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(entity -> "gaiadimension".equals(entity.getRegistryName().func_110624_b())).collect(Collectors.toList());
        }
    }

    public static class Blocks
    extends GaiaBlockLootTableProvider {
        protected void addTables() {
            this.dropSelf(ModBlocks.keystone_block);
            this.dropSelf(ModBlocks.pyrite_torch);
            this.dropSelf(ModBlocks.agate_crafting_table);
            this.dropTable((Supplier<Block>)ModBlocks.crude_storage_crate, GaiaBlockLootTableProvider::smallCrate);
            this.dropTable((Supplier<Block>)ModBlocks.mega_storage_crate, GaiaBlockLootTableProvider::largeCrate);
            this.dropTable((Supplier<Block>)ModBlocks.gaia_stone_furnace, GaiaBlockLootTableProvider::withName);
            this.dropTable((Supplier<Block>)ModBlocks.restructurer, GaiaBlockLootTableProvider::withName);
            this.dropTable((Supplier<Block>)ModBlocks.purifier, GaiaBlockLootTableProvider::withName);
            this.dropSelf(ModBlocks.heavy_soil);
            this.dropSelf(ModBlocks.corrupt_soil);
            this.dropSelf(ModBlocks.boggy_soil);
            this.dropSelf(ModBlocks.light_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.glitter_grass, (Supplier<Block>)ModBlocks.heavy_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.corrupt_grass, (Supplier<Block>)ModBlocks.corrupt_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.murky_grass, (Supplier<Block>)ModBlocks.boggy_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.soft_grass, (Supplier<Block>)ModBlocks.light_soil);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.frail_glitter_block);
            this.dropSelf(ModBlocks.thick_glitter_block);
            this.dropSelf(ModBlocks.gummy_glitter_block);
            this.dropSelf(ModBlocks.pink_sludge_block);
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth, GaiaBlockLootTableProvider::withShards);
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_red, GaiaBlockLootTableProvider::withShards);
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_black, GaiaBlockLootTableProvider::withShards);
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_seared, GaiaBlockLootTableProvider::withShards);
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_mutant, GaiaBlockLootTableProvider::withShards);
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_aura, GaiaBlockLootTableProvider::withShards);
            this.dropSelf(ModBlocks.thiscus);
            this.dropSelf(ModBlocks.ouzium);
            this.dropSelf(ModBlocks.agathum);
            this.dropSelf(ModBlocks.varloom);
            this.dropSelf(ModBlocks.corrupted_varloom);
            this.dropSelf(ModBlocks.missingno_plant);
            this.dropSelf(ModBlocks.spotted_kersei);
            this.dropSelf(ModBlocks.thorny_wiltha);
            this.dropSelf(ModBlocks.roofed_agaric);
            this.dropSelf(ModBlocks.bulbous_hobina);
            this.dropSelf(ModBlocks.stickly_cupsir);
            this.dropSelf(ModBlocks.mystical_murgni);
            this.dropSelf(ModBlocks.corrupted_gaia_eye);
            this.dropSelf(ModBlocks.elder_imklia);
            this.dropSelf(ModBlocks.gold_orb_tucher);
            this.dropSelf(ModBlocks.missingno_fungus);
            this.dropSelf(ModBlocks.pink_agate_sapling);
            this.dropSelf(ModBlocks.blue_agate_sapling);
            this.dropSelf(ModBlocks.green_agate_sapling);
            this.dropSelf(ModBlocks.purple_agate_sapling);
            this.dropSelf(ModBlocks.fossilized_sapling);
            this.dropSelf(ModBlocks.corrupted_sapling);
            this.dropSelf(ModBlocks.burnt_sapling);
            this.dropSelf(ModBlocks.burning_sapling);
            this.dropSelf(ModBlocks.aura_sapling);
            this.dropChance((Supplier<? extends Block>)ModBlocks.pink_agate_leaves, (Supplier<? extends Block>)ModBlocks.pink_agate_sapling, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.blue_agate_leaves, (Supplier<? extends Block>)ModBlocks.blue_agate_sapling, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.green_agate_leaves, (Supplier<? extends Block>)ModBlocks.green_agate_sapling, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.purple_agate_leaves, (Supplier<? extends Block>)ModBlocks.purple_agate_sapling, leaf_chances);
            this.dropChanceAlternative((Supplier<? extends Block>)ModBlocks.fossilized_leaves, (Supplier<? extends Block>)ModBlocks.fossilized_sapling, (Supplier<Item>)ModItems.fine_dust, leaf_chances);
            this.dropChanceAlternative((Supplier<? extends Block>)ModBlocks.corrupted_leaves, (Supplier<? extends Block>)ModBlocks.corrupted_sapling, (Supplier<Item>)ModItems.goldstone_dust, leaf_chances);
            this.dropChanceAlternative((Supplier<? extends Block>)ModBlocks.burnt_leaves, (Supplier<? extends Block>)ModBlocks.burnt_sapling, () -> Items.field_151016_H, leaf_chances);
            this.dropChanceAlternative((Supplier<? extends Block>)ModBlocks.burning_leaves, (Supplier<? extends Block>)ModBlocks.burning_sapling, (Supplier<Item>)ModItems.hot_dust, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.aura_leaves, (Supplier<? extends Block>)ModBlocks.aura_sapling, leaf_chances);
            this.dropSelf(ModBlocks.pink_agate_log);
            this.dropSelf(ModBlocks.blue_agate_log);
            this.dropSelf(ModBlocks.green_agate_log);
            this.dropSelf(ModBlocks.purple_agate_log);
            this.dropSelf(ModBlocks.fossilized_log);
            this.dropSelf(ModBlocks.corrupted_log);
            this.dropSelf(ModBlocks.burnt_log);
            this.dropSelf(ModBlocks.burning_log);
            this.dropSelf(ModBlocks.aura_log);
            this.dropSelf(ModBlocks.stripped_pink_agate_log);
            this.dropSelf(ModBlocks.stripped_blue_agate_log);
            this.dropSelf(ModBlocks.stripped_green_agate_log);
            this.dropSelf(ModBlocks.stripped_purple_agate_log);
            this.dropSelf(ModBlocks.stripped_fossilized_log);
            this.dropSelf(ModBlocks.stripped_corrupted_log);
            this.dropSelf(ModBlocks.stripped_burnt_log);
            this.dropSelf(ModBlocks.stripped_burning_log);
            this.dropSelf(ModBlocks.stripped_aura_log);
            this.dropSelf(ModBlocks.pink_agate_wood);
            this.dropSelf(ModBlocks.blue_agate_wood);
            this.dropSelf(ModBlocks.green_agate_wood);
            this.dropSelf(ModBlocks.purple_agate_wood);
            this.dropSelf(ModBlocks.fossilized_wood);
            this.dropSelf(ModBlocks.corrupted_wood);
            this.dropSelf(ModBlocks.burnt_wood);
            this.dropSelf(ModBlocks.burning_wood);
            this.dropSelf(ModBlocks.aura_wood);
            this.dropSelf(ModBlocks.stripped_pink_agate_wood);
            this.dropSelf(ModBlocks.stripped_blue_agate_wood);
            this.dropSelf(ModBlocks.stripped_green_agate_wood);
            this.dropSelf(ModBlocks.stripped_purple_agate_wood);
            this.dropSelf(ModBlocks.stripped_fossilized_wood);
            this.dropSelf(ModBlocks.stripped_corrupted_wood);
            this.dropSelf(ModBlocks.stripped_burnt_wood);
            this.dropSelf(ModBlocks.stripped_burning_wood);
            this.dropSelf(ModBlocks.stripped_aura_wood);
            this.dropSelf(ModBlocks.salt);
            this.dropSelf(ModBlocks.saltstone);
            this.dropAlternative((Supplier<Block>)ModBlocks.pebbles, (Supplier<Item>)ModItems.sturdy_pebble);
            this.dropWithSilk((Supplier<Block>)ModBlocks.gaia_stone, (Supplier<Block>)ModBlocks.gaia_cobblestone);
            this.dropSelf(ModBlocks.gaia_cobblestone);
            this.dropSelf(ModBlocks.wasteland_stone);
            this.dropSelf(ModBlocks.static_stone);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.charged_mineral);
            this.dropSelf(ModBlocks.volcanic_rock);
            this.dropSelf(ModBlocks.searing_rock);
            this.dropSelf(ModBlocks.primal_mass);
            this.dropSelf(ModBlocks.impure_rock);
            this.dropSelf(ModBlocks.active_rock);
            this.dropSelf(ModBlocks.impure_sludge);
            this.dropSelf(ModBlocks.geyser_block);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.sparkling_rock);
            this.dropSelf(ModBlocks.aura_shoot);
            this.dropSelf(ModBlocks.pink_agate_planks);
            this.dropSelf(ModBlocks.blue_agate_planks);
            this.dropSelf(ModBlocks.green_agate_planks);
            this.dropSelf(ModBlocks.purple_agate_planks);
            this.dropSelf(ModBlocks.fossilized_planks);
            this.dropSelf(ModBlocks.corrupted_planks);
            this.dropSelf(ModBlocks.burnt_planks);
            this.dropSelf(ModBlocks.burning_planks);
            this.dropSelf(ModBlocks.aura_planks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.pink_agate_plank_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.blue_agate_plank_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.green_agate_plank_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.purple_agate_plank_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.fossilized_plank_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.corrupted_plank_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.burnt_plank_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.burning_plank_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.aura_plank_slab);
            this.dropSelf(ModBlocks.pink_agate_plank_stairs);
            this.dropSelf(ModBlocks.blue_agate_plank_stairs);
            this.dropSelf(ModBlocks.green_agate_plank_stairs);
            this.dropSelf(ModBlocks.purple_agate_plank_stairs);
            this.dropSelf(ModBlocks.fossilized_plank_stairs);
            this.dropSelf(ModBlocks.corrupted_plank_stairs);
            this.dropSelf(ModBlocks.burnt_plank_stairs);
            this.dropSelf(ModBlocks.burning_plank_stairs);
            this.dropSelf(ModBlocks.aura_plank_stairs);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.cloudy_glass);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.foggy_glass);
            this.dropSelf(ModBlocks.gaia_stone_bricks);
            this.dropSelf(ModBlocks.cracked_gaia_stone_bricks);
            this.dropSelf(ModBlocks.crusted_gaia_stone_bricks);
            this.dropSelf(ModBlocks.raw_jade);
            this.dropSelf(ModBlocks.jade_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.jade_brick_slab);
            this.dropSelf(ModBlocks.jade_brick_stairs);
            this.dropSelf(ModBlocks.cracked_jade_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.cracked_jade_brick_slab);
            this.dropSelf(ModBlocks.cracked_jade_brick_stairs);
            this.dropSelf(ModBlocks.crusted_jade_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.crusted_jade_brick_slab);
            this.dropSelf(ModBlocks.crusted_jade_brick_stairs);
            this.dropSelf(ModBlocks.raw_copal);
            this.dropSelf(ModBlocks.copal_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.copal_brick_slab);
            this.dropSelf(ModBlocks.copal_brick_stairs);
            this.dropSelf(ModBlocks.cracked_copal_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.cracked_copal_brick_slab);
            this.dropSelf(ModBlocks.cracked_copal_brick_stairs);
            this.dropSelf(ModBlocks.crusted_copal_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.crusted_copal_brick_slab);
            this.dropSelf(ModBlocks.crusted_copal_brick_stairs);
            this.dropSelf(ModBlocks.raw_jet);
            this.dropSelf(ModBlocks.jet_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.jet_brick_slab);
            this.dropSelf(ModBlocks.jet_brick_stairs);
            this.dropSelf(ModBlocks.cracked_jet_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.cracked_jet_brick_slab);
            this.dropSelf(ModBlocks.cracked_jet_brick_stairs);
            this.dropSelf(ModBlocks.crusted_jet_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.crusted_jet_brick_slab);
            this.dropSelf(ModBlocks.crusted_jet_brick_stairs);
            this.dropSelf(ModBlocks.raw_amethyst);
            this.dropSelf(ModBlocks.amethyst_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.amethyst_brick_slab);
            this.dropSelf(ModBlocks.amethyst_brick_stairs);
            this.dropSelf(ModBlocks.cracked_amethyst_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.cracked_amethyst_brick_slab);
            this.dropSelf(ModBlocks.cracked_amethyst_brick_stairs);
            this.dropSelf(ModBlocks.crusted_amethyst_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.crusted_amethyst_brick_slab);
            this.dropSelf(ModBlocks.crusted_amethyst_brick_stairs);
            this.dropSelf(ModBlocks.reinforced_bricks);
            this.dropSelf(ModBlocks.bolstered_bricks);
            this.dropSelf(ModBlocks.malachite_bricks);
            this.dropSelf(ModBlocks.malachite_cracked_bricks);
            this.dropSelf(ModBlocks.malachite_crusted_bricks);
            this.dropSelf(ModBlocks.malachite_floor_tiles);
            this.dropSelf(ModBlocks.malachite_chisel_bricks);
            this.dropSelf(ModBlocks.malachite_pulsing_bricks);
            this.dropSelf(ModBlocks.malachite_pulsing_tiles);
            this.dropSelf(ModBlocks.malachite_pulsing_chisel);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.malachite_brick_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.malachite_cracked_brick_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.malachite_crusted_brick_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.malachite_floor_slab);
            this.dropSelf(ModBlocks.malachite_pillar);
            this.dropSelf(ModBlocks.malachite_brick_stairs);
            this.dropSelf(ModBlocks.malachite_cracked_brick_stairs);
            this.dropSelf(ModBlocks.malachite_crusted_brick_stairs);
            this.dropSelf(ModBlocks.malachite_floor_stairs);
            this.dropSelf(ModBlocks.malachite_chisel_stairs);
            this.dropSelf(ModBlocks.malachite_pulsing_brick_stairs);
            this.dropSelf(ModBlocks.malachite_pulsing_floor_stairs);
            this.dropSelf(ModBlocks.malachite_pulsing_chisel_stairs);
            this.dropSelf(ModBlocks.malachite_pillar_stairs);
            this.dropSelf(ModBlocks.sugilite_block);
            this.dropSelf(ModBlocks.hematite_block);
            this.dropSelf(ModBlocks.cinnabar_block);
            this.dropSelf(ModBlocks.labradorite_block);
            this.dropSelf(ModBlocks.moonstone_block);
            this.dropSelf(ModBlocks.opal_block_red);
            this.dropSelf(ModBlocks.opal_block_blue);
            this.dropSelf(ModBlocks.opal_block_green);
            this.dropSelf(ModBlocks.opal_block_white);
            this.dropSelf(ModBlocks.pyrite_block);
            this.dropSelf(ModBlocks.tektite_block);
            this.dropSelf(ModBlocks.goldstone_block);
            this.dropSelf(ModBlocks.aura_block);
            this.dropSelf(ModBlocks.bismuth_block);
            this.dropSelf(ModBlocks.ixiolite_block);
            this.dropSelf(ModBlocks.proustite_block);
            this.dropSelf(ModBlocks.euclase_block);
            this.dropSelf(ModBlocks.leucite_block);
            this.dropSelf(ModBlocks.carnelian_block);
            this.dropSelf(ModBlocks.benitoite_block);
            this.dropSelf(ModBlocks.diopside_block);
            this.dropSelf(ModBlocks.chalcedony_block);
            this.dropWithFortune((Supplier<Block>)ModBlocks.sugilite_ore, (Supplier<Item>)ModItems.sugilite);
            this.dropWithFortune((Supplier<Block>)ModBlocks.hematite_ore, (Supplier<Item>)ModItems.hematite);
            this.dropWithFortune((Supplier<Block>)ModBlocks.cinnabar_ore, (Supplier<Item>)ModItems.cinnabar);
            this.dropWithFortune((Supplier<Block>)ModBlocks.labradorite_ore, (Supplier<Item>)ModItems.labradorite);
            this.dropWithFortune((Supplier<Block>)ModBlocks.moonstone_ore, (Supplier<Item>)ModItems.moonstone);
            this.dropWithFortune((Supplier<Block>)ModBlocks.opal_ore_red, (Supplier<Item>)ModItems.red_opal);
            this.dropWithFortune((Supplier<Block>)ModBlocks.opal_ore_blue, (Supplier<Item>)ModItems.blue_opal);
            this.dropWithFortune((Supplier<Block>)ModBlocks.opal_ore_green, (Supplier<Item>)ModItems.green_opal);
            this.dropWithFortune((Supplier<Block>)ModBlocks.opal_ore_white, (Supplier<Item>)ModItems.white_opal);
            this.dropWithFortune((Supplier<Block>)ModBlocks.pyrite_ore, (Supplier<Item>)ModItems.pyrite);
            this.dropSelf(ModBlocks.speckled_rock);
            this.dropSelf(ModBlocks.coarse_rock);
            this.dropSelf(ModBlocks.precious_rock);
            this.dropPot(ModBlocks.potted_thiscus);
            this.dropPot(ModBlocks.potted_ouzium);
            this.dropPot(ModBlocks.potted_agathum);
            this.dropPot(ModBlocks.potted_varloom);
            this.dropPot(ModBlocks.potted_corrupted_varloom);
            this.dropPot(ModBlocks.potted_missingno_plant);
            this.dropPot(ModBlocks.potted_spotted_kersei);
            this.dropPot(ModBlocks.potted_thorny_wiltha);
            this.dropPot(ModBlocks.potted_roofed_agaric);
            this.dropPot(ModBlocks.potted_bulbous_hobina);
            this.dropPot(ModBlocks.potted_stickly_cupsir);
            this.dropPot(ModBlocks.potted_mystical_murgni);
            this.dropPot(ModBlocks.potted_corrupted_gaia_eye);
            this.dropPot(ModBlocks.potted_elder_imklia);
            this.dropPot(ModBlocks.potted_gold_orb_tucher);
            this.dropPot(ModBlocks.potted_missingno_fungus);
            this.dropPot(ModBlocks.potted_pink_agate_sapling);
            this.dropPot(ModBlocks.potted_blue_agate_sapling);
            this.dropPot(ModBlocks.potted_green_agate_sapling);
            this.dropPot(ModBlocks.potted_purple_agate_sapling);
            this.dropPot(ModBlocks.potted_fossilized_sapling);
            this.dropPot(ModBlocks.potted_corrupted_sapling);
            this.dropPot(ModBlocks.potted_burnt_sapling);
            this.dropPot(ModBlocks.potted_burning_sapling);
            this.dropPot(ModBlocks.potted_aura_sapling);
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

