/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ConfiguredFeaturesProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final DataGenerator generator;

    public ConfiguredFeaturesProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public String func_200397_b() {
        return "Configured Features";
    }

    public void func_200398_a(DirectoryCache cache) {
        LOGGER.info("Starting Feature Gen");
        Path output = this.generator.func_200391_b();
        for (Map.Entry<RegistryKey<ConfiguredFeature<?, ?>>, ConfiguredFeature<?, ?>> feature : this.registerFeatures().entrySet()) {
            Path path = ConfiguredFeaturesProvider.getPath(output, feature.getKey().func_240901_a_());
            Function featuredata = JsonOps.INSTANCE.withEncoder((Encoder)ConfiguredFeature.field_236264_b_);
            try {
                Optional optional = ((DataResult)featuredata.apply(feature::getValue)).result();
                if (optional.isPresent()) {
                    IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((JsonElement)optional.get()), (Path)path);
                    continue;
                }
                LOGGER.error("Couldn't serialize feature {}", (Object)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save biome {}", (Object)path, (Object)e);
            }
        }
        LOGGER.info("Finished Feature Gen");
    }

    protected abstract Map<RegistryKey<ConfiguredFeature<?, ?>>, ConfiguredFeature<?, ?>> registerFeatures();

    private static Path getPath(Path path, ResourceLocation loc) {
        return path.resolve("data/" + loc.func_110624_b() + "/worldgen/configured_feature/" + loc.func_110623_a() + ".json");
    }
}

