/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data.provider;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.registry.GaiaBiomeFeatures;
import androsa.gaiadimension.registry.ModEntities;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.data.BiomeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;

public abstract class GaiaBiomeProvider
extends BiomeProvider {
    public GaiaBiomeProvider(DataGenerator generator) {
        super(generator);
    }

    public void func_200398_a(DirectoryCache dir) {
        GaiaDimensionMod.LOGGER.info("Gaia Biomes starting generation...");
        Path out = this.field_244197_d.func_200391_b();
        for (Map.Entry<RegistryKey<Biome>, Biome> biome : this.registerBiomes().entrySet()) {
            Path path = GaiaBiomeProvider.getPath(out, biome.getKey().func_240901_a_());
            Biome obj = biome.getValue();
            obj.setRegistryName(biome.getKey().func_240901_a_());
            Function biomedata = JsonOps.INSTANCE.withEncoder((Encoder)Biome.field_235051_b_);
            try {
                Optional element = ((DataResult)biomedata.apply(biome::getValue)).result();
                if (element.isPresent()) {
                    IDataProvider.func_218426_a((Gson)field_244196_c, (DirectoryCache)dir, (JsonElement)((JsonElement)element.get()), (Path)path);
                    continue;
                }
                GaiaDimensionMod.LOGGER.error("Couldn't serialize biome {}", (Object)path);
            }
            catch (IOException e) {
                GaiaDimensionMod.LOGGER.error("Couldn't save biome {}", (Object)path, (Object)e);
            }
        }
        GaiaDimensionMod.LOGGER.info("Gaia Biomes finished generating!");
    }

    private static Path getPath(Path path, ResourceLocation loc) {
        return path.resolve("data/" + loc.func_110624_b() + "/worldgen/biome/" + loc.func_110623_a() + ".json");
    }

    protected abstract Map<RegistryKey<Biome>, Biome> registerBiomes();

    public static Biome buildBiome(Biome.Builder builder) {
        return builder.func_242455_a();
    }

    public static Biome.Builder createBuilder(BiomeAmbience ambience, BiomeGenerationSettings settings, MobSpawnInfo info) {
        return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205417_d(0.0f).func_205419_a(Biome.Category.NONE).func_242456_a(Biome.TemperatureModifier.NONE).func_235097_a_(ambience).func_242457_a(settings).func_242458_a(info);
    }

    public static BiomeAmbience createAmbience(int plant, int sky, int fog) {
        return GaiaBiomeProvider.createAmbience(plant, plant, sky, fog);
    }

    public static BiomeAmbience createAmbience(int grass, int foliage, int sky, int fog) {
        return new BiomeAmbience.Builder().func_242541_f(grass).func_242540_e(foliage).func_242539_d(sky).func_235239_a_(fog).func_235246_b_(7117233).func_235248_c_(9617108).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_();
    }

    public static BiomeGenerationSettings.Builder createSettings() {
        return new BiomeGenerationSettings.Builder().func_242512_a(GenerationStage.Carving.AIR, GaiaBiomeFeatures.crystal_caves).func_242512_a(GenerationStage.Carving.AIR, GaiaBiomeFeatures.chasms).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_primal_mass).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_pebbles).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_speckled_rock).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_coarse_rock).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_precious_rock).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_sugilite).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_hematite).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_pyrite).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_cinnabar).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_labradorite).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_moonstone).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.crystal_fungi_caves);
    }

    public static MobSpawnInfo buildSpawns(MobSpawnInfo.Builder builder) {
        return builder.func_242577_b();
    }

    public static MobSpawnInfo.Builder createSpawns() {
        return new MobSpawnInfo.Builder().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.CAVERN_TICK, 65, 2, 4)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.SHALURKER, 65, 2, 4)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.ARCHAIC_WARRIOR, 65, 2, 4)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.MUCKLING, 65, 2, 4)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 5, 1, 2)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.PRIMAL_BEAST, 15, 1, 2)).func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners(ModEntities.SHALLOW_ARENTHIS, 10, 2, 4));
    }

    public static BiomeGenerationSettings pinkAgateForest() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_glitter_heavy_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_amethyst).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_copal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_red_opal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_white_opal_rare).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.pink_agate_tree_common).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_03).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_common).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.spotted_kersei).func_242516_a(GaiaBiomeFeatures.mini_tower).func_242516_a(GaiaBiomeFeatures.malachite_watchtower).func_242508_a();
    }

    public static BiomeGenerationSettings blueAgateTaiga() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_glitter_heavy_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_amethyst).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jet).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_blue_opal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_white_opal_rare).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.blue_agate_tree).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_02).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_common).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.thorny_wiltha).func_242516_a(GaiaBiomeFeatures.mini_tower).func_242508_a();
    }

    public static BiomeGenerationSettings greenAgateJungle() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_glitter_heavy_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_copal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jade).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_green_opal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_white_opal_rare).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.green_agate_tree).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.green_agate_bush).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_04).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_common).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.roofed_agaric).func_242516_a(GaiaBiomeFeatures.mini_tower).func_242516_a(GaiaBiomeFeatures.malachite_watchtower).func_242508_a();
    }

    public static BiomeGenerationSettings purpleAgateSwamp() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_glitter_heavy_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_sweet_muck).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_uncommon).func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, GaiaBiomeFeatures.gummy_glitter_blob).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_thick_glitter).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_amethyst).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jade).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_white_opal_rare).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.purple_agate_tree).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_02).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_rare).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.bulbous_hobina).func_242516_a(GaiaBiomeFeatures.mini_tower).func_242508_a();
    }

    public static BiomeGenerationSettings fossilWoodland() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_glitter_heavy_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_copal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jet).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.fossilized_tree).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_02).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_common).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.stickly_cupsir).func_242516_a(GaiaBiomeFeatures.mini_tower).func_242508_a();
    }

    public static BiomeGenerationSettings mutantAgateWildwood() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_glitter_heavy_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_amethyst).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jade).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_red_opal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_blue_opal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_green_opal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_white_opal_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.various_agate_trees).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_mutant).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.mystical_murgni).func_242516_a(GaiaBiomeFeatures.mini_tower).func_242508_a();
    }

    public static BiomeGenerationSettings volcanicLands() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.v_glitter_heavy_volrock).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_common).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_rare).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_searing_rock).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_copal).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.burnt_agate_tree).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.fiery_agate_tree).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_seared).func_242508_a();
    }

    public static BiomeGenerationSettings staticWasteland() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.s_wasteland_stone).func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, GaiaBiomeFeatures.static_spikes).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_static_stone).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_amethyst).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.disk_static_stone).func_242508_a();
    }

    public static BiomeGenerationSettings goldstoneLands() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_corrupt_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jet).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.goldstone_tree).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_corrupt).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_corrupt).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.corrupted_gaia_eye).func_242508_a();
    }

    public static BiomeGenerationSettings crystalPlains() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_glitter_heavy_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_amethyst).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jade).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.pink_agate_tree_rare).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_05).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_common).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.spotted_kersei).func_242516_a(GaiaBiomeFeatures.mini_tower).func_242516_a(GaiaBiomeFeatures.malachite_watchtower).func_242508_a();
    }

    public static BiomeGenerationSettings saltDunes() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_salty).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_rare).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_amethyst).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jet).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242508_a();
    }

    public static BiomeGenerationSettings smolderingBog() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_murky_boggy_pebble).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_liquid_bismuth).func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, GaiaBiomeFeatures.bismuth_spires).func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, GaiaBiomeFeatures.bismuth_geysers).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_amethyst).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jet).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.disk_bog_patch).func_242508_a();
    }

    public static BiomeGenerationSettings shiningGrove() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_soft_light_salt).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_liquid_aura).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_copal).func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, GaiaBiomeFeatures.ore_raw_jade).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.aura_tree).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.aura_shoots).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_growth_aura).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GaiaBiomeFeatures.crystal_blooms_common).func_242508_a();
    }

    public static BiomeGenerationSettings mineralBiome() {
        return GaiaBiomeProvider.createSettings().func_242517_a(GaiaBiomeFeatures.d_salty).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_superhot_magma_rare).func_242513_a(GenerationStage.Decoration.LAKES, GaiaBiomeFeatures.lake_mineral_water_common).func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, GaiaBiomeFeatures.underground_glitter_blob).func_242508_a();
    }
}

