/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data.provider;

import androsa.gaiadimension.data.provider.GaiaBlockModelProvider;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public abstract class GaiaBlockStateProvider
extends BlockStateProvider {
    private final GaiaBlockModelProvider blockModels;

    public GaiaBlockStateProvider(DataGenerator generator, String modid, ExistingFileHelper helper) {
        super(generator, modid, helper);
        this.blockModels = new GaiaBlockModelProvider(generator, helper){

            protected void registerModels() {
            }

            public String func_200397_b() {
                return GaiaBlockStateProvider.this.func_200397_b();
            }
        };
    }

    public GaiaBlockModelProvider models() {
        return this.blockModels;
    }

    protected ResourceLocation tLocGaia(String name) {
        return this.modLoc("block/" + name);
    }

    protected String blockName(RegistryObject<? extends Block> block) {
        return block.getId().func_110623_a();
    }

    public void basicBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    public void sidedBlock(RegistryObject<Block> block, String top, String bottom, String north, String south, String east, String west) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cube(this.blockName(block), this.tLocGaia(bottom), this.tLocGaia(top), this.tLocGaia(north), this.tLocGaia(south), this.tLocGaia(east), this.tLocGaia(west)));
    }

    public void basicBlockRotated(Supplier<Block> block) {
        this.simpleBlock(block.get(), model -> ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false));
    }

    public void basicBlockLayered(RegistryObject<Block> block, String bottom, String top) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().basicLayered(block, this.tLocGaia(bottom), this.tLocGaia(top)));
    }

    public void logBlock(Supplier<RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), this.tLocGaia(name));
    }

    public void strippedLogBlock(Supplier<RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), this.tLocGaia("stripped_" + name));
    }

    public void strippedWoodBlock(RegistryObject<RotatedPillarBlock> block, String name) {
        ModelBuilder model = this.models().cubeColumn(this.blockName(block), this.tLocGaia("stripped_" + name + "_log_side"), this.tLocGaia("stripped_" + name + "_log_side"));
        this.axisBlock((RotatedPillarBlock)block.get(), (ModelFile)model, (ModelFile)model);
    }

    public void woodBlock(RegistryObject<RotatedPillarBlock> block, String name) {
        ModelBuilder model = this.models().cubeColumn(this.blockName(block), this.tLocGaia(name + "_side"), this.tLocGaia(name + "_side"));
        this.axisBlock((RotatedPillarBlock)block.get(), (ModelFile)model, (ModelFile)model);
    }

    public void stairsBlock(RegistryObject<StairsBlock> block, String name) {
        this.stairsBlock((StairsBlock)block.get(), this.tLocGaia(name));
    }

    public void stairsBlockLayered(RegistryObject<StairsBlock> block, String inner, String outer) {
        BlockModelBuilder stairs = this.models().stairsBasicLayer(block, this.tLocGaia(inner), this.tLocGaia(outer));
        BlockModelBuilder stairsInner = this.models().stairsInnerBasicLayer(block, this.tLocGaia(inner), this.tLocGaia(outer));
        BlockModelBuilder stairsOuter = this.models().stairsOuterBasicLayer(block, this.tLocGaia(inner), this.tLocGaia(outer));
        this.stairsBlock((StairsBlock)block.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    public void slabBlock(RegistryObject<SlabBlock> block, RegistryObject<Block> doubleBlock) {
        this.slabBlock((SlabBlock)block.get(), this.tLocGaia(this.blockName(doubleBlock)), this.tLocGaia(this.blockName(doubleBlock)));
    }

    public void crossBlock(RegistryObject<? extends Block> block) {
        this.crossBlock((Supplier<? extends Block>)block, (ModelFile)this.models().cross(this.blockName(block), this.tLocGaia(this.blockName(block))));
    }

    public void crossBlockTinted(RegistryObject<Block> block) {
        this.crossBlock((Supplier<? extends Block>)block, (ModelFile)this.models().tintedCross(this.blockName(block), this.tLocGaia(this.blockName(block))));
    }

    public void orientableBlockLit(RegistryObject<Block> block) {
        ModelBuilder off = this.models().orientable(this.blockName(block), this.tLocGaia(this.blockName(block) + "_side"), this.tLocGaia(this.blockName(block) + "_front"), this.tLocGaia(this.blockName(block) + "_top"));
        ModelBuilder on = this.models().orientable(this.blockName(block) + "_lit", this.tLocGaia(this.blockName(block) + "_side"), this.tLocGaia(this.blockName(block) + "_front_lit"), this.tLocGaia(this.blockName(block) + "_top"));
        this.orientableBlock(block, (ModelFile)off, (ModelFile)on);
    }

    public void orientableBlockBasicLit(RegistryObject<Block> block) {
        ModelBuilder off = this.models().orientable(this.blockName(block), this.tLocGaia(this.blockName(block) + "_side"), this.tLocGaia(this.blockName(block) + "_front"), this.tLocGaia(this.blockName(block) + "_side"));
        ModelBuilder on = this.models().orientable(this.blockName(block) + "_lit", this.tLocGaia(this.blockName(block) + "_side"), this.tLocGaia(this.blockName(block) + "_front_lit"), this.tLocGaia(this.blockName(block) + "_side"));
        this.orientableBlock(block, (ModelFile)off, (ModelFile)on);
    }

    public void grassBlock(RegistryObject<Block> block, String bottom) {
        String baseName = this.blockName(block);
        BlockModelBuilder model = this.models().grass(block, this.tLocGaia(baseName + "_top"), this.tLocGaia(bottom), this.tLocGaia(baseName + "_side"), this.tLocGaia(baseName + "_overlay"));
        this.grassBlock((Supplier<Block>)block, (ModelFile)model);
    }

    public void pottedPlantBlock(RegistryObject<FlowerPotBlock> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().flowerPot(block));
    }

    public void torchBlock(RegistryObject<Block> block, RegistryObject<Block> wall) {
        ModelBuilder torch = this.models().torch(this.blockName(block), this.tLocGaia(this.blockName(block)));
        ModelBuilder torchwall = this.models().torchWall(this.blockName(wall), this.tLocGaia(this.blockName(block)));
        this.simpleBlock((Block)block.get(), (ModelFile)torch);
        this.getVariantBuilder((Block)wall.get()).forAllStates(arg_0 -> GaiaBlockStateProvider.lambda$torchBlock$1((ModelFile)torchwall, arg_0));
    }

    private void orientableBlock(RegistryObject<Block> block, ModelFile off, ModelFile on) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            ModelFile model = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? on : off;
            return ConfiguredModel.builder().modelFile(model).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build();
        });
    }

    private void crossBlock(Supplier<? extends Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    private void grassBlock(Supplier<Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$1(ModelFile torchwall, BlockState state) {
        return ConfiguredModel.builder().modelFile(torchwall).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 90) % 360).build();
    }
}

