/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.registry.ModSounds;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GrowthSapperEntity
extends CreatureEntity {
    private static final DataParameter<Integer> SAPPER_VARIANT = EntityDataManager.func_187226_a(GrowthSapperEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public GrowthSapperEntity(EntityType<? extends GrowthSapperEntity> entity, World world) {
        super(entity, world);
        this.field_70728_aV = 1 + this.field_70146_Z.nextInt(3);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SAPPER_VARIANT, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.5));
    }

    public int getEntityVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(SAPPER_VARIANT)), (int)0, (int)3);
    }

    public void setSapperVariant(int type) {
        this.field_70180_af.func_187227_b(SAPPER_VARIANT, (Object)type);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSapperVariant(compound.func_74762_e("SapperVariant"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("SapperVariant", this.getEntityVariant());
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.ENTITY_GROWTH_SAPPER_DEATH;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.ENTITY_GROWTH_SAPPER_HURT;
    }

    public ResourceLocation func_184647_J() {
        switch (this.getEntityVariant()) {
            default: {
                return this.getLocation("common_sapper");
            }
            case 1: {
                return this.getLocation("chilled_sapper");
            }
            case 2: {
                return this.getLocation("nutrient_sapper");
            }
            case 3: 
        }
        return this.getLocation("mystified_sapper");
    }

    private ResourceLocation getLocation(String name) {
        return new ResourceLocation("gaiadimension", "entities/" + name);
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.7f;
    }

    public static boolean canSpawnHere(EntityType<GrowthSapperEntity> entity, IWorld world, SpawnReason spawn, BlockPos pos, Random random) {
        return spawn == SpawnReason.SPAWNER || world.func_180495_p(pos.func_177977_b()).func_215688_a((IBlockReader)world, pos.func_177977_b(), entity) && world.func_226659_b_(pos, 0) > 8;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Optional biome = worldIn.func_242406_i(this.func_233580_cy_());
        if (Objects.equals(biome, Optional.of(ModBiomes.pink_agate_forest)) || Objects.equals(biome, Optional.of(ModBiomes.crystal_plains))) {
            this.setSapperVariant(0);
        } else if (Objects.equals(biome, Optional.of(ModBiomes.blue_agate_taiga))) {
            this.setSapperVariant(1);
        } else if (Objects.equals(biome, Optional.of(ModBiomes.green_agate_jungle))) {
            this.setSapperVariant(2);
        } else if (Objects.equals(biome, Optional.of(ModBiomes.purple_agate_swamp))) {
            this.setSapperVariant(3);
        } else {
            Random rand = new Random();
            this.setSapperVariant(rand.nextInt(4));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }
}

