/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.registry.ModSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MineralArenthisEntity
extends WaterMobEntity {
    public float arenthisPitch;
    public float prevArenthisPitch;
    public float arenthisYaw;
    public float prevArenthisYaw;
    public float arenthisRotation;
    public float prevArenthisRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public MineralArenthisEntity(EntityType<? extends MineralArenthisEntity> entity, World worldIn) {
        super(entity, worldIn);
        this.field_70728_aV = 5;
        this.field_70146_Z.setSeed(1 + this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MoveRandomGoal(this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0);
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.ENTITY_MINERAL_ARENTHIS_DEATH;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.ENTITY_MINERAL_ARENTHIS_HURT;
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_213302_cg() * 0.85f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevArenthisPitch = this.arenthisPitch;
        this.prevArenthisYaw = this.arenthisYaw;
        this.prevArenthisRotation = this.arenthisRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.arenthisRotation += this.rotationVelocity;
        if ((double)this.arenthisRotation > Math.PI * 2) {
            if (this.field_70170_p.func_201670_d()) {
                this.arenthisRotation = (float)Math.PI * 2;
            } else {
                this.arenthisRotation = (float)((double)this.arenthisRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.arenthisRotation < (float)Math.PI) {
                float f = this.arenthisRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.func_201670_d()) {
                this.func_213293_j(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vector3d vec3d = this.func_213322_ci();
            float f1 = MathHelper.func_76133_a((double)MineralArenthisEntity.func_213296_b((Vector3d)vec3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.arenthisYaw = (float)((double)this.arenthisYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.arenthisPitch += (-((float)MathHelper.func_181159_b((double)f1, (double)vec3d.field_72448_b)) * 57.295776f - this.arenthisPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.arenthisRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.func_201670_d()) {
                double d0 = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d0 = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    d0 -= 0.08;
                }
                this.func_213293_j(0.0, d0 * (double)0.98f, 0.0);
            }
            this.arenthisPitch = (float)((double)this.arenthisPitch + (double)(-90.0f - this.arenthisPitch) * 0.02);
        }
    }

    public static boolean canSpawnHere(EntityType<MineralArenthisEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return pos.func_177956_o() > 30 && pos.func_177956_o() < 50;
    }

    public void func_213352_e(Vector3d motion) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            this.arenthisRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    static class MoveRandomGoal
    extends Goal {
        private final MineralArenthisEntity arenthis;

        public MoveRandomGoal(MineralArenthisEntity entity) {
            this.arenthis = entity;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.arenthis.func_70654_ax();
            if (i > 100) {
                this.arenthis.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.arenthis.func_70681_au().nextInt(50) == 0 || !this.arenthis.field_70171_ac || !this.arenthis.hasMovementVector()) {
                float randomVec = this.arenthis.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float vecX = MathHelper.func_76134_b((float)randomVec) * 0.2f;
                float vecY = -0.1f + this.arenthis.func_70681_au().nextFloat() * 0.2f;
                float vecZ = MathHelper.func_76126_a((float)randomVec) * 0.2f;
                this.arenthis.setMovementVector(vecX, vecY, vecZ);
            }
        }
    }
}

