/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity.boss;

import androsa.gaiadimension.entity.MalachiteDroneEntity;
import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.registry.ModItems;
import androsa.gaiadimension.registry.ModParticles;
import androsa.gaiadimension.registry.ModSounds;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;

public class MalachiteGuardEntity
extends MonsterEntity {
    private static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(MalachiteGuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STOMP_PHASE = EntityDataManager.func_187226_a(MalachiteGuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CHARGE_PHASE = EntityDataManager.func_187226_a(MalachiteGuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int dronesLeft;
    private boolean hasSpawnedDrones;
    private int stompCooldown;
    private int chargeCooldown;
    private float bideDamage;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);

    public MalachiteGuardEntity(EntityType<? extends MalachiteGuardEntity> entity, World world) {
        super(entity, world);
        this.field_70138_W = 1.5f;
        this.field_70728_aV = 75;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.6).func_233815_a_(Attributes.field_233824_g_, 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PHASE, (Object)0);
        this.field_70180_af.func_187214_a(STOMP_PHASE, (Object)0);
        this.field_70180_af.func_187214_a(CHARGE_PHASE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new DefendGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new StompAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BlastAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.6, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.6, 32.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setPhase(nbt.func_74762_e("Phase"));
        this.setStompPhase(nbt.func_74762_e("StompPhase"));
        this.setChargePhase(nbt.func_74762_e("ChargePhase"));
        this.dronesLeft = nbt.func_74762_e("DronesLeft");
        this.hasSpawnedDrones = nbt.func_74767_n("IsSpawned");
        this.stompCooldown = nbt.func_74762_e("StompCooldown");
        this.chargeCooldown = nbt.func_74762_e("ChargeCooldown");
        this.bideDamage = nbt.func_74760_g("BideDamage");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("Phase", this.getPhase());
        nbt.func_74768_a("StompPhase", this.getStompPhase());
        nbt.func_74768_a("ChargePhase", this.getChargePhase());
        nbt.func_74768_a("DronesLeft", this.dronesLeft);
        nbt.func_74757_a("IsSpawned", this.hasSpawnedDrones);
        nbt.func_74768_a("StompCooldown", this.stompCooldown);
        nbt.func_74768_a("ChargeCooldown", this.chargeCooldown);
        nbt.func_74776_a("BideDamage", this.bideDamage);
    }

    public void func_200203_b(@Nullable ITextComponent text) {
        super.func_200203_b(text);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public int getPhase() {
        return (Integer)this.field_70180_af.func_187225_a(PHASE);
    }

    private void setPhase(int id) {
        if (id > 2 || id < 0) {
            id = 0;
            this.hasSpawnedDrones = false;
        }
        this.field_70180_af.func_187227_b(PHASE, (Object)id);
    }

    public int getStompPhase() {
        return (Integer)this.field_70180_af.func_187225_a(STOMP_PHASE);
    }

    public void setStompPhase(int id) {
        if (id > 2 || id < 0) {
            id = 0;
        }
        this.field_70180_af.func_187227_b(STOMP_PHASE, (Object)id);
    }

    public int getChargePhase() {
        return (Integer)this.field_70180_af.func_187225_a(CHARGE_PHASE);
    }

    private void setChargePhase(int id) {
        if (id > 2 || id < 0) {
            id = 0;
        }
        this.field_70180_af.func_187227_b(CHARGE_PHASE, (Object)id);
    }

    public void func_213315_a(MoverType type, Vector3d motion) {
        if (this.getPhase() != 0 && (this.getChargePhase() == 0 || this.getChargePhase() == 0)) {
            super.func_213315_a(type, motion);
        }
    }

    public void func_233627_a_(float amount, double x, double z) {
        if (this.getPhase() == 1 || this.getChargePhase() != 0 || this.getStompPhase() != 0) {
            super.func_233627_a_(amount, x, z);
        }
    }

    public boolean func_225503_b_(float dist, float mul) {
        return false;
    }

    public void func_70624_b(@Nullable LivingEntity entity) {
        if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            if (entity instanceof PlayerEntity && EntityPredicates.field_188444_d.test(entity)) {
                super.func_70624_b(entity);
            }
        } else if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
            if (entity instanceof PlayerEntity) {
                if (EntityPredicates.field_188444_d.test(entity)) {
                    super.func_70624_b(entity);
                }
            } else {
                super.func_70624_b(entity);
            }
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.ENTITY_MALACHITE_GUARD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.ENTITY_MALACHITE_GUARD_DEATH;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.6f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getChargePhase() == 1 && this.field_70170_p.func_201670_d()) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ModParticles.MALACHITE_MAGIC, this.func_226282_d_(3.0), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * 0.25, this.func_226287_g_(3.0), 0.0, 0.0, 0.0);
            }
        }
        if (!this.field_70170_p.func_201670_d()) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    private void spawnDrones() {
        BlockPos guardPos = this.func_233580_cy_();
        int gX = guardPos.func_177958_n();
        int gy = guardPos.func_177956_o();
        int gZ = guardPos.func_177952_p();
        Difficulty difficulty = this.field_70170_p.func_175659_aa();
        BlockPos bpLeft = new BlockPos(gX - 2, gy, gZ);
        BlockPos bpRight = new BlockPos(gX + 2, gy, gZ);
        BlockPos bpTopLeft = new BlockPos(gX - 2, gy, gZ + 1);
        BlockPos bpLowLeft = new BlockPos(gX - 2, gy, gZ - 1);
        BlockPos bpTopRight = new BlockPos(gX + 2, gy, gZ + 1);
        BlockPos bpLowRight = new BlockPos(gX + 2, gy, gZ - 1);
        BlockPos bpMid = new BlockPos(gX, gy, gZ + 1);
        if (difficulty == Difficulty.EASY) {
            this.createDrone(bpLeft);
            this.createDrone(bpMid);
            this.createDrone(bpRight);
        }
        if (difficulty == Difficulty.NORMAL) {
            this.createDrone(bpTopLeft);
            this.createDrone(bpLowLeft);
            this.createDrone(bpTopRight);
            this.createDrone(bpLowRight);
        }
        if (difficulty == Difficulty.HARD) {
            this.createDrone(bpTopLeft);
            this.createDrone(bpLowLeft);
            this.createDrone(bpTopRight);
            this.createDrone(bpLowRight);
            this.createDrone(bpMid);
        }
    }

    private void createDrone(BlockPos pos) {
        MalachiteDroneEntity drone = new MalachiteDroneEntity(ModEntities.MALACHITE_DRONE, this.field_70170_p);
        drone.func_174828_a(pos, 0.0f, 0.0f);
        if (!this.field_70170_p.func_201670_d()) {
            drone.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(pos), SpawnReason.MOB_SUMMONED, null, null);
        }
        drone.setOwner((LivingEntity)this);
        this.field_70170_p.func_217376_c((Entity)drone);
        ++this.dronesLeft;
    }

    public void onDroneKilled() {
        --this.dronesLeft;
    }

    public void func_70636_d() {
        if (this.getPhase() == 0) {
            Vector3d motion = this.func_213322_ci();
            this.func_213293_j(0.0, motion.func_82617_b(), 0.0);
            if (!this.hasSpawnedDrones) {
                this.spawnDrones();
                this.hasSpawnedDrones = true;
            }
            if (this.dronesLeft <= 0 && this.hasSpawnedDrones) {
                this.setPhase(1);
            }
        }
        if (this.getPhase() == 1 && this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
            this.setPhase(2);
        }
        float movespeed = (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e();
        if (this.getPhase() == 2) {
            movespeed *= 0.35f;
        } else if (this.getPhase() == 0) {
            movespeed = 0.0f;
        }
        this.func_70659_e(movespeed);
        if (this.stompCooldown > 0) {
            --this.stompCooldown;
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        super.func_70636_d();
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_241208_cS_() {
        return false;
    }

    public boolean func_70652_k(Entity target) {
        boolean flag = super.func_70652_k(target);
        Difficulty difficulty = this.field_70170_p.func_175659_aa();
        if ((difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) && target instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)target;
            NonNullList armor = player.field_71071_by.field_70460_b;
            int slot = this.field_70146_Z.nextInt(armor.size());
            ItemStack stack = (ItemStack)armor.get(slot);
            EquipmentSlotType slotType = EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)slot);
            if (difficulty == Difficulty.NORMAL && this.field_70146_Z.nextInt(16) == 0 || difficulty == Difficulty.HARD && this.field_70146_Z.nextInt(8) == 0) {
                player.func_146097_a(stack, true, false);
                player.func_184201_a(slotType, ItemStack.field_190927_a);
            }
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getChargePhase() == 1 && this.isAllowedToDamage(source)) {
            if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
                this.bideDamage += (amount /= 4.0f);
                amount *= 3.0f;
            } else if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                this.bideDamage += (amount /= 2.0f);
            } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                this.bideDamage += (amount /= 4.0f) * 3.0f;
            }
        }
        if (this.getPhase() == 0) {
            return this.func_233580_cy_().func_177956_o() < -64 && super.func_70097_a(source, amount);
        }
        if (this.getPhase() == 1) {
            float threshold = this.func_110138_aP() / 2.0f - 2.0f;
            float remaining = this.func_110143_aJ() - threshold;
            if (amount > remaining) {
                amount = remaining;
            }
            return super.func_70097_a(source, amount);
        }
        if (this.getPhase() == 2) {
            if (this.isAllowedToDamage(source)) {
                float multiply = this.getMultiplier(amount);
                return super.func_70097_a(source, amount * multiply);
            }
            return this.func_233580_cy_().func_177956_o() < -64 && super.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount);
    }

    private boolean isAllowedToDamage(DamageSource source) {
        Entity entity = source.func_76364_f();
        if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            return entity instanceof PlayerEntity;
        }
        return entity instanceof LivingEntity;
    }

    private float getMultiplier(float base) {
        switch (this.field_70170_p.func_175659_aa()) {
            case EASY: {
                return base > 50.0f ? 0.25f : (base > 25.0f ? 0.5f : (base > 10.0f ? 0.75f : 1.0f));
            }
            case NORMAL: {
                return base > 100.0f ? 0.0f : (base > 50.0f ? 0.125f : (base > 25.0f ? 0.25f : (base > 10.0f ? 0.5f : 1.0f)));
            }
            case HARD: {
                return base > 75.0f ? 0.0f : (base > 50.0f ? 0.125f : (base > 25.0f ? 0.25f : (base > 10.0f ? 0.5f : 1.0f)));
            }
        }
        return base;
    }

    public boolean func_70687_e(EffectInstance effectInstance) {
        return this.field_70170_p.func_175659_aa() == Difficulty.HARD && effectInstance.func_188419_a().func_188408_i();
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
        super.func_174812_G();
    }

    public boolean func_213397_c(double distance) {
        return false;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_199702_a((IItemProvider)ModItems.mock_malachite.get(), 1);
            this.func_70106_y();
        }
        super.func_70623_bb();
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 3.0f;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected boolean func_184228_n(Entity entity) {
        return false;
    }

    static class StompAttackGoal
    extends Goal {
        private final MalachiteGuardEntity guard;
        private int stompTime;

        public StompAttackGoal(MalachiteGuardEntity entity) {
            this.guard = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.guard.getPhase() != 0 && this.guard.getChargePhase() == 0 && this.guard.stompCooldown <= 0) {
                List list = this.guard.field_70170_p.func_175674_a((Entity)this.guard, this.guard.func_174813_aQ().func_186662_g(2.0), entity -> {
                    EntityType type = entity.func_200600_R();
                    if (type == EntityType.field_200729_aH) {
                        return EntityPredicates.field_188444_d.test(entity);
                    }
                    return false;
                });
                for (Entity entity2 : list) {
                    if (!entity2.func_233570_aj_() || !(entity2.func_70068_e((Entity)this.guard) > 1.0) || !(entity2.func_70068_e((Entity)this.guard) < 4.0)) continue;
                    return entity2.func_70089_S();
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.guard.stompCooldown <= 0;
        }

        public void func_75249_e() {
            this.guard.setStompPhase(1);
            this.stompTime = 0;
        }

        public void func_75251_c() {
            this.guard.setStompPhase(0);
        }

        public void func_75246_d() {
            ++this.stompTime;
            if (this.stompTime == 20) {
                this.guard.setStompPhase(2);
                List targets = this.guard.field_70170_p.func_175674_a((Entity)this.guard, this.guard.func_174813_aQ().func_72314_b(3.0, -2.0, 3.0), entity -> {
                    EntityType type = entity.func_200600_R();
                    return type != ModEntities.MALACHITE_GUARD && type != ModEntities.MALACHITE_DRONE;
                });
                this.guard.func_184185_a(ModSounds.ENTITY_MALACHITE_GUARD_STOMP, 1.0f, 1.0f);
                for (Entity entity2 : targets) {
                    Vector3d targetV3D = entity2.func_213322_ci();
                    entity2.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.guard), 5.0f);
                    entity2.func_213293_j(targetV3D.func_82615_a() * 0.5, targetV3D.func_82617_b() + (double)0.4f, targetV3D.func_82616_c() * 0.5);
                }
                if (!this.guard.field_70170_p.func_201670_d()) {
                    for (int x = -3; x <= 3; ++x) {
                        for (int z = -3; z <= 3; ++z) {
                            BlockPos pos = this.guard.func_233580_cy_().func_177982_a(x, 0, z);
                            BlockState state = this.guard.field_70170_p.func_180495_p(pos.func_177977_b());
                            ((ServerWorld)this.guard.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), (double)pos.func_177958_n(), this.guard.func_226278_cu_() + this.guard.field_70146_Z.nextDouble() * 0.25, (double)pos.func_177952_p(), 5, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.stompTime >= 30) {
                this.guard.stompCooldown = 120;
            }
        }
    }

    static class BlastAttackGoal
    extends Goal {
        private final MalachiteGuardEntity guard;
        private int attackPhase;
        private int chargeTimer;
        private int explodeTime;

        public BlastAttackGoal(MalachiteGuardEntity entity) {
            this.guard = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.guard.getPhase() != 0 && this.guard.getStompPhase() == 0 && this.guard.chargeCooldown <= 0) {
                List list = this.guard.field_70170_p.func_175674_a((Entity)this.guard, this.guard.func_174813_aQ().func_186662_g(3.0), entity -> {
                    EntityType type = entity.func_200600_R();
                    if (type == EntityType.field_200729_aH) {
                        return EntityPredicates.field_188444_d.test(entity);
                    }
                    return false;
                });
                for (Entity entity2 : list) {
                    double guardY;
                    double targetY = entity2.func_233580_cy_().func_177956_o();
                    if (!(targetY < (guardY = (double)this.guard.func_233580_cy_().func_177956_o()) - 1.0) && !(targetY > guardY + 1.0)) continue;
                    return entity2.func_70089_S() && this.guard.func_233570_aj_();
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.guard.chargeCooldown <= 0;
        }

        public void func_75249_e() {
            this.guard.func_70661_as().func_75499_g();
            this.guard.setChargePhase(1);
            this.attackPhase = 0;
            this.chargeTimer = 100;
            this.explodeTime = 0;
        }

        public void func_75251_c() {
            this.guard.setChargePhase(0);
            this.guard.bideDamage = 0.0f;
        }

        public void func_75246_d() {
            --this.chargeTimer;
            if (this.chargeTimer <= 0) {
                if (this.attackPhase == 0) {
                    this.guard.setChargePhase(2);
                    ++this.attackPhase;
                }
                if (this.explodeTime == 0) {
                    List targets = this.guard.field_70170_p.func_175674_a((Entity)this.guard, this.guard.func_174813_aQ().func_186662_g(4.0), entity -> {
                        EntityType type = entity.func_200600_R();
                        return type != ModEntities.MALACHITE_GUARD && type != ModEntities.MALACHITE_DRONE;
                    });
                    this.guard.func_184185_a(ModSounds.ENTITY_MALACHITE_GUARD_BLAST, 1.0f, 1.0f);
                    for (Entity entity2 : targets) {
                        Vector3d explosion = new Vector3d(this.guard.func_226277_ct_(), this.guard.func_226278_cu_(), this.guard.func_226281_cx_());
                        Vector3d direction = entity2.func_213303_ch().func_178788_d(explosion).func_72432_b();
                        entity2.func_70097_a(DamageSource.field_76376_m, 8.0f + this.guard.bideDamage);
                        entity2.func_213293_j(direction.func_82615_a(), direction.func_82617_b() + (double)0.2f, direction.func_82616_c());
                    }
                }
                if (this.explodeTime < 10 && !this.guard.field_70170_p.func_201670_d()) {
                    for (int i = 0; i < 5; ++i) {
                        ((ServerWorld)this.guard.field_70170_p).func_195598_a((IParticleData)ModParticles.MALACHITE_MAGIC, this.guard.func_226282_d_(1.0), this.guard.func_226279_cv_(), this.guard.func_226287_g_(1.0), 5, this.guard.field_70146_Z.nextDouble() - 0.5, this.guard.field_70146_Z.nextDouble() * 0.5, this.guard.field_70146_Z.nextDouble() - 0.5, 0.5);
                    }
                }
                ++this.explodeTime;
                if (this.explodeTime >= 20) {
                    this.guard.chargeCooldown = 60;
                }
            }
        }
    }

    class DefendGoal
    extends Goal {
        public DefendGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            return MalachiteGuardEntity.this.getPhase() == 0;
        }
    }
}

