/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.fluids;

import androsa.gaiadimension.registry.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class SuperhotMagmaFluid
extends ForgeFlowingFluid {
    public SuperhotMagmaFluid(ForgeFlowingFluid.Properties props) {
        super(props);
    }

    protected void func_205580_a(IWorld iWorld, BlockPos pos, BlockState state) {
        this.triggerEffects(iWorld, pos);
    }

    protected boolean func_215665_a(FluidState fluidstate, IBlockReader reader, BlockPos pos, Fluid fluid, Direction direction) {
        return fluidstate.func_215679_a(reader, pos) >= 0.44444445f && fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    protected void func_205574_a(IWorld worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
        if (direction == Direction.DOWN) {
            FluidState fluidstate = worldIn.func_204610_c(pos);
            if (this.func_207185_a((ITag)FluidTags.field_206960_b) && fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                if (blockStateIn.func_177230_c() instanceof FlowingFluidBlock) {
                    worldIn.func_180501_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)pos, (BlockPos)pos, (BlockState)((Block)ModBlocks.primal_mass.get()).func_176223_P()), 3);
                    this.triggerEffects(worldIn, pos);
                }
                return;
            }
        }
        super.func_205574_a(worldIn, pos, blockStateIn, direction, fluidStateIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World worldIn, BlockPos pos, FluidState state, Random random) {
        BlockPos blockpos = pos.func_177984_a();
        if (worldIn.func_180495_p(blockpos).func_196958_f() && !worldIn.func_180495_p(blockpos).func_200015_d((IBlockReader)worldIn, blockpos)) {
            if (random.nextInt(100) == 0) {
                double d0 = (float)pos.func_177958_n() + random.nextFloat();
                double d1 = pos.func_177956_o() + 1;
                double d2 = (float)pos.func_177952_p() + random.nextFloat();
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public void func_207186_b(World world, BlockPos pos, FluidState state, Random random) {
        block7: {
            if (!world.func_82736_K().func_223586_b(GameRules.field_223598_a)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!world.func_195588_v(blockpos = blockpos.func_177982_a(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState blockstate = world.func_180495_p(blockpos);
                    if (blockstate.func_196958_f()) {
                        if (!this.isSurroundingBlockFlammable((IWorldReader)world, blockpos)) continue;
                        world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                        return;
                    }
                    if (!blockstate.func_185904_a().func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.func_177982_a(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!world.func_195588_v(blockpos1)) {
                        return;
                    }
                    if (!world.func_175623_d(blockpos1.func_177984_a()) || !this.getCanBlockBurn((IWorldReader)world, blockpos1)) continue;
                    world.func_175656_a(blockpos1.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(IWorldReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.getCanBlockBurn(worldIn, pos.func_177972_a(direction))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(IWorldReader worldIn, BlockPos pos) {
        return (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || worldIn.func_175667_e(pos)) && worldIn.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    private void triggerEffects(IWorld world, BlockPos pos) {
        world.func_217379_c(1501, pos, 0);
    }
}

