/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry;

import androsa.gaiadimension.registry.GaiaTags;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModWorldgen;
import androsa.gaiadimension.registry.RegistryHelper;
import androsa.gaiadimension.world.gen.config.FeatureHeightConfig;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.foliageplacer.BushFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;

public final class GaiaBiomeFeatures {
    public static final RuleTest GAIA_STONE = new BlockMatchRuleTest((Block)ModBlocks.gaia_stone.get());
    public static final RuleTest VOLCANIC = new TagMatchRuleTest(GaiaTags.Blocks.VOLCANIC);
    public static final RuleTest STATIC = new TagMatchRuleTest(GaiaTags.Blocks.STATIC);
    public static final BlockState GLITTER_GRASS = ((Block)ModBlocks.glitter_grass.get()).func_176223_P();
    public static final BlockState CORRUPT_GRASS = ((Block)ModBlocks.corrupt_grass.get()).func_176223_P();
    public static final BlockState MURKY_GRASS = ((Block)ModBlocks.murky_grass.get()).func_176223_P();
    public static final BlockState SOFT_GRASS = ((Block)ModBlocks.soft_grass.get()).func_176223_P();
    public static final BlockState HEAVY_SOIL = ((Block)ModBlocks.heavy_soil.get()).func_176223_P();
    public static final BlockState CORRUPT_SOIL = ((Block)ModBlocks.corrupt_soil.get()).func_176223_P();
    public static final BlockState BOGGY_SOIL = ((Block)ModBlocks.boggy_soil.get()).func_176223_P();
    public static final BlockState LIGHT_SOIL = ((Block)ModBlocks.light_soil.get()).func_176223_P();
    public static final BlockState SALT = ((Block)ModBlocks.salt.get()).func_176223_P();
    public static final BlockState WASTELAND_STONE = ((Block)ModBlocks.wasteland_stone.get()).func_176223_P();
    public static final BlockState VOLCANIC_ROCK = ((Block)ModBlocks.volcanic_rock.get()).func_176223_P();
    public static final BlockState SUPERHOT_MAGMA = ((FlowingFluidBlock)ModBlocks.superhot_magma.get()).func_176223_P();
    public static final BlockState MINERAL_WATER = ((FlowingFluidBlock)ModBlocks.mineral_water.get()).func_176223_P();
    public static final BlockState SWEET_MUCK = ((FlowingFluidBlock)ModBlocks.sweet_muck.get()).func_176223_P();
    public static final BlockState LIQUID_AURA = ((FlowingFluidBlock)ModBlocks.liquid_aura.get()).func_176223_P();
    public static final BlockState LIQUID_BISMUTH = ((FlowingFluidBlock)ModBlocks.liquid_bismuth.get()).func_176223_P();
    public static final BlockState GUMMY_GLITTER = ((Block)ModBlocks.gummy_glitter_block.get()).func_176223_P();
    public static final BlockState PRIMAL_MASS = ((Block)ModBlocks.primal_mass.get()).func_176223_P();
    public static final BlockState THICK_GLITTER = ((Block)ModBlocks.thick_glitter_block.get()).func_176223_P();
    public static final BlockState SEARING_ROCK = ((Block)ModBlocks.searing_rock.get()).func_176223_P();
    public static final BlockState STATIC_STONE = ((Block)ModBlocks.static_stone.get()).func_176223_P();
    public static final BlockState PEBBLES = ((Block)ModBlocks.pebbles.get()).func_176223_P();
    public static final BlockState SPECKLED_ROCK = ((Block)ModBlocks.speckled_rock.get()).func_176223_P();
    public static final BlockState COARSE_ROCK = ((Block)ModBlocks.coarse_rock.get()).func_176223_P();
    public static final BlockState PRECIOUS_ROCK = ((Block)ModBlocks.precious_rock.get()).func_176223_P();
    public static final BlockState RAW_AMETHYST = ((Block)ModBlocks.raw_amethyst.get()).func_176223_P();
    public static final BlockState RAW_COPAL = ((Block)ModBlocks.raw_copal.get()).func_176223_P();
    public static final BlockState RAW_JADE = ((Block)ModBlocks.raw_jade.get()).func_176223_P();
    public static final BlockState RAW_JET = ((Block)ModBlocks.raw_jet.get()).func_176223_P();
    public static final BlockState SUGILITE_ORE = ((Block)ModBlocks.sugilite_ore.get()).func_176223_P();
    public static final BlockState HEMATITE_ORE = ((Block)ModBlocks.hematite_ore.get()).func_176223_P();
    public static final BlockState PYRITE_ORE = ((Block)ModBlocks.pyrite_ore.get()).func_176223_P();
    public static final BlockState CINNABAR_ORE = ((Block)ModBlocks.cinnabar_ore.get()).func_176223_P();
    public static final BlockState LABRADORITE_ORE = ((Block)ModBlocks.labradorite_ore.get()).func_176223_P();
    public static final BlockState MOONSTONE_ORE = ((Block)ModBlocks.moonstone_ore.get()).func_176223_P();
    public static final BlockState RED_OPAL_ORE = ((Block)ModBlocks.opal_ore_red.get()).func_176223_P();
    public static final BlockState BLUE_OPAL_ORE = ((Block)ModBlocks.opal_ore_blue.get()).func_176223_P();
    public static final BlockState GREEN_OPAL_ORE = ((Block)ModBlocks.opal_ore_green.get()).func_176223_P();
    public static final BlockState WHITE_OAL_ORE = ((Block)ModBlocks.opal_ore_white.get()).func_176223_P();
    public static final BlockState PINK_AGATE_LOG = ((RotatedPillarBlock)ModBlocks.pink_agate_log.get()).func_176223_P();
    public static final BlockState PINK_AGATE_LEAVES = ((Block)ModBlocks.pink_agate_leaves.get()).func_176223_P();
    public static final BlockState BLUE_AGATE_LOG = ((RotatedPillarBlock)ModBlocks.blue_agate_log.get()).func_176223_P();
    public static final BlockState BLUE_AGATE_LEAVES = ((Block)ModBlocks.blue_agate_leaves.get()).func_176223_P();
    public static final BlockState GREEN_AGATE_LOG = ((RotatedPillarBlock)ModBlocks.green_agate_log.get()).func_176223_P();
    public static final BlockState GREEN_AGATE_LEAVES = ((Block)ModBlocks.green_agate_leaves.get()).func_176223_P();
    public static final BlockState PURPLE_AGATE_LOG = ((RotatedPillarBlock)ModBlocks.purple_agate_log.get()).func_176223_P();
    public static final BlockState PURPLE_AGATE_LEAVES = ((Block)ModBlocks.purple_agate_leaves.get()).func_176223_P();
    public static final BlockState FOSSIL_LOG = ((RotatedPillarBlock)ModBlocks.fossilized_log.get()).func_176223_P();
    public static final BlockState FOSSIL_LEAVES = ((Block)ModBlocks.fossilized_leaves.get()).func_176223_P();
    public static final BlockState CORRUPTED_LOG = ((RotatedPillarBlock)ModBlocks.corrupted_log.get()).func_176223_P();
    public static final BlockState CORRUPTED_LEAVES = ((Block)ModBlocks.corrupted_leaves.get()).func_176223_P();
    public static final BlockState BURNT_LOG = ((RotatedPillarBlock)ModBlocks.burnt_log.get()).func_176223_P();
    public static final BlockState BURNT_LEAVES = ((Block)ModBlocks.burnt_leaves.get()).func_176223_P();
    public static final BlockState BURNING_LOG = ((RotatedPillarBlock)ModBlocks.burning_log.get()).func_176223_P();
    public static final BlockState BURNING_LEAVES = ((Block)ModBlocks.burning_leaves.get()).func_176223_P();
    public static final BlockState AURA_LOG = ((RotatedPillarBlock)ModBlocks.aura_log.get()).func_176223_P();
    public static final BlockState AURA_LEAVES = ((Block)ModBlocks.aura_leaves.get()).func_176223_P();
    public static final BlockState CRYSTAL_GROWTH = ((Block)ModBlocks.crystal_growth.get()).func_176223_P();
    public static final BlockState CRYSTAL_GROWTH_MUTANT = ((Block)ModBlocks.crystal_growth_mutant.get()).func_176223_P();
    public static final BlockState CRYSTAL_GROWTH_SEARED = ((Block)ModBlocks.crystal_growth_seared.get()).func_176223_P();
    public static final BlockState CRYSTAL_GROWTH_RED = ((Block)ModBlocks.crystal_growth_red.get()).func_176223_P();
    public static final BlockState CRYSTAL_GROWTH_BLACK = ((Block)ModBlocks.crystal_growth_black.get()).func_176223_P();
    public static final BlockState CRYSTAL_GROWTH_AURA = ((Block)ModBlocks.crystal_growth_aura.get()).func_176223_P();
    public static final BlockState THISCUS = ((Block)ModBlocks.thiscus.get()).func_176223_P();
    public static final BlockState OUZIUM = ((Block)ModBlocks.ouzium.get()).func_176223_P();
    public static final BlockState AGATHUM = ((Block)ModBlocks.agathum.get()).func_176223_P();
    public static final BlockState CORRUPTED_VARLOOM = ((Block)ModBlocks.corrupted_varloom.get()).func_176223_P();
    public static final BlockState SPOTTED_KERSEI = ((Block)ModBlocks.spotted_kersei.get()).func_176223_P();
    public static final BlockState THORNY_WILTHA = ((Block)ModBlocks.thorny_wiltha.get()).func_176223_P();
    public static final BlockState ROOFED_AGARIC = ((Block)ModBlocks.roofed_agaric.get()).func_176223_P();
    public static final BlockState BULBOUS_HOBINA = ((Block)ModBlocks.bulbous_hobina.get()).func_176223_P();
    public static final BlockState STICKLY_CUPSIR = ((Block)ModBlocks.stickly_cupsir.get()).func_176223_P();
    public static final BlockState MYSTICAL_MURGNI = ((Block)ModBlocks.mystical_murgni.get()).func_176223_P();
    public static final BlockState CORRUPTED_GAIA_EYE = ((Block)ModBlocks.corrupted_gaia_eye.get()).func_176223_P();
    public static final BlockState ELDER_IMKLIA = ((Block)ModBlocks.elder_imklia.get()).func_176223_P();
    public static final BlockState GOLD_ORB_TUCHER = ((Block)ModBlocks.gold_orb_tucher.get()).func_176223_P();
    public static final Set<BlockState> cave_blacklist = ImmutableSet.of((Object)GLITTER_GRASS, (Object)HEAVY_SOIL, (Object)CORRUPT_GRASS, (Object)CORRUPT_SOIL, (Object)MURKY_GRASS, (Object)BOGGY_SOIL, (Object[])new BlockState[]{SOFT_GRASS, LIGHT_SOIL, SALT});
    public static final SurfaceBuilderConfig GLITTER_HEAVY_SALT = new SurfaceBuilderConfig(GLITTER_GRASS, HEAVY_SOIL, SALT);
    public static final SurfaceBuilderConfig CORRUPT_SALT = new SurfaceBuilderConfig(CORRUPT_GRASS, CORRUPT_SOIL, SALT);
    public static final SurfaceBuilderConfig SALTY_SURFACE = new SurfaceBuilderConfig(SALT, SALT, SALT);
    public static final SurfaceBuilderConfig MURKY_BOGGY_PEBBLES = new SurfaceBuilderConfig(MURKY_GRASS, BOGGY_SOIL, PEBBLES);
    public static final SurfaceBuilderConfig SOFT_LIGHT_SALT = new SurfaceBuilderConfig(SOFT_GRASS, LIGHT_SOIL, PEBBLES);
    public static final SurfaceBuilderConfig WASTELAND_STONE_SURFACE = new SurfaceBuilderConfig(WASTELAND_STONE, WASTELAND_STONE, WASTELAND_STONE);
    public static final SurfaceBuilderConfig GLITTER_HEAVY_VOLROCK = new SurfaceBuilderConfig(GLITTER_GRASS, HEAVY_SOIL, VOLCANIC_ROCK);
    public static final GaiaTreeFeatureConfig PINK_AGATE_TREE_CONFIG = GaiaBiomeFeatures.configureTree(PINK_AGATE_LOG, PINK_AGATE_LEAVES, 5, (SaplingBlock)ModBlocks.pink_agate_sapling.get());
    public static final GaiaTreeFeatureConfig BLUE_AGATE_TREE_CONFIG = GaiaBiomeFeatures.configureTree(BLUE_AGATE_LOG, BLUE_AGATE_LEAVES, 6, (SaplingBlock)ModBlocks.blue_agate_sapling.get());
    public static final GaiaTreeFeatureConfig GREEN_AGATE_TREE_CONFIG = GaiaBiomeFeatures.configureTree(GREEN_AGATE_LOG, GREEN_AGATE_LEAVES, 10, (SaplingBlock)ModBlocks.green_agate_sapling.get());
    public static final BaseTreeFeatureConfig GREEN_AGATE_BUSH_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GREEN_AGATE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(GREEN_AGATE_LEAVES), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)1), 2), (AbstractTrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236702_a_(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_225568_b_();
    public static final GaiaTreeFeatureConfig PURPLE_AGATE_TREE_CONFIG = GaiaBiomeFeatures.configureTree(PURPLE_AGATE_LOG, PURPLE_AGATE_LEAVES, 7, (SaplingBlock)ModBlocks.purple_agate_sapling.get());
    public static final GaiaTreeFeatureConfig FOSSILIZED_TREE_CONFIG = GaiaBiomeFeatures.configureTree(FOSSIL_LOG, FOSSIL_LEAVES, 5, (SaplingBlock)ModBlocks.fossilized_sapling.get());
    public static final GaiaTreeFeatureConfig CORRUPTED_TREE_CONFIG = GaiaBiomeFeatures.configureTree(CORRUPTED_LOG, CORRUPTED_LEAVES, 7, (SaplingBlock)ModBlocks.corrupted_sapling.get());
    public static final GaiaTreeFeatureConfig BURNT_TREE_CONFIG = GaiaBiomeFeatures.configureTree(BURNT_LOG, BURNT_LEAVES, 5, (SaplingBlock)ModBlocks.burnt_sapling.get());
    public static final GaiaTreeFeatureConfig BURNING_TREE_CONFIG = GaiaBiomeFeatures.configureTree(BURNING_LOG, BURNING_LEAVES, 5, (SaplingBlock)ModBlocks.burning_sapling.get());
    public static final GaiaTreeFeatureConfig AURA_TREE_CONFIG = GaiaBiomeFeatures.configureTree(AURA_LOG, AURA_LEAVES, 10, (SaplingBlock)ModBlocks.aura_sapling.get());
    public static final BlockClusterFeatureConfig NORMAL_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CRYSTAL_GROWTH), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig MUTANT_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CRYSTAL_GROWTH_MUTANT), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig SEARED_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CRYSTAL_GROWTH_SEARED), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig CORRUPT_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(CRYSTAL_GROWTH_RED, 2).func_227407_a_(CRYSTAL_GROWTH_BLACK, 2), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig AURA_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CRYSTAL_GROWTH_AURA), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig COMMON_BLOOM = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(THISCUS, 4).func_227407_a_(OUZIUM, 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig RARE_BLOOM = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(OUZIUM, 4).func_227407_a_(THISCUS, 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig MUTANT_BLOOM = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(OUZIUM, 4).func_227407_a_(AGATHUM, 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig CORRUPT_BLOOM = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CORRUPTED_VARLOOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig KERSEI = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SPOTTED_KERSEI), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig WILTHA = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(THORNY_WILTHA), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig AGARIC = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ROOFED_AGARIC), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig HOBINA = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BULBOUS_HOBINA), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig CUPSIR = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(STICKLY_CUPSIR), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig MURGNI = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MYSTICAL_MURGNI), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig CORRUPT_EYE = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CORRUPTED_GAIA_EYE), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig CAVE_FUNGI = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(ELDER_IMKLIA, 2).func_227407_a_(GOLD_ORB_TUCHER, 2), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227319_b_(cave_blacklist).func_227317_b_().func_227322_d_();
    public static final ImmutableList<Supplier<ConfiguredFeature<?, ?>>> BUSH_WORKAROUND = ImmutableList.of(() -> Feature.field_236291_c_.func_225566_b_((IFeatureConfig)GREEN_AGATE_BUSH_CONFIG));
    public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> d_glitter_heavy_salt = GaiaBiomeFeatures.registerSurfaceBuilder("glitter_grass", ((SurfaceBuilder)ModWorldgen.DEFAULT_GAIA.get()).func_242929_a((ISurfaceBuilderConfig)GLITTER_HEAVY_SALT));
    public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> d_corrupt_salt = GaiaBiomeFeatures.registerSurfaceBuilder("corrupt_grass", ((SurfaceBuilder)ModWorldgen.DEFAULT_GAIA.get()).func_242929_a((ISurfaceBuilderConfig)CORRUPT_SALT));
    public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> d_salty = GaiaBiomeFeatures.registerSurfaceBuilder("salty", ((SurfaceBuilder)ModWorldgen.DEFAULT_GAIA.get()).func_242929_a((ISurfaceBuilderConfig)SALTY_SURFACE));
    public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> d_murky_boggy_pebble = GaiaBiomeFeatures.registerSurfaceBuilder("murky_grass", ((SurfaceBuilder)ModWorldgen.DEFAULT_GAIA.get()).func_242929_a((ISurfaceBuilderConfig)MURKY_BOGGY_PEBBLES));
    public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> d_soft_light_salt = GaiaBiomeFeatures.registerSurfaceBuilder("soft_grass", ((SurfaceBuilder)ModWorldgen.DEFAULT_GAIA.get()).func_242929_a((ISurfaceBuilderConfig)SOFT_LIGHT_SALT));
    public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> s_wasteland_stone = GaiaBiomeFeatures.registerSurfaceBuilder("wasteland_stone", ((SurfaceBuilder)ModWorldgen.STATIC.get()).func_242929_a((ISurfaceBuilderConfig)WASTELAND_STONE_SURFACE));
    public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> v_glitter_heavy_volrock = GaiaBiomeFeatures.registerSurfaceBuilder("volcanic_grass", ((SurfaceBuilder)ModWorldgen.VOLCANIC.get()).func_242929_a((ISurfaceBuilderConfig)GLITTER_HEAVY_VOLROCK));
    public static final ConfiguredCarver<ProbabilityConfig> crystal_caves = GaiaBiomeFeatures.registerCarver("crystal_caves", ((WorldCarver)ModWorldgen.CRYSTAL_CAVES.get()).func_242761_a((ICarverConfig)new ProbabilityConfig(0.15f)));
    public static final ConfiguredCarver<ProbabilityConfig> chasms = GaiaBiomeFeatures.registerCarver("chasms", ((WorldCarver)ModWorldgen.CHASMS.get()).func_242761_a((ICarverConfig)new ProbabilityConfig(0.03f)));
    public static final StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> mini_tower = GaiaBiomeFeatures.registerStructureFeature("mini_tower", ((Structure)ModWorldgen.MINI_TOWER.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
    public static final StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> malachite_watchtower = GaiaBiomeFeatures.registerStructureFeature("malachite_watchtower", ((Structure)ModWorldgen.MALACHITE_WATCHTOWER.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
    public static final ConfiguredFeature<?, ?> lake_superhot_magma_common = GaiaBiomeFeatures.registerFeature("lake_superhot_magma_common", ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(SUPERHOT_MAGMA)).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(15))));
    public static final ConfiguredFeature<?, ?> lake_superhot_magma_rare = GaiaBiomeFeatures.registerFeature("lake_superhot_magma_rare", ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(SUPERHOT_MAGMA)).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(80))));
    public static final ConfiguredFeature<?, ?> lake_mineral_water_common = GaiaBiomeFeatures.registerFeature("lake_mineral_water_common", ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(MINERAL_WATER)).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
    public static final ConfiguredFeature<?, ?> lake_mineral_water_uncommon = GaiaBiomeFeatures.registerFeature("lake_mineral_water_uncommon", ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(MINERAL_WATER)).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(40))));
    public static final ConfiguredFeature<?, ?> lake_mineral_water_rare = GaiaBiomeFeatures.registerFeature("lake_mineral_water_rare", ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(MINERAL_WATER)).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(50))));
    public static final ConfiguredFeature<?, ?> lake_sweet_muck = GaiaBiomeFeatures.registerFeature("lake_sweet_muck", ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(SWEET_MUCK)).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(10))));
    public static final ConfiguredFeature<?, ?> lake_liquid_aura = GaiaBiomeFeatures.registerFeature("lake_liquid_aura", ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(LIQUID_AURA)).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(20))));
    public static final ConfiguredFeature<?, ?> lake_liquid_bismuth = GaiaBiomeFeatures.registerFeature("lake_liquid_bismuth", ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(LIQUID_BISMUTH)).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(20))));
    public static final ConfiguredFeature<?, ?> gummy_glitter_blob = GaiaBiomeFeatures.registerFeature("gummy_glitter_blob", (ConfiguredFeature)((Feature)ModWorldgen.GAIA_BLOB.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(GUMMY_GLITTER)).func_227228_a_(Features.Placements.field_244001_l).func_242732_c(2));
    public static final ConfiguredFeature<?, ?> static_spikes = GaiaBiomeFeatures.registerFeature("static_spikes", (ConfiguredFeature)((Feature)ModWorldgen.STATIC_SPIKE.get()).func_225566_b_((IFeatureConfig)new FeatureHeightConfig(8)).func_227228_a_(Features.Placements.field_244001_l).func_242732_c(2));
    public static final ConfiguredFeature<?, ?> bismuth_spires = GaiaBiomeFeatures.registerFeature("bismuth_spires", (ConfiguredFeature)((Feature)ModWorldgen.BISMUTH_SPIRE.get()).func_225566_b_((IFeatureConfig)new FeatureHeightConfig(7)).func_227228_a_(Features.Placements.field_244001_l).func_242732_c(2));
    public static final ConfiguredFeature<?, ?> bismuth_geysers = GaiaBiomeFeatures.registerFeature("bismuth_geysers", (ConfiguredFeature)((Feature)ModWorldgen.BISMUTH_GEYSER.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l).func_242732_c(2));
    public static final ConfiguredFeature<?, ?> ore_primal_mass = GaiaBiomeFeatures.registerFeature("ore_primal_mass", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, PRIMAL_MASS, 33, 25, 33));
    public static final ConfiguredFeature<?, ?> ore_thick_glitter = GaiaBiomeFeatures.registerFeature("ore_thick_glitter", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, THICK_GLITTER, 33, 100, 9));
    public static final ConfiguredFeature<?, ?> ore_searing_rock = GaiaBiomeFeatures.registerFeature("ore_searing_rock", GaiaBiomeFeatures.makeOreFeature(VOLCANIC, SEARING_ROCK, 33, 100, 9));
    public static final ConfiguredFeature<?, ?> ore_static_stone = GaiaBiomeFeatures.registerFeature("ore_static_stone", GaiaBiomeFeatures.makeOreFeature(STATIC, STATIC_STONE, 33, 100, 9));
    public static final ConfiguredFeature<?, ?> ore_pebbles = GaiaBiomeFeatures.registerFeature("ore_pebbles", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, PEBBLES, 25, 128, 25));
    public static final ConfiguredFeature<?, ?> ore_speckled_rock = GaiaBiomeFeatures.registerFeature("ore_speckled_rock", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, SPECKLED_ROCK, 8, 120, 10));
    public static final ConfiguredFeature<?, ?> ore_coarse_rock = GaiaBiomeFeatures.registerFeature("ore_coarse_rock", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, COARSE_ROCK, 8, 60, 10));
    public static final ConfiguredFeature<?, ?> ore_precious_rock = GaiaBiomeFeatures.registerFeature("ore_precious_rock", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, PRECIOUS_ROCK, 8, 30, 10));
    public static final ConfiguredFeature<?, ?> ore_raw_amethyst = GaiaBiomeFeatures.registerFeature("ore_raw_amethyst", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, RAW_AMETHYST, 12, 120, 15));
    public static final ConfiguredFeature<?, ?> ore_raw_copal = GaiaBiomeFeatures.registerFeature("ore_raw_copal", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, RAW_COPAL, 12, 120, 15));
    public static final ConfiguredFeature<?, ?> ore_raw_jade = GaiaBiomeFeatures.registerFeature("ore_raw_jade", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, RAW_JADE, 12, 120, 15));
    public static final ConfiguredFeature<?, ?> ore_raw_jet = GaiaBiomeFeatures.registerFeature("ore_raw_jet", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, RAW_JET, 12, 120, 15));
    public static final ConfiguredFeature<?, ?> ore_sugilite = GaiaBiomeFeatures.registerFeature("ore_sugilite", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, SUGILITE_ORE, 17, 100, 8));
    public static final ConfiguredFeature<?, ?> ore_hematite = GaiaBiomeFeatures.registerFeature("ore_hematite", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, HEMATITE_ORE, 17, 100, 8));
    public static final ConfiguredFeature<?, ?> ore_pyrite = GaiaBiomeFeatures.registerFeature("ore_pyrite", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, PYRITE_ORE, 9, 80, 8));
    public static final ConfiguredFeature<?, ?> ore_cinnabar = GaiaBiomeFeatures.registerFeature("ore_cinnabar", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, CINNABAR_ORE, 9, 60, 7));
    public static final ConfiguredFeature<?, ?> ore_labradorite = GaiaBiomeFeatures.registerFeature("ore_labradorite", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, LABRADORITE_ORE, 9, 40, 6));
    public static final ConfiguredFeature<?, ?> ore_moonstone = GaiaBiomeFeatures.registerFeature("ore_moonstone", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, MOONSTONE_ORE, 9, 40, 6));
    public static final ConfiguredFeature<?, ?> ore_red_opal = GaiaBiomeFeatures.registerFeature("ore_red_opal", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, RED_OPAL_ORE, 8, 30, 4));
    public static final ConfiguredFeature<?, ?> ore_blue_opal = GaiaBiomeFeatures.registerFeature("ore_blue_opal", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, BLUE_OPAL_ORE, 8, 30, 4));
    public static final ConfiguredFeature<?, ?> ore_green_opal = GaiaBiomeFeatures.registerFeature("ore_green_opal", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, GREEN_OPAL_ORE, 8, 30, 4));
    public static final ConfiguredFeature<?, ?> ore_white_opal_common = GaiaBiomeFeatures.registerFeature("ore_white_opal_common", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, WHITE_OAL_ORE, 8, 25, 4));
    public static final ConfiguredFeature<?, ?> ore_white_opal_rare = GaiaBiomeFeatures.registerFeature("ore_white_opal_rare", GaiaBiomeFeatures.makeOreFeature(GAIA_STONE, WHITE_OAL_ORE, 8, 20, 3));
    public static final ConfiguredFeature<?, ?> disk_static_stone = GaiaBiomeFeatures.registerFeature("disk_static_stone", ((Feature)ModWorldgen.GAIA_DISK.get()).func_225566_b_((IFeatureConfig)new SphereReplaceConfig(STATIC_STONE, FeatureSpread.func_242253_a((int)4, (int)2), 3, (List)ImmutableList.of((Object)WASTELAND_STONE))).func_227228_a_(Features.Placements.field_244003_n));
    public static final ConfiguredFeature<?, ?> disk_bog_patch = GaiaBiomeFeatures.registerFeature("disk_bog_patch", ((Feature)ModWorldgen.BOG_PATCH.get()).func_225566_b_((IFeatureConfig)new SphereReplaceConfig(((Block)ModBlocks.impure_sludge.get()).func_176223_P(), FeatureSpread.func_242253_a((int)4, (int)1), 2, (List)Lists.newArrayList((Object[])new BlockState[]{MURKY_GRASS, BOGGY_SOIL}))).func_227228_a_(Features.Placements.field_244003_n));
    public static final ConfiguredFeature<?, ?> underground_glitter_blob = GaiaBiomeFeatures.registerFeature("underground_glitter_blob", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)ModWorldgen.FRAIL_BLOB.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(64)).func_242728_a()).func_242731_b(100));
    public static final ConfiguredFeature<?, ?> crystal_fungi_caves = GaiaBiomeFeatures.registerFeature("crystal_fungi_caves", (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CAVE_FUNGI).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(2));
    public static final ConfiguredFeature<?, ?> pink_agate_tree_common = GaiaBiomeFeatures.registerFeature("pink_agate_tree_common", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.PINK_AGATE_TREE, PINK_AGATE_TREE_CONFIG, 4, 0.3f, 1));
    public static final ConfiguredFeature<?, ?> pink_agate_tree_rare = GaiaBiomeFeatures.registerFeature("pink_agate_tree_rare", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.PINK_AGATE_TREE, PINK_AGATE_TREE_CONFIG, 0, 0.1f, 1));
    public static final ConfiguredFeature<?, ?> blue_agate_tree = GaiaBiomeFeatures.registerFeature("blue_agate_tree", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.BLUE_AGATE_TREE, BLUE_AGATE_TREE_CONFIG, 1, 0.3f, 1));
    public static final ConfiguredFeature<?, ?> green_agate_tree = GaiaBiomeFeatures.registerFeature("green_agate_tree", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.GREEN_AGATE_TREE, GREEN_AGATE_TREE_CONFIG, 5, 0.3f, 1));
    public static final ConfiguredFeature<?, ?> green_agate_bush = GaiaBiomeFeatures.registerFeature("green_agate_bush", Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature(BUSH_WORKAROUND)));
    public static final ConfiguredFeature<?, ?> purple_agate_tree = GaiaBiomeFeatures.registerFeature("purple_agate_tree", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.PURPLE_AGATE_TREE, PURPLE_AGATE_TREE_CONFIG, 1, 0.1f, 2));
    public static final ConfiguredFeature<?, ?> various_agate_trees = GaiaBiomeFeatures.registerFeature("various_agate_trees", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((Feature)ModWorldgen.PINK_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)PINK_AGATE_TREE_CONFIG).func_227227_a_(0.1f), (Object)((Feature)ModWorldgen.BLUE_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)BLUE_AGATE_TREE_CONFIG).func_227227_a_(0.1f), (Object)((Feature)ModWorldgen.GREEN_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)GREEN_AGATE_TREE_CONFIG).func_227227_a_(0.1f), (Object)((Feature)ModWorldgen.PURPLE_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)PURPLE_AGATE_TREE_CONFIG).func_227227_a_(0.1f)), Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MUTANT_GROWTH))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
    public static final ConfiguredFeature<?, ?> fossilized_tree = GaiaBiomeFeatures.registerFeature("fossilized_tree", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.FOSSILIZED_TREE, FOSSILIZED_TREE_CONFIG, 1, 0.3f, 1));
    public static final ConfiguredFeature<?, ?> goldstone_tree = GaiaBiomeFeatures.registerFeature("goldstone_tree", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.GOLDSTONE_TREE, CORRUPTED_TREE_CONFIG, 1, 0.1f, 1));
    public static final ConfiguredFeature<?, ?> burnt_agate_tree = GaiaBiomeFeatures.registerFeature("burnt_agate_tree", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.BURNT_AGATE_TREE, BURNT_TREE_CONFIG, 0, 0.1f, 1));
    public static final ConfiguredFeature<?, ?> fiery_agate_tree = GaiaBiomeFeatures.registerFeature("fiery_agate_tree", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.FIERY_AGATE_TREE, BURNING_TREE_CONFIG, 0, 0.1f, 1));
    public static final ConfiguredFeature<?, ?> aura_tree = GaiaBiomeFeatures.registerFeature("aura_tree", GaiaBiomeFeatures.makeTreeFeature(ModWorldgen.AURA_TREE, AURA_TREE_CONFIG, 2, 0.1f, 1));
    public static final ConfiguredFeature<?, ?> aura_shoots = GaiaBiomeFeatures.registerFeature("aura_shoots", (ConfiguredFeature)((Feature)ModWorldgen.AURA_SHOOT.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(6));
    public static final ConfiguredFeature<?, ?> crystal_growth_02 = GaiaBiomeFeatures.registerFeature("crystal_growth_02", GaiaBiomeFeatures.makeGrowthFeature(NORMAL_GROWTH, 2));
    public static final ConfiguredFeature<?, ?> crystal_growth_03 = GaiaBiomeFeatures.registerFeature("crystal_growth_03", GaiaBiomeFeatures.makeGrowthFeature(NORMAL_GROWTH, 3));
    public static final ConfiguredFeature<?, ?> crystal_growth_04 = GaiaBiomeFeatures.registerFeature("crystal_growth_04", GaiaBiomeFeatures.makeGrowthFeature(NORMAL_GROWTH, 4));
    public static final ConfiguredFeature<?, ?> crystal_growth_05 = GaiaBiomeFeatures.registerFeature("crystal_growth_05", GaiaBiomeFeatures.makeGrowthFeature(NORMAL_GROWTH, 5));
    public static final ConfiguredFeature<?, ?> crystal_growth_seared = GaiaBiomeFeatures.registerFeature("crystal_growth_seared", GaiaBiomeFeatures.makeGrowthFeature(SEARED_GROWTH, 1));
    public static final ConfiguredFeature<?, ?> crystal_growth_corrupt = GaiaBiomeFeatures.registerFeature("crystal_growth_corrupt", GaiaBiomeFeatures.makeGrowthFeature(CORRUPT_GROWTH, 1));
    public static final ConfiguredFeature<?, ?> crystal_growth_aura = GaiaBiomeFeatures.registerFeature("crystal_growth_aura", GaiaBiomeFeatures.makeGrowthFeature(AURA_GROWTH, 2));
    public static final ConfiguredFeature<?, ?> crystal_blooms_common = GaiaBiomeFeatures.registerFeature("crystal_blooms_common", GaiaBiomeFeatures.makePlantFeature(COMMON_BLOOM, 2));
    public static final ConfiguredFeature<?, ?> crystal_blooms_rare = GaiaBiomeFeatures.registerFeature("crystal_blooms_rare", GaiaBiomeFeatures.makePlantFeature(RARE_BLOOM, 2));
    public static final ConfiguredFeature<?, ?> crystal_blooms_mutant = GaiaBiomeFeatures.registerFeature("crystal_blooms_mutant", GaiaBiomeFeatures.makePlantFeature(MUTANT_BLOOM, 2));
    public static final ConfiguredFeature<?, ?> crystal_blooms_corrupt = GaiaBiomeFeatures.registerFeature("crystal_blooms_corrupt", GaiaBiomeFeatures.makePlantFeature(CORRUPT_BLOOM, 1));
    public static final ConfiguredFeature<?, ?> spotted_kersei = GaiaBiomeFeatures.registerFeature("spotted_kersei", GaiaBiomeFeatures.makePlantFeature(KERSEI, 1));
    public static final ConfiguredFeature<?, ?> thorny_wiltha = GaiaBiomeFeatures.registerFeature("thorny_wiltha", GaiaBiomeFeatures.makePlantFeature(WILTHA, 1));
    public static final ConfiguredFeature<?, ?> roofed_agaric = GaiaBiomeFeatures.registerFeature("roofed_agaric", GaiaBiomeFeatures.makePlantFeature(AGARIC, 1));
    public static final ConfiguredFeature<?, ?> bulbous_hobina = GaiaBiomeFeatures.registerFeature("bulbous_hobina", GaiaBiomeFeatures.makePlantFeature(HOBINA, 1));
    public static final ConfiguredFeature<?, ?> stickly_cupsir = GaiaBiomeFeatures.registerFeature("stickly_cupsir", GaiaBiomeFeatures.makePlantFeature(CUPSIR, 1));
    public static final ConfiguredFeature<?, ?> mystical_murgni = GaiaBiomeFeatures.registerFeature("mystical_murgni", GaiaBiomeFeatures.makePlantFeature(MURGNI, 1));
    public static final ConfiguredFeature<?, ?> corrupted_gaia_eye = GaiaBiomeFeatures.registerFeature("corrupted_gaia_eye", GaiaBiomeFeatures.makePlantFeature(CORRUPT_EYE, 1));

    public static GaiaTreeFeatureConfig configureTree(BlockState log, BlockState leaves, int height, SaplingBlock sapling) {
        return new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), (BlockStateProvider)new SimpleBlockStateProvider(leaves), height).setSapling(sapling).build();
    }

    public static ConfiguredFeature<?, ?> makeOreFeature(RuleTest test, BlockState ore, int size, int height, int count) {
        return (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(test, ore, size)).func_242733_d(height)).func_242728_a()).func_242731_b(count);
    }

    public static ConfiguredFeature<?, ?> makeTreeFeature(Supplier<Feature<GaiaTreeFeatureConfig>> feature, GaiaTreeFeatureConfig config, int count, float chance, int extra) {
        return feature.get().func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, chance, extra)));
    }

    public static ConfiguredFeature<?, ?> makeGrowthFeature(BlockClusterFeatureConfig config, int count) {
        return (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(count);
    }

    public static ConfiguredFeature<?, ?> makePlantFeature(BlockClusterFeatureConfig config, int count) {
        return (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(count);
    }

    private static <SC extends ISurfaceBuilderConfig> ConfiguredSurfaceBuilder<SC> registerSurfaceBuilder(String name, ConfiguredSurfaceBuilder<SC> surface) {
        RegistryHelper.CONFIGURED_SURFACE_BUILDERS.put(surface, name);
        return surface;
    }

    private static <FC extends IFeatureConfig, F extends Structure<FC>> StructureFeature<FC, F> registerStructureFeature(String name, StructureFeature<FC, F> structure) {
        RegistryHelper.CONFIGURED_STRUCTURE_FEATURES.put(structure, name);
        return structure;
    }

    private static <WC extends ICarverConfig> ConfiguredCarver<WC> registerCarver(String name, ConfiguredCarver<WC> carver) {
        RegistryHelper.CONFIGURED_WORLD_CARVERS.put(carver, name);
        return carver;
    }

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> registerFeature(String name, ConfiguredFeature<FC, ?> feature) {
        RegistryHelper.CONFIGURED_FEATURES.put(feature, name);
        return feature;
    }

    public static void registerConfiguredWorldgen() {
        for (Map.Entry<ConfiguredSurfaceBuilder<?>, String> entry : RegistryHelper.CONFIGURED_SURFACE_BUILDERS.entrySet()) {
            WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243651_c, (ResourceLocation)new ResourceLocation("gaiadimension", entry.getValue()), entry.getKey());
        }
        for (Map.Entry<ConfiguredSurfaceBuilder<?>, String> entry : RegistryHelper.CONFIGURED_STRUCTURE_FEATURES.entrySet()) {
            WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("gaiadimension", entry.getValue()), entry.getKey());
        }
        for (Map.Entry<ConfiguredSurfaceBuilder<?>, String> entry : RegistryHelper.CONFIGURED_WORLD_CARVERS.entrySet()) {
            WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243652_d, (ResourceLocation)new ResourceLocation("gaiadimension", entry.getValue()), entry.getKey());
        }
        for (Map.Entry<ConfiguredSurfaceBuilder<?>, String> entry : RegistryHelper.CONFIGURED_FEATURES.entrySet()) {
            WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("gaiadimension", entry.getValue()), entry.getKey());
        }
    }
}

