/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry;

import androsa.gaiadimension.GaiaDimensionMod;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="gaiadimension", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModGaiaConfig {
    private static final String config = "gaiadimension.config.";
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> starsInSky;
    public static ResourceLocation startDimRL;
    public static RegistryKey<World> startDimRK;
    public static List<? extends String> starBiomes;
    public static ForgeConfigSpec.ConfigValue<? extends String> startDimension;
    public static ForgeConfigSpec.BooleanValue portalCheck;
    public static ForgeConfigSpec.EnumValue<ListType> listType;
    public static ForgeConfigSpec.EnumValue<BiomeType> biomeType;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> biomeList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> categoryList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> typeList;
    public static List<? extends String> biomes;
    public static List<? extends String> categories;
    public static List<? extends String> types;

    public static boolean canDisplayStars(RegistryKey<Biome> define) {
        return ((List)starsInSky.get()).contains(define.func_240901_a_().toString());
    }

    @SubscribeEvent
    public static void onConfigLoaded(ModConfig.Loading event) {
        System.out.println("Config Loading");
        if (event.getConfig().getModId().equals("gaiadimension")) {
            ModGaiaConfig.checkDimension();
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ModConfig.Reloading event) {
        if (event.getConfig().getModId().equals("gaiadimension")) {
            ModGaiaConfig.checkDimension();
        }
    }

    private static void checkDimension() {
        ResourceLocation rl = ResourceLocation.func_208304_a((String)((String)startDimension.get()));
        if (rl == null) {
            GaiaDimensionMod.LOGGER.warn("Could not create a ResourceLocation with the Start Dimension! Is there a typo, or is there an incorrect character?");
            rl = World.field_234918_g_.func_240901_a_();
        }
        startDimRL = rl;
        startDimRK = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)startDimRL);
    }

    static {
        starBiomes = Collections.singletonList("gaiadimension:purple_agate_swamp");
        biomes = ImmutableList.of((Object)"minecraft:desert", (Object)"minecraft:desert_hills", (Object)"minecraft:jungle", (Object)"minecraft:jungle_hills", (Object)"minecraft:jungle_edge", (Object)"minecraft:savanna", (Object)"minecraft:savanna_plateau", (Object)"minecraft:warm_ocean", (Object)"minecraft:deep_warm_ocean", (Object)"minecraft:desert_lakes", (Object)"minecraft:modified_jungle", (Object)"minecraft:modified_jungle_edge", (Object[])new String[]{"minecraft:shattered_savanna", "minecraft:shattered_savanna_plateau", "minecraft:eroded_badlands", "minecraft:modified_wooded_badlands_plateau", "minecraft:modified_badlands_plateau", "minecraft:bamboo_jungle", "minecraft:bamboo_jungle_hills", "minecraft:badlands", "minecraft:wooded_badlands_plateau", "minecraft:badlands_plateau", "minecraft:mountains", "minecraft:snowy_mountains", "minecraft:mountain_edge", "minecraft:wooded_mountains", "minecraft:gravelly_mountains", "minecraft:taiga_mountains", "minecraft:tall_birch_hills", "minecraft:dark_forest_hills", "minecraft:snowy_taiga_mountains", "minecraft:modified_gravelly_mountains"});
        categories = ImmutableList.of((Object)Biome.Category.DESERT.func_222352_a(), (Object)Biome.Category.EXTREME_HILLS.func_222352_a(), (Object)Biome.Category.MESA.func_222352_a(), (Object)Biome.Category.SAVANNA.func_222352_a(), (Object)Biome.Category.JUNGLE.func_222352_a());
        types = ImmutableList.of((Object)BiomeDictionary.Type.HOT.getName(), (Object)BiomeDictionary.Type.DRY.getName(), (Object)BiomeDictionary.Type.MOUNTAIN.getName());
    }

    public static enum BiomeType {
        BIOME,
        CATEGORY,
        TYPE;

    }

    public static enum ListType {
        BLACKLIST,
        WHITELIST;

    }

    public static class CommonConfig {
        public CommonConfig(ForgeConfigSpec.Builder builder) {
            startDimension = builder.translation("gaiadimension.config.start_dimension").comment("The Dimension that Gaia will connect to. Results may vary based on the World chosen. Existing portals will remain regardless of what is set here until they are broken, however they may no longer connect.").define("startDimension", (Object)"minecraft:overworld");
            portalCheck = builder.translation("gaiadimension.config.portal_creation").comment("Change how the portal can be created. If true, the portal will check where it is allowed to spawn based on the type of list and what contents are in the list.").define("portalCheck", true);
            listType = builder.translation("gaiadimension.config.list_type").comment("Changes whether the list to check is a blacklist or a whitelist. A blacklist will exclude biomes from the portal, anything not on the list is allowed. A whitelist will allow biomes for the portal, anything on the list is allowed. If portalCheck is false, this value is unused.").defineEnum("listType", (Enum)ListType.WHITELIST);
            biomeType = builder.translation("gaiadimension.config.biome_type").comment("Determines what list the biome checker should use. If set to BIOME, the list will check entries based on the individual biome. If set to CATEGORY, the list will check entries based on the biome's Category. If set to Type, the list will check entries based on the biome's BiomeDictionary Type. If portalCheck is false, this value is unused.").defineEnum("biomeType", (Enum)BiomeType.TYPE);
            biomeList = builder.translation("gaiadimension.config.biome_list").comment("A list of biomes to be used by the check list. Blacklists will ignore the biomes while whitelists will allow the biomes. This value is only checked if biomeType is set to BIOME.").defineList("biomeList", biomes, p -> true);
            categoryList = builder.translation("gaiadimension.config.category_list").comment("A list of biome Categories to be used by the check list. A Category is a single value assigned to a biome and is a vanilla system. Blacklists will ignore the Categories while whitelists will allow the Categories. This value is only checked if biomeType is set to CATEGORY.").defineList("categoryList", categories, p -> true);
            typeList = builder.translation("gaiadimension.config.type_list").comment("A list of biome Types to be used by the check list. A Type is a value that is assigned to a biome by Forge's BiomeDictionary system; one biome can have multiple Types. Blacklists will ignore biomes with the Tag while whitelists will allow biomes with the Tag. This value is only checked if biomeType is set to TYPE.").defineList("typeList", types, p -> true);
        }
    }

    public static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
            starsInSky = builder.translation("gaiadimension.config.stars_in_sky").comment("A list of biomes to always display stars. This will only work in the dimension as this is where stars are rendered per biome").defineList("starsInSky", starBiomes, p -> true);
        }
    }
}

