/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.carver;

import androsa.gaiadimension.block.AbstractGaiaGrassBlock;
import androsa.gaiadimension.block.GaiaSoilBlock;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModFluids;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CoatedCavesWorldCarver<T extends ProbabilityConfig>
extends WorldCarver<T> {
    public CoatedCavesWorldCarver(Codec<T> config, int height) {
        super(config, height);
        this.field_222718_j = ImmutableSet.of((Object)ModBlocks.glitter_grass.get(), (Object)ModBlocks.corrupt_grass.get(), (Object)ModBlocks.murky_grass.get(), (Object)ModBlocks.soft_grass.get(), (Object)ModBlocks.heavy_soil.get(), (Object)ModBlocks.corrupt_soil.get(), (Object[])new Block[]{(Block)ModBlocks.boggy_soil.get(), (Block)ModBlocks.light_soil.get(), (Block)ModBlocks.saltstone.get(), (Block)ModBlocks.gaia_stone.get(), (Block)ModBlocks.wasteland_stone.get(), (Block)ModBlocks.volcanic_rock.get(), (Block)ModBlocks.primal_mass.get()});
        this.field_222719_k = ImmutableSet.of((Object)ModFluids.mineral_water_still.get());
    }

    public boolean isStartChunk(Random rand, int chunkX, int chunkZ, T config) {
        return rand.nextFloat() <= ((ProbabilityConfig)config).field_203622_a;
    }

    public boolean carve(IChunk chunkIn, Function<BlockPos, Biome> biomePos, Random rand, int seaLevel, int posX, int posZ, int chunkX, int chunkZ, BitSet carvingMask, T config) {
        int i = (this.func_222704_c() * 2 - 1) * 16;
        int j = rand.nextInt(rand.nextInt(rand.nextInt(this.getChunkSize()) + 1) + 1);
        for (int k = 0; k < j; ++k) {
            double d0 = posX * 16 + rand.nextInt(16);
            double d1 = this.generateCaveStartY(rand);
            double d2 = posZ * 16 + rand.nextInt(16);
            int l = 1;
            if (rand.nextInt(4) == 0) {
                float f1 = 1.0f + rand.nextFloat() * 6.0f;
                this.genRoom(chunkIn, biomePos, rand.nextLong(), seaLevel, chunkX, chunkZ, d0, d1, d2, f1, 0.5, carvingMask);
                l += rand.nextInt(4);
            }
            for (int k1 = 0; k1 < l; ++k1) {
                float f = rand.nextFloat() * ((float)Math.PI * 2);
                float f3 = (rand.nextFloat() - 0.5f) / 4.0f;
                float f2 = this.generateCaveRadius(rand);
                int i1 = i - rand.nextInt(i / 4);
                this.genTunnels(chunkIn, biomePos, rand.nextLong(), seaLevel, chunkX, chunkZ, d0, d1, d2, f2, f, f3, 0, i1, this.getDiameter(), carvingMask);
            }
        }
        return true;
    }

    protected int getChunkSize() {
        return 15;
    }

    protected float generateCaveRadius(Random rand) {
        float f = rand.nextFloat() * 2.0f + rand.nextFloat();
        if (rand.nextInt(10) == 0) {
            f *= rand.nextFloat() * rand.nextFloat() * 3.0f + 1.0f;
        }
        return f;
    }

    protected double getDiameter() {
        return 1.0;
    }

    protected int generateCaveStartY(Random rand) {
        return rand.nextInt(rand.nextInt(120) + 8);
    }

    protected void genRoom(IChunk chunkIn, Function<BlockPos, Biome> biomePos, long seed, int seaLevel, int chunkX, int chunkZ, double x, double y, double z, float radius, double diameter, BitSet mask) {
        double d0 = 1.5 + (double)(MathHelper.func_76126_a((float)1.5707964f) * radius);
        double d1 = d0 * diameter;
        this.func_227208_a_(chunkIn, biomePos, seed, seaLevel, chunkX, chunkZ, x + 1.0, y, z, d0, d1, mask);
    }

    protected void genTunnels(IChunk chunkIn, Function<BlockPos, Biome> biomePos, long seed, int seaLevel, int centerX, int centerZ, double chunkX, double chunkY, double chunkZ, float radius, float yaw, float pitch, int baseSize, int maxSize, double diameter, BitSet mask) {
        Random random = new Random(seed);
        int i = random.nextInt(maxSize / 2) + maxSize / 4;
        boolean flag = random.nextInt(6) == 0;
        float f = 0.0f;
        float f1 = 0.0f;
        for (int j = baseSize; j < maxSize; ++j) {
            double d0 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)Math.PI * (float)j / (float)maxSize)) * radius);
            double d1 = d0 * diameter;
            float f2 = MathHelper.func_76134_b((float)pitch);
            chunkX += (double)(MathHelper.func_76134_b((float)yaw) * f2);
            chunkY += (double)MathHelper.func_76126_a((float)pitch);
            chunkZ += (double)(MathHelper.func_76126_a((float)yaw) * f2);
            pitch *= flag ? 0.92f : 0.7f;
            pitch += f1 * 0.1f;
            yaw += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (j == i && radius > 1.0f) {
                this.genTunnels(chunkIn, biomePos, random.nextLong(), seaLevel, centerX, centerZ, chunkX, chunkY, chunkZ, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, j, maxSize, 1.0, mask);
                this.genTunnels(chunkIn, biomePos, random.nextLong(), seaLevel, centerX, centerZ, chunkX, chunkY, chunkZ, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, j, maxSize, 1.0, mask);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!this.func_222702_a(centerX, centerZ, chunkX, chunkZ, j, maxSize, radius)) {
                return;
            }
            this.func_227208_a_(chunkIn, biomePos, seed, seaLevel, centerX, centerZ, chunkX, chunkY, chunkZ, d0, d1, mask);
        }
    }

    protected boolean func_230358_a_(IChunk chunkIn, Function<BlockPos, Biome> biomePos, BitSet carvingMask, Random rand, BlockPos.Mutable mutablePos, BlockPos.Mutable mutablePosAbove, BlockPos.Mutable mutablePosBelow, int seaLevel, int chunkX, int chunkZ, int posX, int posZ, int xVal, int yVal, int zVal, MutableBoolean flag) {
        int i = xVal | zVal << 4 | yVal << 8;
        if (carvingMask.get(i)) {
            return false;
        }
        carvingMask.set(i);
        mutablePos.func_181079_c(posX, yVal, posZ);
        BlockState blockstate = chunkIn.func_180495_p((BlockPos)mutablePos);
        BlockState blockstate1 = chunkIn.func_180495_p((BlockPos)mutablePosAbove.func_189533_g((Vector3i)mutablePos).func_189536_c(Direction.UP));
        if (blockstate.func_177230_c() instanceof AbstractGaiaGrassBlock) {
            flag.setTrue();
        }
        if (!this.func_222707_a(blockstate, blockstate1)) {
            return false;
        }
        if (yVal < 11) {
            chunkIn.func_177436_a((BlockPos)mutablePos, ((FlowingFluidBlock)ModBlocks.superhot_magma.get()).func_176223_P(), false);
        } else {
            chunkIn.func_177436_a((BlockPos)mutablePos, field_222715_g, false);
            if (flag.isTrue()) {
                mutablePosBelow.func_189533_g((Vector3i)mutablePos).func_189536_c(Direction.DOWN);
                if (chunkIn.func_180495_p((BlockPos)mutablePosBelow).func_177230_c() instanceof GaiaSoilBlock) {
                    chunkIn.func_177436_a((BlockPos)mutablePosBelow, biomePos.apply((BlockPos)mutablePos).func_242440_e().func_242502_e().func_204108_a(), false);
                }
            }
        }
        return true;
    }

    protected boolean func_222708_a(double xPos, double yPos, double zPos, int yVal) {
        return yPos <= -0.7 || xPos * xPos + yPos * yPos + zPos * zPos >= 1.0;
    }
}

