/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

@ParametersAreNonnullByDefault
public class BismuthGeyserFeature<T extends NoFeatureConfig>
extends Feature<T> {
    private static final Block GRASS = (Block)ModBlocks.murky_grass.get();

    public BismuthGeyserFeature(Codec<T> configIn) {
        super(configIn);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, T config) {
        for (int cx = 0; cx < 5; ++cx) {
            for (int cz = 0; cz < 5; ++cz) {
                Block blockBelow;
                BlockPos pos = position.func_177982_a(cx - 2, 0, cz - 2);
                if (!worldIn.func_175667_e(pos) || (blockBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()) == GRASS) continue;
                return false;
            }
        }
        for (int bx = -2; bx <= 2; ++bx) {
            for (int bz = -2; bz <= 2; ++bz) {
                if (Math.abs(bx) == 2 && Math.abs(bz) == 2) continue;
                if (bx == 0 && bz == 0) {
                    worldIn.func_180501_a(position.func_177982_a(bx, 0, bz), ((Block)ModBlocks.geyser_block.get()).func_176223_P(), 2);
                    continue;
                }
                if (bx < 2 && bz < 2 && bx > -2 && bz > -2) {
                    worldIn.func_180501_a(position.func_177982_a(bx, 0, bz), ((Block)ModBlocks.boggy_soil.get()).func_176223_P(), 2);
                    continue;
                }
                worldIn.func_180501_a(position.func_177982_a(bx, 0, bz), GRASS.func_176223_P(), 2);
            }
        }
        for (int tx = -1; tx <= 1; ++tx) {
            for (int tz = -1; tz <= 1; ++tz) {
                if (tx == 0 && tz == 0) continue;
                worldIn.func_180501_a(position.func_177982_a(tx, 1, tz), GRASS.func_176223_P(), 2);
            }
        }
        return true;
    }
}

