/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.world.gen.config.FeatureHeightConfig;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;

@ParametersAreNonnullByDefault
public class BismuthSpireFeature<T extends FeatureHeightConfig>
extends Feature<T> {
    public BismuthSpireFeature(Codec<T> configIn) {
        super(configIn);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, T config) {
        for (int cx = 0; cx < 3; ++cx) {
            for (int cz = 0; cz < 3; ++cz) {
                Block blockBelow;
                BlockPos pos = position.func_177982_a(cx - 1, 0, cz - 1);
                if (!worldIn.func_175667_e(pos) || (blockBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()) == ModBlocks.murky_grass.get()) continue;
                return false;
            }
        }
        int height = ((FeatureHeightConfig)config).startHeight + rand.nextInt(4);
        int heightA = height - rand.nextInt(4) - 2;
        int heightD = height / 2 - (rand.nextInt(5) - 2);
        int heightE = rand.nextInt(3);
        for (int i = 0; i < height; ++i) {
            if (i < heightE) {
                for (int ex = -2; ex <= 2; ++ex) {
                    for (int ez = -2; ez <= 2; ++ez) {
                        if (Math.abs(ex) == 2 && Math.abs(ez) == 2) continue;
                        this.setBismuthType((IWorldGenerationReader)worldIn, rand, position.func_177982_a(ex, i, ez));
                    }
                }
                continue;
            }
            if (i < heightD) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        this.setBismuthType((IWorldGenerationReader)worldIn, rand, position.func_177982_a(dx, i, dz));
                    }
                }
                continue;
            }
            if (i < heightA) {
                for (int ax = -1; ax <= 1; ++ax) {
                    for (int az = -1; az <= 1; ++az) {
                        if (Math.abs(ax) == 1 && Math.abs(az) == 1) continue;
                        this.setBismuthType((IWorldGenerationReader)worldIn, rand, position.func_177982_a(ax, i, az));
                    }
                }
                continue;
            }
            this.setBismuthType((IWorldGenerationReader)worldIn, rand, position.func_177981_b(i));
        }
        return true;
    }

    private void setBismuthType(IWorldGenerationReader world, Random random, BlockPos pos) {
        BlockState state = random.nextInt(30) == 0 ? ((Block)ModBlocks.bismuth_block.get()).func_176223_P() : (random.nextInt(15) == 0 ? ((Block)ModBlocks.active_rock.get()).func_176223_P() : ((Block)ModBlocks.impure_rock.get()).func_176223_P());
        world.func_180501_a(pos, state, 2);
    }
}

