/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;

@ParametersAreNonnullByDefault
public class BogPatchFeature<T extends SphereReplaceConfig>
extends Feature<T> {
    public BogPatchFeature(Codec<T> configIn) {
        super(configIn);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, T config) {
        int range = random.nextInt(2) + 2;
        int yRange = 1;
        for (int dx = pos.func_177958_n() - range; dx <= pos.func_177958_n() + range; ++dx) {
            for (int dz = pos.func_177952_p() - range; dz <= pos.func_177952_p() + range; ++dz) {
                int i2;
                int l1 = dx - pos.func_177958_n();
                if (l1 * l1 + (i2 = dz - pos.func_177952_p()) * i2 > range * range) continue;
                for (int dy = pos.func_177956_o() - yRange; dy <= pos.func_177956_o() + yRange; ++dy) {
                    BlockPos dPos = new BlockPos(dx, dy, dz);
                    Block blockThere = world.func_180495_p(dPos).func_177230_c();
                    if (blockThere != ModBlocks.murky_grass.get() || random.nextInt(6) == 0) continue;
                    world.func_180501_a(dPos, ((Block)ModBlocks.impure_sludge.get()).func_176223_P(), 2);
                }
            }
        }
        return true;
    }
}

