/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import androsa.gaiadimension.world.gen.feature.GaiaTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

@ParametersAreNonnullByDefault
public class FieryAgateTreeFeature<T extends GaiaTreeFeatureConfig>
extends GaiaTreeFeature<T> {
    public FieryAgateTreeFeature(Codec<T> configIn) {
        super(configIn);
    }

    @Override
    public boolean generate(ISeedReader worldIn, Random rand, BlockPos position, Set<BlockPos> logPos, Set<BlockPos> leavesPos, MutableBoundingBox boundingBox, T config) {
        int height = rand.nextInt(3) + rand.nextInt(3) + ((GaiaTreeFeatureConfig)config).minHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && flag; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && flag; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (FieryAgateTreeFeature.validTreePos((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (FieryAgateTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), ((GaiaTreeFeatureConfig)config).getSapling(rand, position)) && position.func_177956_o() < worldIn.func_234938_ad_() - height - 1) {
                this.setBlockState((IWorldWriter)worldIn, position.func_177977_b(), ((Block)ModBlocks.heavy_soil.get()).func_176223_P(), boundingBox);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int k1 = 0;
                for (int base = 0; base < height; ++base) {
                    int i2 = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, i2, posZ);
                    if (!FieryAgateTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos)) continue;
                    this.setLogBlockState((IWorld)worldIn, rand, blockpos, logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    k1 = i2;
                }
                BlockPos blockpos2 = new BlockPos(posX, k1, posZ);
                for (int j3 = -2; j3 <= 2; ++j3) {
                    for (int i4 = -2; i4 <= 2; ++i4) {
                        if (Math.abs(j3) == 2 && Math.abs(i4) == 2) continue;
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(j3, 0, i4), leavesPos, boundingBox, config);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(k3, 0, j4), leavesPos, boundingBox, config);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

