/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import androsa.gaiadimension.world.gen.feature.GaiaTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

@ParametersAreNonnullByDefault
public class GoldstoneCorruptTreeFeature<T extends GaiaTreeFeatureConfig>
extends GaiaTreeFeature<T> {
    public GoldstoneCorruptTreeFeature(Codec<T> configIn) {
        super(configIn);
    }

    @Override
    public boolean generate(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> logPos, Set<BlockPos> leavesPos, MutableBoundingBox boundingBox, T config) {
        int height = rand.nextInt(5) + ((GaiaTreeFeatureConfig)config).minHeight;
        int j = height - rand.nextInt(2) - 3;
        int k = height - j;
        int l = 1 + rand.nextInt(k + 1);
        boolean allClear = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int cy = pos.func_177956_o(); cy <= pos.func_177956_o() + 1 + height && allClear; ++cy) {
                int j1 = cy - pos.func_177956_o() < j ? 0 : l;
                for (int cx = pos.func_177958_n() - j1; cx <= pos.func_177958_n() + j1 && allClear; ++cx) {
                    for (int cz = pos.func_177952_p() - j1; cz <= pos.func_177952_p() + j1 && allClear; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            BlockPos cPos = new BlockPos(cx, cy, cz);
                            if (GoldstoneCorruptTreeFeature.validTreePos((IWorldGenerationBaseReader)world, cPos)) continue;
                            allClear = false;
                            continue;
                        }
                        allClear = false;
                    }
                }
            }
            if (!allClear) {
                return false;
            }
            if (GoldstoneCorruptTreeFeature.isSoil((IWorldGenerationBaseReader)world, pos.func_177977_b(), ((GaiaTreeFeatureConfig)config).getSapling(rand, pos)) && pos.func_177956_o() < world.func_234938_ad_() - height - 1) {
                this.setBlockState((IWorldWriter)world, pos.func_177977_b(), ((Block)ModBlocks.corrupt_soil.get()).func_176223_P(), boundingBox);
                int k2 = 0;
                for (int l2 = pos.func_177956_o() + height; l2 >= pos.func_177956_o() + j; --l2) {
                    for (int j3 = pos.func_177958_n() - k2; j3 <= pos.func_177958_n() + k2; ++j3) {
                        int k3 = j3 - pos.func_177958_n();
                        for (int i2 = pos.func_177952_p() - k2; i2 <= pos.func_177952_p() + k2; ++i2) {
                            int j2 = i2 - pos.func_177952_p();
                            BlockPos tPos = new BlockPos(j3, l2, i2);
                            if (Math.abs(k3) == k2 && Math.abs(j2) == k2 && k2 > 0 || !GoldstoneCorruptTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, tPos)) continue;
                            this.setLeavesBlockState((IWorld)world, rand, tPos, leavesPos, boundingBox, config);
                        }
                    }
                    if (k2 >= 1 && l2 == pos.func_177956_o() + j + 1) {
                        --k2;
                        continue;
                    }
                    if (k2 >= l) continue;
                    ++k2;
                }
                for (int i3 = 0; i3 < height - 1; ++i3) {
                    BlockPos cPos = pos.func_177981_b(i3);
                    if (!GoldstoneCorruptTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, cPos)) continue;
                    this.setLogBlockState((IWorld)world, rand, cPos, logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

