/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import androsa.gaiadimension.world.gen.feature.GaiaTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

@ParametersAreNonnullByDefault
public class GreenAgateTreeFeature<T extends GaiaTreeFeatureConfig>
extends GaiaTreeFeature<T> {
    public GreenAgateTreeFeature(Codec<T> configIn) {
        super(configIn);
    }

    @Override
    public boolean generate(ISeedReader worldIn, Random rand, BlockPos position, Set<BlockPos> logPos, Set<BlockPos> leavesPos, MutableBoundingBox boundingBox, T config) {
        int height = rand.nextInt(3) + rand.nextInt(3) + ((GaiaTreeFeatureConfig)config).minHeight;
        boolean isValidBonemealTarget = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && isValidBonemealTarget; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && isValidBonemealTarget; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (GreenAgateTreeFeature.validTreePos((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            isValidBonemealTarget = false;
                            continue;
                        }
                        isValidBonemealTarget = false;
                    }
                }
            }
            if (!isValidBonemealTarget) {
                return false;
            }
            if (GreenAgateTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), ((GaiaTreeFeatureConfig)config).getSapling(rand, position)) && position.func_177956_o() < worldIn.func_234938_ad_() - height - 1) {
                this.setBlockState((IWorldWriter)worldIn, position.func_177977_b(), ((Block)ModBlocks.heavy_soil.get()).func_176223_P(), boundingBox);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                for (int base = 0; base < height; ++base) {
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    if (!GreenAgateTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos)) continue;
                    if (base == 0) {
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177964_d(2), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177970_e(2), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177965_g(2), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177985_f(2), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    }
                    if (base < height / 4) {
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177982_a(1, 0, 1), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177982_a(1, 0, -1), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177982_a(-1, 0, 1), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177982_a(-1, 0, -1), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    }
                    this.setLogBlockState((IWorld)worldIn, rand, blockpos, logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177978_c(), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177968_d(), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177974_f(), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    this.setLogBlockState((IWorld)worldIn, rand, blockpos.func_177976_e(), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ);
                for (int leafX1 = -3; leafX1 <= 3; ++leafX1) {
                    for (int leafZ1 = -3; leafZ1 <= 3; ++leafZ1) {
                        if (Math.abs(leafX1) == 3 && Math.abs(leafZ1) == 3) continue;
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(leafX1, 0, leafZ1), leavesPos, boundingBox, config);
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(leafX1, -1, leafZ1), leavesPos, boundingBox, config);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafX2 = -1; leafX2 <= 1; ++leafX2) {
                    for (int leafZ = -1; leafZ <= 1; ++leafZ) {
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(leafX2, 0, leafZ), leavesPos, boundingBox, config);
                    }
                }
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177965_g(2), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177985_f(2), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177970_e(2), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177964_d(2), leavesPos, boundingBox, config);
                blockpos2 = blockpos2.func_177979_c(3);
                for (int leafX3 = -2; leafX3 <= 2; ++leafX3) {
                    for (int leafZ3 = -2; leafZ3 <= 2; ++leafZ3) {
                        if (Math.abs(leafX3) == 2 && Math.abs(leafZ3) == 2) continue;
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(leafX3, 0, leafZ3), leavesPos, boundingBox, config);
                    }
                }
                blockpos2 = blockpos2.func_177977_b();
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(1, 0, 1), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(1, 0, -1), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(-1, 0, 1), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(-1, 0, -1), leavesPos, boundingBox, config);
                return true;
            }
            return false;
        }
        return false;
    }
}

