/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.pieces;

import androsa.gaiadimension.block.BossSpawnerBlock;
import androsa.gaiadimension.block.tileentity.SmallCrateTileEntity;
import androsa.gaiadimension.registry.GaiaChestTables;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModWorldgen;
import androsa.gaiadimension.world.gen.structure.processor.MalachiteDegradeProcessor;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MalachiteWatchtowerPieces {
    private static final ResourceLocation foyer = MalachiteWatchtowerPieces.makePiece("foyer");
    private static final ResourceLocation floor1_1 = MalachiteWatchtowerPieces.makePiece("floor1_1");
    private static final ResourceLocation floor1_2 = MalachiteWatchtowerPieces.makePiece("floor1_2");
    private static final ResourceLocation floor1_3 = MalachiteWatchtowerPieces.makePiece("floor1_3");
    private static final ResourceLocation floor_random1 = MalachiteWatchtowerPieces.makePiece("floor_random1");
    private static final ResourceLocation floor_random2 = MalachiteWatchtowerPieces.makePiece("floor_random2");
    private static final ResourceLocation floor_random3 = MalachiteWatchtowerPieces.makePiece("floor_random3");
    private static final ResourceLocation floor_random4 = MalachiteWatchtowerPieces.makePiece("floor_random4");
    private static final ResourceLocation floor_random5 = MalachiteWatchtowerPieces.makePiece("floor_random5");
    private static final ResourceLocation floor_random1_m = MalachiteWatchtowerPieces.makePiece("floor_random1_m");
    private static final ResourceLocation floor_random2_m = MalachiteWatchtowerPieces.makePiece("floor_random2_m");
    private static final ResourceLocation floor_random3_m = MalachiteWatchtowerPieces.makePiece("floor_random3_m");
    private static final ResourceLocation floor_random4_m = MalachiteWatchtowerPieces.makePiece("floor_random4_m");
    private static final ResourceLocation floor_random5_m = MalachiteWatchtowerPieces.makePiece("floor_random5_m");
    private static final ResourceLocation roof = MalachiteWatchtowerPieces.makePiece("roof");
    private static final ResourceLocation roof_m = MalachiteWatchtowerPieces.makePiece("roof_m");
    private static final ResourceLocation[] first_floors = new ResourceLocation[]{floor1_1, floor1_2, floor1_3};
    private static final ResourceLocation[] next_floors = new ResourceLocation[]{floor_random1, floor_random2, floor_random3, floor_random4, floor_random5};
    private static final ResourceLocation[] next_floors_m = new ResourceLocation[]{floor_random1_m, floor_random2_m, floor_random3_m, floor_random4_m, floor_random5_m};
    private static final BlockPos baseCenter = new BlockPos(15, 15, 15);
    private static final BlockPos f1Center = new BlockPos(12, 11, 12);
    private static final BlockPos roofCenter = new BlockPos(16, 23, 16);
    private static final BlockPos offsetNoneBig = new BlockPos(5, 0, 6);
    private static final BlockPos offsetC90Big = new BlockPos(0, 0, 5);
    private static final BlockPos offsetC180Big = new BlockPos(1, 0, 0);
    private static final BlockPos offsetCC90Big = new BlockPos(6, 0, 1);
    private static final BlockPos offsetNoneSmall = new BlockPos(0, 0, 1);
    private static final BlockPos offsetC90Small = new BlockPos(-3, 0, 0);
    private static final BlockPos offsetC180Small = new BlockPos(-2, 0, -3);
    private static final BlockPos offsetCC90Small = new BlockPos(1, 0, -2);
    private static final ImmutableMap<Rotation, BlockPos> offsetBig = ImmutableMap.of((Object)Rotation.NONE, (Object)offsetNoneBig, (Object)Rotation.CLOCKWISE_90, (Object)offsetC90Big, (Object)Rotation.CLOCKWISE_180, (Object)offsetC180Big, (Object)Rotation.COUNTERCLOCKWISE_90, (Object)offsetCC90Big);
    private static final ImmutableMap<Rotation, BlockPos> offsetSmall = ImmutableMap.of((Object)Rotation.NONE, (Object)offsetNoneSmall, (Object)Rotation.CLOCKWISE_90, (Object)offsetC90Small, (Object)Rotation.CLOCKWISE_180, (Object)offsetC180Small, (Object)Rotation.COUNTERCLOCKWISE_90, (Object)offsetCC90Small);
    protected static final ImmutableMap<ResourceLocation, BlockPos> centerList = ImmutableMap.builder().put((Object)foyer, (Object)baseCenter).put((Object)floor1_1, (Object)f1Center).put((Object)floor1_2, (Object)f1Center).put((Object)floor1_3, (Object)f1Center).put((Object)floor_random1, (Object)f1Center).put((Object)floor_random2, (Object)f1Center).put((Object)floor_random3, (Object)f1Center).put((Object)floor_random4, (Object)f1Center).put((Object)floor_random5, (Object)f1Center).put((Object)floor_random1_m, (Object)f1Center).put((Object)floor_random2_m, (Object)f1Center).put((Object)floor_random3_m, (Object)f1Center).put((Object)floor_random4_m, (Object)f1Center).put((Object)floor_random5_m, (Object)f1Center).put((Object)roof, (Object)roofCenter).put((Object)roof_m, (Object)roofCenter).build();

    public static void buildStructure(TemplateManager manager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random) {
        int i = 0;
        pieces.add((StructurePiece)new Piece(manager, foyer, pos, rotation, i));
        pieces.add((StructurePiece)new Piece(manager, first_floors[random.nextInt(first_floors.length)], pos.func_177971_a((Vector3i)offsetBig.get((Object)rotation)), rotation, i += 14));
        int r = random.nextInt(2) + 4;
        for (int f = 0; f < r; ++f) {
            i += 10;
            if (f == r - 1) {
                if (f % 2 == 0) {
                    pieces.add((StructurePiece)new Piece(manager, roof_m, pos.func_177971_a((Vector3i)offsetSmall.get((Object)rotation)), rotation, i));
                    continue;
                }
                pieces.add((StructurePiece)new Piece(manager, roof, pos.func_177971_a((Vector3i)offsetSmall.get((Object)rotation)), rotation, i));
                continue;
            }
            if (f % 2 == 0) {
                pieces.add((StructurePiece)new Piece(manager, next_floors[random.nextInt(next_floors.length)], pos.func_177971_a((Vector3i)offsetBig.get((Object)rotation)), rotation, i));
                continue;
            }
            pieces.add((StructurePiece)new Piece(manager, next_floors_m[random.nextInt(next_floors_m.length)], pos.func_177971_a((Vector3i)offsetBig.get((Object)rotation)), rotation, i));
        }
    }

    public static ResourceLocation makePiece(String part) {
        return new ResourceLocation("gaiadimension", "watchtower/" + part);
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation pieceName;
        private final Rotation rotation;

        public Piece(TemplateManager manager, ResourceLocation pieceloc, BlockPos pos, Rotation rot, int offset) {
            super(ModWorldgen.StructureTypes.MAWA, 0);
            this.pieceName = pieceloc;
            this.field_186178_c = pos.func_177982_a(0, offset, 0);
            this.rotation = rot;
            this.loadTemplate(manager);
        }

        public Piece(TemplateManager manager, CompoundNBT nbt) {
            super(ModWorldgen.StructureTypes.MAWA, nbt);
            this.pieceName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager manager) {
            Template template = manager.func_200220_a(this.pieceName);
            PlacementSettings settings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)centerList.get((Object)this.pieceName)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a).func_215222_a((StructureProcessor)new MalachiteDegradeProcessor(0.2f));
            this.func_186173_a(template, this.field_186178_c, settings);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.pieceName.toString());
            nbt.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String name, BlockPos pos, IServerWorld world, Random random, MutableBoundingBox mbb) {
            TileEntity tileentity;
            if ("ChestChance".equals(name)) {
                if (random.nextDouble() > 0.5) {
                    world.func_180501_a(pos, ((Block)ModBlocks.crude_storage_crate.get()).func_176223_P(), 3);
                    tileentity = world.func_175625_s(pos);
                    if (tileentity instanceof SmallCrateTileEntity) {
                        ((SmallCrateTileEntity)tileentity).func_189404_a(GaiaChestTables.CHESTS_MALACHITE_WATCHTOWER, random.nextLong());
                    }
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
            if ("Chest".equals(name)) {
                world.func_180501_a(pos, ((Block)ModBlocks.crude_storage_crate.get()).func_176223_P(), 3);
                tileentity = world.func_175625_s(pos);
                if (tileentity instanceof SmallCrateTileEntity) {
                    ((SmallCrateTileEntity)tileentity).func_189404_a(GaiaChestTables.CHESTS_MALACHITE_WATCHTOWER, random.nextLong());
                }
            }
            if ("Boss".equals(name)) {
                world.func_180501_a(pos, ((BossSpawnerBlock)ModBlocks.malachite_guard_spawner.get()).func_176223_P(), 3);
            }
        }
    }
}

