/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.pieces;

import androsa.gaiadimension.block.tileentity.SmallCrateTileEntity;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModWorldgen;
import androsa.gaiadimension.world.gen.structure.processor.BlockDegradeProcessor;
import androsa.gaiadimension.world.gen.structure.processor.MiniTowerType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MiniTowerPieces {
    private static final ResourceLocation am_base = MiniTowerPieces.makePiece("amethyst", "base");
    private static final ResourceLocation am_floor_1 = MiniTowerPieces.makePiece("amethyst", "floor_1");
    private static final ResourceLocation am_floor_2 = MiniTowerPieces.makePiece("amethyst", "floor_2");
    private static final ResourceLocation am_roof = MiniTowerPieces.makePiece("amethyst", "roof");
    private static final ResourceLocation co_base = MiniTowerPieces.makePiece("copal", "base");
    private static final ResourceLocation co_floor_1 = MiniTowerPieces.makePiece("copal", "floor_1");
    private static final ResourceLocation co_floor_2 = MiniTowerPieces.makePiece("copal", "floor_2");
    private static final ResourceLocation co_roof = MiniTowerPieces.makePiece("copal", "roof");
    private static final ResourceLocation ja_base = MiniTowerPieces.makePiece("jade", "base");
    private static final ResourceLocation ja_floor_1 = MiniTowerPieces.makePiece("jade", "floor_1");
    private static final ResourceLocation ja_floor_2 = MiniTowerPieces.makePiece("jade", "floor_2");
    private static final ResourceLocation ja_roof = MiniTowerPieces.makePiece("jade", "roof");
    private static final ResourceLocation je_base = MiniTowerPieces.makePiece("jet", "base");
    private static final ResourceLocation je_floor_1 = MiniTowerPieces.makePiece("jet", "floor_1");
    private static final ResourceLocation je_floor_2 = MiniTowerPieces.makePiece("jet", "floor_2");
    private static final ResourceLocation je_roof = MiniTowerPieces.makePiece("jet", "roof");
    private static final ResourceLocation[] amethyst_pieces = new ResourceLocation[]{am_base, am_floor_1, am_floor_2, am_roof};
    private static final ResourceLocation[] copal_pieces = new ResourceLocation[]{co_base, co_floor_1, co_floor_2, co_roof};
    private static final ResourceLocation[] jade_pieces = new ResourceLocation[]{ja_base, ja_floor_1, ja_floor_2, ja_roof};
    private static final ResourceLocation[] jet_pieces = new ResourceLocation[]{je_base, je_floor_1, je_floor_2, je_roof};
    private static final BlockPos baseCenter = new BlockPos(8, 7, 8);
    private static final BlockPos f1Center = new BlockPos(7, 11, 7);
    private static final BlockPos f2Center = new BlockPos(7, 10, 7);
    private static final BlockPos roofCenter = new BlockPos(8, 9, 8);
    private static final BlockPos blockpos_1 = new BlockPos(0, 1, 0);
    private static final BlockPos blockpos_2 = new BlockPos(1, 0, 1);
    private static final ImmutableMap<ResourceLocation, BlockPos> centerList = ImmutableMap.builder().put((Object)am_base, (Object)baseCenter).put((Object)co_base, (Object)baseCenter).put((Object)ja_base, (Object)baseCenter).put((Object)je_base, (Object)baseCenter).put((Object)am_floor_1, (Object)f1Center).put((Object)co_floor_1, (Object)f1Center).put((Object)ja_floor_1, (Object)f1Center).put((Object)je_floor_1, (Object)f1Center).put((Object)am_floor_2, (Object)f2Center).put((Object)co_floor_2, (Object)f2Center).put((Object)ja_floor_2, (Object)f2Center).put((Object)je_floor_2, (Object)f2Center).put((Object)am_roof, (Object)roofCenter).put((Object)co_roof, (Object)roofCenter).put((Object)ja_roof, (Object)roofCenter).put((Object)je_roof, (Object)roofCenter).build();
    private static final ImmutableMap<ResourceLocation, BlockPos> piecePos = ImmutableMap.builder().put((Object)am_base, (Object)blockpos_1).put((Object)co_base, (Object)blockpos_1).put((Object)ja_base, (Object)blockpos_1).put((Object)je_base, (Object)blockpos_1).put((Object)am_floor_1, (Object)blockpos_2).put((Object)co_floor_1, (Object)blockpos_2).put((Object)ja_floor_1, (Object)blockpos_2).put((Object)je_floor_1, (Object)blockpos_2).put((Object)am_floor_2, (Object)blockpos_2).put((Object)co_floor_2, (Object)blockpos_2).put((Object)ja_floor_2, (Object)blockpos_2).put((Object)je_floor_2, (Object)blockpos_2).put((Object)am_roof, (Object)blockpos_1).put((Object)co_roof, (Object)blockpos_1).put((Object)ja_roof, (Object)blockpos_1).put((Object)je_roof, (Object)blockpos_1).build();

    public static void buildStructure(TemplateManager manager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random) {
        MiniTowerType type;
        ResourceLocation[] piecearray;
        switch (random.nextInt(MiniTowerType.values().length)) {
            case 0: {
                piecearray = amethyst_pieces;
                type = MiniTowerType.AMETHYST;
                break;
            }
            case 1: {
                piecearray = copal_pieces;
                type = MiniTowerType.COPAL;
                break;
            }
            case 2: {
                piecearray = jade_pieces;
                type = MiniTowerType.JADE;
                break;
            }
            default: {
                piecearray = jet_pieces;
                type = MiniTowerType.JET;
            }
        }
        int i = 0;
        pieces.add((StructurePiece)new Piece(manager, piecearray[0], pos, rotation, type, i));
        pieces.add((StructurePiece)new Piece(manager, piecearray[1], pos, rotation, type, i += 8));
        pieces.add((StructurePiece)new Piece(manager, piecearray[2], pos, rotation, type, i += 11));
        pieces.add((StructurePiece)new Piece(manager, piecearray[3], pos, rotation, type, i += 9));
    }

    public static ResourceLocation makePiece(String material, String part) {
        return new ResourceLocation("gaiadimension", "minitower/" + material + "/" + part);
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation pieceLocation;
        private final Rotation rotation;
        private final MiniTowerType towerType;

        public Piece(TemplateManager manager, ResourceLocation pieceloc, BlockPos pos, Rotation rot, MiniTowerType type, int offset) {
            super(ModWorldgen.StructureTypes.MITO, 0);
            this.pieceLocation = pieceloc;
            BlockPos blockpos = (BlockPos)piecePos.get((Object)pieceloc);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o() + offset, blockpos.func_177952_p());
            this.rotation = rot;
            this.towerType = type;
            this.loadTemplate(manager);
        }

        public Piece(TemplateManager manager, CompoundNBT nbt) {
            super(ModWorldgen.StructureTypes.MITO, nbt);
            this.pieceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.towerType = MiniTowerType.valueOf(nbt.func_74779_i("TowerType"));
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager manager) {
            Template template = manager.func_200220_a(this.pieceLocation);
            PlacementSettings settings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)centerList.get((Object)this.pieceLocation)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            switch (this.towerType) {
                case AMETHYST: {
                    settings.func_215222_a((StructureProcessor)BlockDegradeProcessor.AMETHYST_DECAY);
                    break;
                }
                case COPAL: {
                    settings.func_215222_a((StructureProcessor)BlockDegradeProcessor.COPAL_DECAY);
                    break;
                }
                case JADE: {
                    settings.func_215222_a((StructureProcessor)BlockDegradeProcessor.JADE_DECAY);
                    break;
                }
                case JET: {
                    settings.func_215222_a((StructureProcessor)BlockDegradeProcessor.JET_DECAY);
                }
            }
            this.func_186173_a(template, this.field_186178_c, settings);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.pieceLocation.toString());
            nbt.func_74778_a("Rot", this.rotation.name());
            nbt.func_74778_a("TowerType", this.towerType.toString());
        }

        protected void func_186175_a(String name, BlockPos pos, IServerWorld world, Random random, MutableBoundingBox mbb) {
            if ("Chest".equals(name)) {
                if (random.nextDouble() > 0.5) {
                    world.func_180501_a(pos, ((Block)ModBlocks.crude_storage_crate.get()).func_176223_P(), 3);
                    TileEntity tileentity = world.func_175625_s(pos);
                    if (tileentity instanceof SmallCrateTileEntity) {
                        ((SmallCrateTileEntity)tileentity).func_189404_a(this.towerType.getChestLoot(), random.nextLong());
                    }
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random random, MutableBoundingBox mbb, ChunkPos chunkpos, BlockPos pos) {
            this.field_186177_b.func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)centerList.get((Object)this.pieceLocation)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            switch (this.towerType) {
                case AMETHYST: {
                    this.field_186177_b.func_215222_a((StructureProcessor)BlockDegradeProcessor.AMETHYST_DECAY);
                    break;
                }
                case COPAL: {
                    this.field_186177_b.func_215222_a((StructureProcessor)BlockDegradeProcessor.COPAL_DECAY);
                    break;
                }
                case JADE: {
                    this.field_186177_b.func_215222_a((StructureProcessor)BlockDegradeProcessor.JADE_DECAY);
                    break;
                }
                case JET: {
                    this.field_186177_b.func_215222_a((StructureProcessor)BlockDegradeProcessor.JET_DECAY);
                }
            }
            BlockPos blockpos = (BlockPos)piecePos.get((Object)this.pieceLocation);
            BlockPos blockpos1 = this.field_186178_c.func_177971_a((Vector3i)Template.func_186266_a((PlacementSettings)this.field_186177_b, (BlockPos)new BlockPos(3 - blockpos.func_177958_n(), 0, 0 - blockpos.func_177952_p())));
            int height = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n(), blockpos1.func_177952_p());
            BlockPos blockpos2 = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, height - 90 - 1, 0);
            boolean flag = super.func_230383_a_(world, manager, generator, random, mbb, chunkpos, pos);
            this.field_186178_c = blockpos2;
            return flag;
        }
    }
}

