/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.processor;

import androsa.gaiadimension.registry.GaiaChestTables;
import androsa.gaiadimension.registry.ModBlocks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public enum MiniTowerType implements IStringSerializable
{
    AMETHYST("AMETHYST", GaiaChestTables.CHESTS_MINITOWER_AMETHYST, (Supplier<Block>)ModBlocks.amethyst_bricks, (ImmutableList<Supplier<Block>>)ImmutableList.of(ModBlocks.cracked_amethyst_bricks, ModBlocks.crusted_amethyst_bricks), (Supplier<StairsBlock>)ModBlocks.amethyst_brick_stairs, (ImmutableList<Supplier<StairsBlock>>)ImmutableList.of(ModBlocks.cracked_amethyst_brick_stairs, ModBlocks.crusted_amethyst_brick_stairs), (Supplier<SlabBlock>)ModBlocks.amethyst_brick_slab, (ImmutableList<Supplier<SlabBlock>>)ImmutableList.of(ModBlocks.cracked_amethyst_brick_slab, ModBlocks.crusted_amethyst_brick_slab)),
    COPAL("COPAL", GaiaChestTables.CHESTS_MINITOWER_COPAL, (Supplier<Block>)ModBlocks.copal_bricks, (ImmutableList<Supplier<Block>>)ImmutableList.of(ModBlocks.cracked_copal_bricks, ModBlocks.crusted_copal_bricks), (Supplier<StairsBlock>)ModBlocks.copal_brick_stairs, (ImmutableList<Supplier<StairsBlock>>)ImmutableList.of(ModBlocks.cracked_copal_brick_stairs, ModBlocks.crusted_copal_brick_stairs), (Supplier<SlabBlock>)ModBlocks.copal_brick_slab, (ImmutableList<Supplier<SlabBlock>>)ImmutableList.of(ModBlocks.cracked_copal_brick_slab, ModBlocks.crusted_copal_brick_slab)),
    JADE("JADE", GaiaChestTables.CHESTS_MINITOWER_JADE, (Supplier<Block>)ModBlocks.jade_bricks, (ImmutableList<Supplier<Block>>)ImmutableList.of(ModBlocks.cracked_jade_bricks, ModBlocks.crusted_jade_bricks), (Supplier<StairsBlock>)ModBlocks.jade_brick_stairs, (ImmutableList<Supplier<StairsBlock>>)ImmutableList.of(ModBlocks.cracked_jade_brick_stairs, ModBlocks.crusted_jade_brick_stairs), (Supplier<SlabBlock>)ModBlocks.jade_brick_slab, (ImmutableList<Supplier<SlabBlock>>)ImmutableList.of(ModBlocks.cracked_jade_brick_slab, ModBlocks.crusted_jade_brick_slab)),
    JET("JET", GaiaChestTables.CHESTS_MINITOWER_JET, (Supplier<Block>)ModBlocks.jet_bricks, (ImmutableList<Supplier<Block>>)ImmutableList.of(ModBlocks.cracked_jet_bricks, ModBlocks.crusted_jet_bricks), (Supplier<StairsBlock>)ModBlocks.jet_brick_stairs, (ImmutableList<Supplier<StairsBlock>>)ImmutableList.of(ModBlocks.cracked_jet_brick_stairs, ModBlocks.crusted_jet_brick_stairs), (Supplier<SlabBlock>)ModBlocks.jet_brick_slab, (ImmutableList<Supplier<SlabBlock>>)ImmutableList.of(ModBlocks.cracked_jet_brick_slab, ModBlocks.crusted_jet_brick_slab));

    public static final Codec<MiniTowerType> CODEC;
    private final String name;
    private final ResourceLocation chestLoot;
    private final Supplier<Block> brickBlock;
    private final ImmutableList<Supplier<Block>> brickDegrades;
    private final Supplier<StairsBlock> stairsBlock;
    private final ImmutableList<Supplier<StairsBlock>> stairsDegrades;
    private final Supplier<SlabBlock> slabBlock;
    private final ImmutableList<Supplier<SlabBlock>> slabDegrades;
    private static final Map<String, MiniTowerType> typeid;

    private MiniTowerType(String name, ResourceLocation loot, Supplier<Block> brick, ImmutableList<Supplier<Block>> breakbricks, Supplier<StairsBlock> stairs, ImmutableList<Supplier<StairsBlock>> breakstairs, Supplier<SlabBlock> slab, ImmutableList<Supplier<SlabBlock>> breakslab) {
        this.name = name;
        this.chestLoot = loot;
        this.brickBlock = brick;
        this.brickDegrades = breakbricks;
        this.stairsBlock = stairs;
        this.stairsDegrades = breakstairs;
        this.slabBlock = slab;
        this.slabDegrades = breakslab;
    }

    public static MiniTowerType getType(String name) {
        return typeid.get(name);
    }

    public String func_176610_l() {
        return this.name;
    }

    public ResourceLocation getChestLoot() {
        return this.chestLoot;
    }

    public BlockState getBrick() {
        return this.brickBlock.get().func_176223_P();
    }

    public BlockState getBrickDecay(Random rand) {
        return ((Block)((Supplier)this.brickDegrades.get(rand.nextInt(this.brickDegrades.size()))).get()).func_176223_P();
    }

    public BlockState getStairs() {
        return this.stairsBlock.get().func_176223_P();
    }

    public BlockState getStairsDecay(Random rand) {
        return ((StairsBlock)((Supplier)this.stairsDegrades.get(rand.nextInt(this.stairsDegrades.size()))).get()).func_176223_P();
    }

    public BlockState getSlab() {
        return this.slabBlock.get().func_176223_P();
    }

    public BlockState getSlabDecay(Random rand) {
        return ((SlabBlock)((Supplier)this.slabDegrades.get(rand.nextInt(this.slabDegrades.size()))).get()).func_176223_P();
    }

    static {
        CODEC = IStringSerializable.func_233023_a_(MiniTowerType::values, MiniTowerType::getType);
        typeid = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashmap -> {
            for (MiniTowerType type : MiniTowerType.values()) {
                hashmap.put(type.name, type);
            }
        });
    }
}

