/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.world.GaiaChunkGenerator;
import androsa.gaiadimension.world.layer.GaiaLayerUtil;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;

public class GaiaBiomeProvider
extends BiomeProvider {
    public static final Codec<GaiaBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElse((Object)GaiaChunkGenerator.hackSeed).forGetter(obj -> obj.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(obj -> obj.registry)).apply((Applicative)instance, instance.stable(GaiaBiomeProvider::new)));
    private final long seed;
    private final Registry<Biome> registry;
    private final Layer genBiomes;
    private static final List<RegistryKey<Biome>> biomes = ImmutableList.of(ModBiomes.pink_agate_forest, ModBiomes.blue_agate_taiga, ModBiomes.green_agate_jungle, ModBiomes.purple_agate_swamp, ModBiomes.fossil_woodland, ModBiomes.mutant_agate_wildwood, ModBiomes.volcanic_lands, ModBiomes.static_wasteland, ModBiomes.goldstone_lands, ModBiomes.crystal_plains, ModBiomes.salt_dunes, ModBiomes.shining_grove, (Object[])new RegistryKey[]{ModBiomes.smoldering_bog, ModBiomes.mineral_reservoir, ModBiomes.mineral_river});

    public GaiaBiomeProvider(long seed, Registry<Biome> registry) {
        super(biomes.stream().map(define -> () -> (Biome)registry.func_243576_d(define)));
        this.seed = seed;
        this.registry = registry;
        this.genBiomes = GaiaLayerUtil.makeLayers(seed, registry);
    }

    public BiomeProvider func_230320_a_(long s) {
        return new GaiaBiomeProvider(s, this.registry);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.getBiomeFromPos(this.registry, x, z);
    }

    public Biome getBiomeFromPos(Registry<Biome> registry, int x, int z) {
        int i = this.genBiomes.field_215742_b.func_202678_a(x, z);
        Biome biome = (Biome)registry.func_148745_a(i);
        if (biome == null) {
            if (SharedConstants.field_206244_b) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Unknown biome id: " + i));
            }
            GaiaDimensionMod.LOGGER.warn("Unknown biome id: ", (Object)i);
            return (Biome)registry.func_230516_a_(BiomeRegistry.func_244203_a((int)0));
        }
        return biome;
    }
}

