/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension;

import androsa.gaiadimension.biomes.GDBiomeBase;
import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.registry.GDBlocksRegister;
import androsa.gaiadimension.registry.GDItemsRegister;
import androsa.gaiadimension.registry.ModelRegisterCallback;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="gaiadimension", value={Side.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void registerBlockColors(ColorHandlerEvent.Block e) {
        BlockColors blocks = e.getBlockColors();
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null && worldIn.func_180494_b(pos) instanceof GDBiomeBase ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : 15901620, new Block[]{GDBlocks.glitter_grass, GDBlocks.crystal_growth});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null && worldIn.func_180494_b(pos) instanceof GDBiomeBase ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : 0x606060, new Block[]{GDBlocks.murky_grass});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null && worldIn.func_180494_b(pos) instanceof GDBiomeBase ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : 0xA0A0A0, new Block[]{GDBlocks.soft_grass});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (worldIn != null && pos != null) {
                int red = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177958_n() * 2))) + 1.0f) / 2.0f * 255.0f);
                int green = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177956_o() * 2))) + 1.0f) / 3.0f * 255.0f);
                int blue = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177952_p() * 2))) + 1.0f) / 2.0f * 255.0f);
                red = MathHelper.func_76125_a((int)red, (int)0, (int)170);
                green = MathHelper.func_76125_a((int)green, (int)0, (int)160);
                blue = MathHelper.func_76125_a((int)blue, (int)0, (int)180);
                return blue << 16 | red << 8 | green;
            }
            return 0x808080;
        }, new Block[]{GDBlocks.liquid_bismuth_block});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (worldIn != null && pos != null) {
                int red = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177958_n() + 100) * 8))) + 1.0f) / 2.0f * 255.0f);
                int green = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177956_o() + 100) * 32))) + 1.0f) / 2.0f * 255.0f);
                int blue = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177952_p() + 100) * 8))) + 1.0f) / 2.0f * 255.0f);
                red = MathHelper.func_76125_a((int)red, (int)150, (int)256);
                green = MathHelper.func_76125_a((int)green, (int)100, (int)220);
                blue = MathHelper.func_76125_a((int)blue, (int)150, (int)256);
                return red << 16 | green << 8 | blue;
            }
            return 0xFFFFFF;
        }, new Block[]{GDBlocks.liquid_aura_block, GDBlocks.aura_leaves});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> {
            int hex;
            if (worldIn != null && pos != null) {
                int location = Math.abs(pos.func_177958_n() % 5) + Math.abs(pos.func_177952_p() % 5);
                switch (location) {
                    case 0: {
                        hex = 15355917;
                        break;
                    }
                    case 1: {
                        hex = 16761420;
                        break;
                    }
                    case 2: {
                        hex = 12709158;
                        break;
                    }
                    case 3: {
                        hex = 6815673;
                        break;
                    }
                    case 4: {
                        hex = 2513647;
                        break;
                    }
                    case 5: {
                        hex = 6032087;
                        break;
                    }
                    case 6: {
                        hex = 6109315;
                        break;
                    }
                    case 7: {
                        hex = 12792040;
                        break;
                    }
                    case 8: {
                        hex = 16739502;
                        break;
                    }
                    default: {
                        hex = 6109315;
                        break;
                    }
                }
            } else {
                hex = 1116599;
            }
            return hex;
        }, new Block[]{GDBlocks.aura_shoot});
    }

    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item e) {
        BlockColors blocks = e.getBlockColors();
        ItemColors items = e.getItemColors();
        items.func_186731_a((stack, tintIndex) -> blocks.func_186724_a(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, tintIndex), new Block[]{GDBlocks.glitter_grass, GDBlocks.crystal_growth, GDBlocks.murky_grass, GDBlocks.aura_shoot, GDBlocks.soft_grass});
    }

    @SubscribeEvent
    public static void onModelRegistryReady(ModelRegistryEvent event) {
        for (ModelRegisterCallback b : GDBlocksRegister.getBlockModels()) {
            b.registerModel();
        }
        for (ModelRegisterCallback i : GDItemsRegister.ItemRegistryHelper.getItemModels()) {
            i.registerModel();
        }
    }

    @SubscribeEvent
    public static void textureStitch(TextureStitchEvent.Pre e) {
        TextureMap map = e.getMap();
        map.func_174942_a(new ResourceLocation("gaiadimension", "particle/yellow_fire"));
        map.func_174942_a(new ResourceLocation("gaiadimension", "particle/green_fire"));
        map.func_174942_a(new ResourceLocation("gaiadimension", "particle/portal_sparkle"));
    }
}

