/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension;

import androsa.gaiadimension.proxy.CommonProxy;
import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.registry.GDConfig;
import androsa.gaiadimension.registry.GDFluids;
import androsa.gaiadimension.registry.GDItems;
import androsa.gaiadimension.world.WorldProviderGaia;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gaiadimension", name="GaiaDimension", version="1.0.5", dependencies="required-after:forge@[14.23.5.2768,)", updateJSON="https://raw.githubusercontent.com/Andromander/Gaia-Dimension/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class GaiaDimension {
    public static final String MODID = "gaiadimension";
    public static final String VERSION = "1.0.5";
    public static final String NAME = "Gaia Dimension";
    public static final GDItems items = new GDItems();
    public static final GDBlocks blocks = new GDBlocks();
    public static final GDFluids fluids = new GDFluids();
    public static final String ARMOR_DIR = "gaiadimension:textures/armor/";
    public static final String MODEL_DIR = "gaiadimension:textures/model/";
    public static final ResourceLocation POTION_TEXTURES = new ResourceLocation("gaiadimension", "textures/gui/potions.png");
    public static final Logger LOGGER = LogManager.getLogger((String)"gaiadimension");
    public static DimensionType dimType;
    public static int backupdimensionID;
    public static final EnumCreatureAttribute GAIAN;
    public static final EnumCreatureAttribute CORRUPT;
    public static final DamageSource CORRUPTION;
    @Mod.Instance(value="gaiadimension")
    public static GaiaDimension instance;
    @SidedProxy(clientSide="androsa.gaiadimension.proxy.ClientProxy", serverSide="androsa.gaiadimension.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        dimType = DimensionType.register((String)"Gaia", (String)"_gaia", (int)GDConfig.dimension.dimensionID, WorldProviderGaia.class, (boolean)false);
        LOGGER.info("We are set for the world of Gaia.");
        FluidRegistry.registerFluid((Fluid)GDFluids.mineralWater);
        FluidRegistry.registerFluid((Fluid)GDFluids.superhotMagma);
        FluidRegistry.registerFluid((Fluid)GDFluids.sweetMuck);
        FluidRegistry.registerFluid((Fluid)GDFluids.liquidBismuth);
        FluidRegistry.registerFluid((Fluid)GDFluids.liquidAura);
        FluidRegistry.addBucketForFluid((Fluid)GDFluids.mineralWater);
        FluidRegistry.addBucketForFluid((Fluid)GDFluids.superhotMagma);
        FluidRegistry.addBucketForFluid((Fluid)GDFluids.sweetMuck);
        FluidRegistry.addBucketForFluid((Fluid)GDFluids.liquidBismuth);
        FluidRegistry.addBucketForFluid((Fluid)GDFluids.liquidAura);
        proxy.doPreLoadRegistration();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("Registering GUI Handler...");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!DimensionManager.isDimensionRegistered((int)GDConfig.dimension.dimensionID)) {
            DimensionManager.registerDimension((int)GDConfig.dimension.dimensionID, (DimensionType)dimType);
        } else {
            LOGGER.warn("The ID '{}' chosen in the config log is already in use. Falling back onto backup dimension ID");
            DimensionManager.registerDimension((int)backupdimensionID, (DimensionType)dimType);
            GDConfig.dimension.dimensionID = backupdimensionID;
        }
    }

    static {
        backupdimensionID = -258;
        GAIAN = EnumHelper.addCreatureAttribute((String)"GAIAN");
        CORRUPT = EnumHelper.addCreatureAttribute((String)"CORRUPT");
        CORRUPTION = new DamageSource("corruption").func_76348_h();
        FluidRegistry.enableUniversalBucket();
    }
}

