/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.biomes;

import androsa.gaiadimension.biomes.GDBiomeDecorator;
import androsa.gaiadimension.entity.GDArchaicWarrior;
import androsa.gaiadimension.entity.GDCavernTick;
import androsa.gaiadimension.entity.GDMuckling;
import androsa.gaiadimension.entity.GDNomadicLagrahk;
import androsa.gaiadimension.entity.GDPrimalBeast;
import androsa.gaiadimension.entity.GDShallowArenthis;
import androsa.gaiadimension.entity.GDShalurker;
import androsa.gaiadimension.registry.EnumSkyColors;
import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.world.GaiaWorld;
import androsa.gaiadimension.world.gen.GDGenCrystalPlants;
import androsa.gaiadimension.world.gen.GDGenNoTrees;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GDBiomeBase
extends Biome {
    public GDBiomeDecorator biomeDecorator;
    public EnumSkyColors skyColor = EnumSkyColors.GENERAL;

    public GDBiomeBase(Biome.BiomeProperties props) {
        super(props);
        this.biomeDecorator = this.getBiomeDecorator();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(GDCavernTick.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(GDShalurker.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(GDArchaicWarrior.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(GDMuckling.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEnderman.class, 5, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(GDPrimalBeast.class, 25, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(GDNomadicLagrahk.class, 15, 1, 2));
        this.field_76755_L.add(new Biome.SpawnListEntry(GDShallowArenthis.class, 10, 4, 4));
        this.biomeDecorator.treesPerChunk = 5;
        this.biomeDecorator.grassPerChunk = 3;
        this.biomeDecorator.flowersPerChunk = 2;
        this.biomeDecorator.fungiPerChunk = 1;
        this.flowers.clear();
        this.flowers.add(new Biome.FlowerEntry(GDBlocks.thiscus.func_176223_P(), 20));
        this.flowers.add(new Biome.FlowerEntry(GDBlocks.ouzium.func_176223_P(), 10));
        this.field_76752_A = GDBlocks.glitter_grass.func_176223_P();
        this.field_76753_B = GDBlocks.heavy_soil.func_176223_P();
    }

    public GDBiomeDecorator getBiomeDecorator() {
        return new GDBiomeDecorator();
    }

    @SideOnly(value=Side.CLIENT)
    public final short[] getSkyRGB() {
        return this.skyColor.getSkyColor();
    }

    @SideOnly(value=Side.CLIENT)
    public final short[] getFogRGB() {
        return this.skyColor.getFogColor();
    }

    public float func_76741_f() {
        return 0.12f;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        this.biomeDecorator.decorate(worldIn, rand, this, pos);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return new GDGenNoTrees();
    }

    public WorldGenerator func_76730_b(Random rand) {
        return new GDGenCrystalPlants(GDBlocks.crystal_growth);
    }

    public WorldGenerator getRandomFungus(Random rand) {
        return new GDGenCrystalPlants(GDBlocks.spotted_kersei);
    }

    public WorldGenerator getRandomBloom(Random rand) {
        if (rand.nextInt(4) == 0) {
            return new GDGenCrystalPlants(GDBlocks.ouzium);
        }
        return new GDGenCrystalPlants(GDBlocks.thiscus);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 15901620;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 15901620;
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noiseVal) {
        this.genGaiaBiomeTerrain(world, rand, primer, x, z, noiseVal);
    }

    public final void genGaiaBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int seaLevel = GaiaWorld.SEALEVEL;
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        IBlockState stone = this.getStoneReplacement();
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int posZ = x & 0xF;
        int posX = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int posY = 255; posY >= 0; --posY) {
            if (posY <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(posX, posY, posZ, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(posX, posY, posZ);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != GDBlocks.gaia_stone) continue;
            if (stone != null && posY > seaLevel + 10) {
                chunkPrimerIn.func_177855_a(posX, posY, posZ, stone);
            }
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = GDBlocks.gaia_stone.func_176223_P();
                } else if (posY >= seaLevel - 4 && posY <= seaLevel + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (posY < seaLevel && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, posY, z)) < 0.15f ? field_185371_g : GDBlocks.mineral_water_block.func_176223_P();
                }
                j = k;
                if (posY >= seaLevel - 1) {
                    chunkPrimerIn.func_177855_a(posX, posY, posZ, iblockstate);
                    continue;
                }
                if (posY < seaLevel - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = GDBlocks.gaia_stone.func_176223_P();
                    chunkPrimerIn.func_177855_a(posX, posY, posZ, GDBlocks.salt.func_176223_P());
                    continue;
                }
                chunkPrimerIn.func_177855_a(posX, posY, posZ, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(posX, posY, posZ, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != GDBlocks.salt || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, posY - 63);
            iblockstate1 = GDBlocks.saltstone.func_176223_P();
        }
    }

    @Nullable
    public IBlockState getStoneReplacement() {
        return null;
    }
}

