/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.biomes;

import androsa.gaiadimension.biomes.GDBiomeBase;
import androsa.gaiadimension.biomes.GDMutantAgateWildwood;
import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.world.gen.GDGenAuraPond;
import androsa.gaiadimension.world.gen.GDGenBismuthBog;
import androsa.gaiadimension.world.gen.GDGenCrystalFungi;
import androsa.gaiadimension.world.gen.GDGenLavaLake;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class GDBiomeDecorator {
    private GDGenLavaLake extraLavaPoolGen = new GDGenLavaLake(GDBlocks.superhot_magma_block);
    private GDGenLavaLake extraMuckPoolGen = new GDGenLavaLake(GDBlocks.sweet_muck_block);
    private GDGenBismuthBog extraBismuthBogGen = new GDGenBismuthBog();
    private GDGenAuraPond extraAuraPondGen = new GDGenAuraPond();
    public WorldGenerator goldorbShroomGen = new GDGenCrystalFungi(GDBlocks.gold_orb_tucher);
    public WorldGenerator elderShroomGen = new GDGenCrystalFungi(GDBlocks.elder_imklia);
    public World world;
    public Random rand;
    public BlockPos chunkPos;
    public ChunkGeneratorSettings chunkProviderSettings;
    public GDBiomeBase gaiaBiome;
    public int lakesPerChunk;
    public int fungiPerChunk;
    public int flowersPerChunk;
    public int treesPerChunk = 0;
    public int grassPerChunk = 0;
    public float lavaPoolChance = 0.0f;
    public float muckPoolChance;
    public float bismuthBogChance;
    public float auraPondChance;

    public void decorate(World world, Random rand, Biome biome, BlockPos pos) {
        BlockPos blockpos1;
        int z;
        int x;
        int i;
        this.chunkProviderSettings = ChunkGeneratorSettings.Factory.func_177865_a((String)world.func_72912_H().func_82571_y()).func_177864_b();
        this.chunkPos = pos;
        this.gaiaBiome = (GDBiomeBase)biome;
        this.genLakes(world, rand);
        for (i = 0; i < this.treesPerChunk; ++i) {
            int k6 = rand.nextInt(16) + 8;
            int l = rand.nextInt(16) + 8;
            WorldGenAbstractTree worldgenabstracttree = biome.func_150567_a(rand);
            worldgenabstracttree.func_175904_e();
            BlockPos blockpos = world.func_175645_m(this.chunkPos.func_177982_a(k6, 0, l));
            if (!worldgenabstracttree.func_180709_b(world, rand, blockpos)) continue;
            worldgenabstracttree.func_180711_a(world, rand, blockpos);
        }
        for (i = 0; i < this.grassPerChunk; ++i) {
            x = rand.nextInt(16) + 8;
            int height = world.func_175645_m(this.chunkPos.func_177982_a(x, 0, z = rand.nextInt(16) + 8)).func_177956_o() * 2;
            if (height <= 0) continue;
            int y = rand.nextInt(height);
            biome.func_76730_b(rand).func_180709_b(world, rand, this.chunkPos.func_177982_a(x, y, z));
        }
        for (i = 0; i < this.fungiPerChunk; ++i) {
            int height;
            if (rand.nextInt(8) != 0 || (height = world.func_175645_m(this.chunkPos.func_177982_a(x = rand.nextInt(16) + 8, 0, z = rand.nextInt(16) + 8)).func_177956_o() + 32) <= 0) continue;
            int y = rand.nextInt(height);
            blockpos1 = this.chunkPos.func_177982_a(x, y, z);
            this.gaiaBiome.getRandomFungus(rand).func_180709_b(world, rand, blockpos1);
        }
        for (i = 0; i < this.flowersPerChunk; ++i) {
            int height;
            if (rand.nextInt(4) != 0 || (height = world.func_175645_m(this.chunkPos.func_177982_a(x = rand.nextInt(16) + 8, 0, z = rand.nextInt(16) + 8)).func_177956_o() + 32) <= 0) continue;
            int y = rand.nextInt(height);
            blockpos1 = this.chunkPos.func_177982_a(x, y, z);
            this.gaiaBiome.getRandomBloom(rand).func_180709_b(world, rand, blockpos1);
        }
        this.decorateUnderground(world, rand, pos);
    }

    protected void genLakes(World world, Random randomGenerator) {
        int rz;
        int rx;
        if (randomGenerator.nextFloat() <= this.lavaPoolChance) {
            rx = this.chunkPos.func_177958_n() + randomGenerator.nextInt(16) + 8;
            rz = this.chunkPos.func_177952_p() + randomGenerator.nextInt(16) + 8;
            this.extraLavaPoolGen.func_180709_b(world, randomGenerator, world.func_175645_m(new BlockPos(rx, 0, rz)));
        }
        if (randomGenerator.nextFloat() <= this.muckPoolChance) {
            rx = this.chunkPos.func_177958_n() + randomGenerator.nextInt(16) + 8;
            rz = this.chunkPos.func_177952_p() + randomGenerator.nextInt(16) + 8;
            this.extraMuckPoolGen.func_180709_b(world, randomGenerator, world.func_175645_m(new BlockPos(rx, 0, rz)));
        }
        if (randomGenerator.nextFloat() <= this.bismuthBogChance) {
            rx = this.chunkPos.func_177958_n() + randomGenerator.nextInt(16) + 8;
            rz = this.chunkPos.func_177952_p() + randomGenerator.nextInt(16) + 8;
            this.extraBismuthBogGen.func_180709_b(world, randomGenerator, world.func_175645_m(new BlockPos(rx, 0, rz)));
        }
        if (randomGenerator.nextFloat() <= this.auraPondChance) {
            rx = this.chunkPos.func_177958_n() + randomGenerator.nextInt(16) + 8;
            rz = this.chunkPos.func_177952_p() + randomGenerator.nextInt(16) + 8;
            this.extraAuraPondGen.func_180709_b(world, randomGenerator, world.func_175645_m(new BlockPos(rx, 0, rz)));
        }
    }

    protected void decorateUnderground(World world, Random rand, BlockPos pos) {
        int Ycoord;
        int Zcoord;
        int Xcoord;
        int i;
        for (i = 0; i < 5; ++i) {
            BlockPos blockpos1;
            int y;
            int x = rand.nextInt(16) + 8;
            int z = rand.nextInt(16) + 8;
            int height = world.func_175645_m(this.chunkPos.func_177982_a(x, 0, z)).func_177956_o() * 2;
            if (rand.nextInt(4) == 0) {
                if (height <= 0) continue;
                y = rand.nextInt(height);
                blockpos1 = this.chunkPos.func_177982_a(x, y, z);
                this.elderShroomGen.func_180709_b(world, rand, blockpos1);
                continue;
            }
            if (height <= 0) continue;
            y = rand.nextInt(height);
            blockpos1 = this.chunkPos.func_177982_a(x, y, z);
            this.goldorbShroomGen.func_180709_b(world, rand, blockpos1);
        }
        for (i = 0; i < 25; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(120);
            new WorldGenMinable(GDBlocks.pebbles.func_176223_P(), 25, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 10; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(120);
            new WorldGenMinable(GDBlocks.speckled_rock.func_176223_P(), this.chunkProviderSettings.field_177814_as, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 10; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(60);
            new WorldGenMinable(GDBlocks.coarse_rock.func_176223_P(), this.chunkProviderSettings.field_177814_as, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 10; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(30);
            new WorldGenMinable(GDBlocks.precious_rock.func_176223_P(), this.chunkProviderSettings.field_177814_as, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 8; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(100);
            new WorldGenMinable(GDBlocks.sugilite_ore.func_176223_P(), this.chunkProviderSettings.field_177844_ac, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 8; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(100);
            new WorldGenMinable(GDBlocks.hematite_ore.func_176223_P(), this.chunkProviderSettings.field_177844_ac, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 8; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(80);
            new WorldGenMinable(GDBlocks.pyrite_ore.func_176223_P(), this.chunkProviderSettings.field_177848_ag, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 7; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(60);
            new WorldGenMinable(GDBlocks.cinnabar_ore.func_176223_P(), this.chunkProviderSettings.field_177848_ag, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 6; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(40);
            new WorldGenMinable(GDBlocks.labradorite_ore.func_176223_P(), this.chunkProviderSettings.field_177828_ak, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        for (i = 0; i < 6; ++i) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = rand.nextInt(40);
            new WorldGenMinable(GDBlocks.moonstone_ore.func_176223_P(), this.chunkProviderSettings.field_177828_ak, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
        if (world.func_180494_b(pos) instanceof GDMutantAgateWildwood) {
            for (i = 0; i < 4; ++i) {
                Xcoord = pos.func_177958_n() + rand.nextInt(16);
                Zcoord = pos.func_177952_p() + rand.nextInt(16);
                Ycoord = rand.nextInt(20);
                new WorldGenMinable(GDBlocks.opal_ore_white.func_176223_P(), this.chunkProviderSettings.field_177814_as, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
            }
        } else {
            for (i = 0; i < 3; ++i) {
                Xcoord = pos.func_177958_n() + rand.nextInt(16);
                Zcoord = pos.func_177952_p() + rand.nextInt(16);
                Ycoord = rand.nextInt(25);
                new WorldGenMinable(GDBlocks.opal_ore_white.func_176223_P(), this.chunkProviderSettings.field_177814_as, input -> input == GDBlocks.gaia_stone.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
            }
        }
    }
}

