/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.biomes;

import androsa.gaiadimension.biomes.GDBiomeBase;
import androsa.gaiadimension.biomes.IDangerousBiome;
import androsa.gaiadimension.entity.GDLesserSpitfire;
import androsa.gaiadimension.registry.EnumSkyColors;
import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.world.gen.GDGenBurntAgateTree;
import androsa.gaiadimension.world.gen.GDGenCrystalPlants;
import androsa.gaiadimension.world.gen.GDGenFieryAgateTree;
import androsa.gaiadimension.world.gen.GDGenNoTrees;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GDVolcanicLands
extends GDBiomeBase
implements IDangerousBiome {
    private WorldGenAbstractTree GaiaGenBurntTrees = new GDGenBurntAgateTree(false);
    private WorldGenAbstractTree GaiaGenFireTrees = new GDGenFieryAgateTree(false);

    public GDVolcanicLands(Biome.BiomeProperties props) {
        super(props);
        this.field_76762_K.add(new Biome.SpawnListEntry(GDLesserSpitfire.class, 10, 2, 4));
        this.flowers.clear();
        this.skyColor = EnumSkyColors.VOLCANICLAND;
        this.biomeDecorator.lavaPoolChance = 0.25f;
        this.biomeDecorator.grassPerChunk = 1;
        this.biomeDecorator.flowersPerChunk = -1;
        this.biomeDecorator.fungiPerChunk = -1;
    }

    @Override
    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        for (int i = 0; i < 20; ++i) {
            int Xcoord = pos.func_177958_n() + rand.nextInt(16);
            int Zcoord = pos.func_177952_p() + rand.nextInt(16);
            int Ycoord = rand.nextInt(100);
            new WorldGenMinable(GDBlocks.searing_rock.func_176223_P(), 33, input -> input == GDBlocks.volcanic_rock.func_176223_P()).func_180709_b(world, rand, new BlockPos(Xcoord, Ycoord, Zcoord));
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random par1Random) {
        if (par1Random.nextInt(16) == 0) {
            if (par1Random.nextInt(5) == 0) {
                return this.GaiaGenFireTrees;
            }
            return this.GaiaGenBurntTrees;
        }
        return new GDGenNoTrees();
    }

    @Override
    public WorldGenerator func_76730_b(Random rand) {
        return new GDGenCrystalPlants(GDBlocks.crystal_growth_seared);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 0x232323;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 0x232323;
    }

    @Override
    public IBlockState getStoneReplacement() {
        return GDBlocks.volcanic_rock.func_176223_P();
    }
}

