/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.block.GDBlock;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GDGaiaGrass
extends GDBlock
implements IGrowable {
    private final Supplier<Block> grassSupplier;
    private final Supplier<Block> dirtSupplier;

    public GDGaiaGrass(Supplier<Block> grass, Supplier<Block> dirt) {
        super(Material.field_151577_b, SoundType.field_185850_c, "shovel", 0);
        this.func_149711_c(0.9f);
        this.func_149675_a(true);
        this.grassSupplier = grass;
        this.dirtSupplier = dirt;
    }

    public GDGaiaGrass(MapColor color, Supplier<Block> grass, Supplier<Block> dirt) {
        super(Material.field_151577_b, color, SoundType.field_185850_c, "shovel", 0);
        this.func_149711_c(0.9f);
        this.func_149675_a(true);
        this.grassSupplier = grass;
        this.dirtSupplier = dirt;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (world.func_175671_l(pos.func_177984_a()) < 4 && world.func_180495_p(pos.func_177984_a()).func_177230_c().getLightOpacity(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos.func_177984_a()) > 2) {
                world.func_175656_a(pos, this.dirtSupplier.get().func_176223_P());
            } else if (world.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    Block block = world.func_180495_p(blockpos.func_177984_a()).func_177230_c();
                    IBlockState iblockstate = world.func_180495_p(blockpos);
                    if (iblockstate.func_177230_c() != this.dirtSupplier.get() || world.func_175671_l(blockpos.func_177984_a()) < 4 || block.getLightOpacity(world.func_180495_p(blockpos.func_177984_a()), (IBlockAccess)world, blockpos.func_177984_a()) > 2) continue;
                    world.func_175656_a(blockpos, this.grassSupplier.get().func_176223_P());
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int j) {
        return this.dirtSupplier.get().func_180660_a(this.dirtSupplier.get().func_176223_P(), random, j);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        return plantable.getPlantType(world, pos.func_177972_a(direction)) == EnumPlantType.Plains || plantable.getPlantType(world, pos.func_177972_a(direction)) == EnumPlantType.Beach && hasWater;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }
}

