/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.GaiaDimension;
import androsa.gaiadimension.registry.EnumParticlesGD;
import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.registry.GDConfig;
import androsa.gaiadimension.registry.ModelRegisterCallback;
import androsa.gaiadimension.world.TeleporterGaia;
import java.util.Random;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
public class GDGaiaPortal
extends BlockPortal
implements ModelRegisterCallback {
    public GDGaiaPortal() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176550_a, (Comparable)EnumFacing.Axis.X));
        this.func_149675_a(true);
        this.func_149715_a(1.0f);
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return 1;
        }
        return axis == EnumFacing.Axis.Z ? 2 : 0;
    }

    public boolean tryToCreatePortal(World worldIn, BlockPos pos) {
        Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X);
        if (blockportal$size.isValid() && blockportal$size.portalBlockCount == 0 && this.canCreatePortalByWorld(worldIn, pos)) {
            blockportal$size.placePortalBlocks();
            return true;
        }
        Size blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z);
        if (blockportal$size1.isValid() && blockportal$size1.portalBlockCount == 0 && this.canCreatePortalByWorld(worldIn, pos)) {
            blockportal$size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (world.field_73011_w.getDimension() == 0) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY);
        }
        return world.field_73011_w.getDimension() == GDConfig.dimension.dimensionID;
    }

    public void func_189540_a(IBlockState state, @Nullable World worldIn, @Nullable BlockPos pos, Block blockIn, BlockPos fromPos) {
        Size blockportal$size1;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X);
            if (!blockportal$size.isValid() || blockportal$size.portalBlockCount < blockportal$size.width * blockportal$size.height) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(enumfacing$axis != EnumFacing.Axis.Z || (blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z)).isValid() && blockportal$size1.portalBlockCount >= blockportal$size1.width * blockportal$size1.height)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        EnumFacing.Axis enumfacing$axis = null;
        if (this.field_176227_L.func_177622_c() == this) {
            enumfacing$axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
            if (enumfacing$axis == null) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.Z && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.X && side != EnumFacing.SOUTH && side != EnumFacing.NORTH) {
                return false;
            }
        }
        boolean flag = access.func_180495_p(pos.func_177976_e()).func_177230_c() == this && access.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean flag1 = access.func_180495_p(pos.func_177974_f()).func_177230_c() == this && access.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean flag2 = access.func_180495_p(pos.func_177978_c()).func_177230_c() == this && access.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean flag3 = access.func_180495_p(pos.func_177968_d()).func_177230_c() == this && access.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean flag4 = flag || flag1 || enumfacing$axis == EnumFacing.Axis.X;
        boolean flag5 = flag2 || flag3 || enumfacing$axis == EnumFacing.Axis.Z;
        return flag4 && side == EnumFacing.WEST || flag4 && side == EnumFacing.EAST || flag5 && side == EnumFacing.NORTH || flag5 && side == EnumFacing.SOUTH;
    }

    public void func_180634_a(World worldIn, @Nullable BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn.func_184218_aH() || entityIn.func_184207_aI() || worldIn.field_72995_K)) {
            if (entityIn.field_71088_bW <= 0) {
                if (entityIn instanceof EntityPlayerMP) {
                    EntityPlayerMP thePlayer = (EntityPlayerMP)entityIn;
                    thePlayer.field_71088_bW = entityIn.func_82147_ab();
                    if (thePlayer.field_71093_bK != GDConfig.dimension.dimensionID) {
                        if (!ForgeHooks.onTravelToDimension((Entity)thePlayer, (int)GDConfig.dimension.dimensionID)) {
                            return;
                        }
                        thePlayer.field_71133_b.func_184103_al().transferPlayerToDimension(thePlayer, GDConfig.dimension.dimensionID, (Teleporter)new TeleporterGaia(thePlayer.field_71133_b.func_71218_a(GDConfig.dimension.dimensionID), (Block)this, GDBlocks.keystone_block.func_176223_P()));
                    } else {
                        if (!ForgeHooks.onTravelToDimension((Entity)thePlayer, (int)0)) {
                            return;
                        }
                        thePlayer.field_71133_b.func_184103_al().transferPlayerToDimension(thePlayer, 0, (Teleporter)new TeleporterGaia(thePlayer.field_71133_b.func_71218_a(0), (Block)this, GDBlocks.keystone_block.func_176223_P()));
                    }
                } else {
                    MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                    entityIn.field_71088_bW = entityIn.func_82147_ab();
                    if (entityIn.field_71093_bK != GDConfig.dimension.dimensionID) {
                        if (!ForgeHooks.onTravelToDimension((Entity)entityIn, (int)GDConfig.dimension.dimensionID)) {
                            return;
                        }
                        int i = entityIn.field_71093_bK;
                        entityIn.field_71093_bK = GDConfig.dimension.dimensionID;
                        worldIn.func_72973_f(entityIn);
                        entityIn.field_70128_L = false;
                        server.func_184103_al().transferEntityToWorld(entityIn, i, server.func_71218_a(i), server.func_71218_a(GDConfig.dimension.dimensionID), (Teleporter)new TeleporterGaia(server.func_71218_a(GDConfig.dimension.dimensionID), (Block)this, GDBlocks.keystone_block.func_176223_P()));
                    } else {
                        if (!ForgeHooks.onTravelToDimension((Entity)entityIn, (int)0)) {
                            return;
                        }
                        entityIn.field_71093_bK = 0;
                        worldIn.func_72973_f(entityIn);
                        entityIn.field_70128_L = false;
                        server.func_184103_al().transferEntityToWorld(entityIn, GDConfig.dimension.dimensionID, server.func_71218_a(GDConfig.dimension.dimensionID), server.func_71218_a(0), (Teleporter)new TeleporterGaia(server.func_71218_a(0), (Block)this, GDBlocks.keystone_block.func_176223_P()));
                    }
                }
            } else {
                entityIn.field_71088_bW = entityIn.func_82147_ab();
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176550_a, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, @Nullable World worldIn, @Nullable BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            GaiaDimension.proxy.spawnParticle(EnumParticlesGD.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }

    public int func_176201_c(IBlockState state) {
        return GDGaiaPortal.getMetaForAxis((EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176550_a});
    }

    public static class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount = 0;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(World worldIn, BlockPos pos, EnumFacing.Axis facing) {
            this.world = worldIn;
            this.axis = facing;
            if (facing == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        int getDistanceUntilEdge(BlockPos pos, EnumFacing facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i)).func_177230_c()) && this.world.func_180495_p(blockpos.func_177977_b()) == GDBlocks.keystone_block.func_176223_P(); ++i) {
            }
            IBlockState block = this.world.func_180495_p(pos.func_177967_a(facing, i));
            return block == GDBlocks.keystone_block.func_176223_P() ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    IBlockState block = this.world.func_180495_p(blockpos);
                    if (!this.isEmptyBlock(block.func_177230_c())) break block0;
                    if (block.func_177230_c() == GDBlocks.gaia_portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir))) != GDBlocks.keystone_block.func_176223_P() : i == this.width && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir))) != GDBlocks.keystone_block.func_176223_P()) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)) == GDBlocks.keystone_block.func_176223_P()) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        boolean isEmptyBlock(Block blockIn) {
            IBlockState state = blockIn.func_176223_P();
            return state.func_185904_a() == Material.field_151579_a || blockIn == GDBlocks.gold_fire || blockIn == GDBlocks.gaia_portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), GDBlocks.gaia_portal.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                }
            }
        }
    }
}

