/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.tileentity;

import androsa.gaiadimension.block.GDGaiaStoneFurnace;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntityGaiaStoneFurnace
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int furnaceTimer;
    public int currentItemSmeltTime;
    public int cookTime;
    private String name;
    private IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.furnaceItemStacks.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.name : "container.gaiadimension.gaia_stone_furnace";
    }

    public boolean func_145818_k_() {
        return this.name != null && this.name.length() > 0;
    }

    public void setCustomInventoryName(String invName) {
        this.name = invName;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.furnaceItemStacks);
        this.furnaceTimer = compound.func_74765_d("furnaceTimer");
        this.cookTime = compound.func_74765_d("CookTime");
        this.currentItemSmeltTime = TileEntityGaiaStoneFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.name = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1) {
        super.func_189515_b(par1);
        par1.func_74777_a("furnaceTimer", (short)this.furnaceTimer);
        par1.func_74777_a("CookTime", (short)this.cookTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1, this.furnaceItemStacks);
        if (this.func_145818_k_()) {
            par1.func_74778_a("CustomName", this.name);
        }
        return par1;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSmeltProgressScaled(int par1) {
        return this.cookTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSmeltTimeRemainingScaled(int par1) {
        if (this.currentItemSmeltTime == 0) {
            this.currentItemSmeltTime = 200;
        }
        return this.furnaceTimer * par1 / this.currentItemSmeltTime;
    }

    public boolean isBurning() {
        return this.furnaceTimer > 0;
    }

    public void func_73660_a() {
        boolean flag = this.furnaceTimer > 0;
        boolean flag1 = false;
        if (this.furnaceTimer > 0) {
            --this.furnaceTimer;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceTimer == 0 && this.canSmelt()) {
                this.currentItemSmeltTime = this.furnaceTimer = TileEntityGaiaStoneFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
                if (this.furnaceTimer > 0) {
                    flag1 = true;
                    if (!((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                        Item item = ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b();
                        ((ItemStack)this.furnaceItemStacks.get(1)).func_190918_g(1);
                        if (((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                            this.furnaceItemStacks.set(1, (Object)item.getContainerItem((ItemStack)this.furnaceItemStacks.get(1)));
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.cookTime;
                if (this.cookTime == 200) {
                    this.cookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (flag != this.furnaceTimer > 0) {
                flag1 = true;
                GDGaiaStoneFurnace.setState(this.furnaceTimer > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.furnaceItemStacks.get(2);
        return itemstack1.func_190926_b() || itemstack1.func_77969_a(itemstack) && (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d() || itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d());
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = (ItemStack)this.furnaceItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityGaiaStoneFurnace.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int par1, ItemStack stack) {
        return par1 != 2 && (par1 != 1 || TileEntityGaiaStoneFurnace.isItemFuel(stack));
    }

    public int[] func_180463_a(EnumFacing face) {
        return face == EnumFacing.DOWN ? slotsBottom : (face == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int par1, ItemStack stack, EnumFacing face) {
        return this.func_94041_b(par1, stack);
    }

    public boolean func_180461_b(int par1, ItemStack par2ItemStack, EnumFacing face) {
        if (face == EnumFacing.DOWN && par1 == 1) {
            Item item = par2ItemStack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

