/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.tileentity;

import androsa.gaiadimension.block.GDPurifier;
import androsa.gaiadimension.recipe.PurifierRecipes;
import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.registry.GDItems;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntityPurifier
extends TileEntity
implements ISidedInventory,
ITickable {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{4, 1, 2, 3, 5};
    private static final int[] slotsSides = new int[]{1, 2, 3};
    private NonNullList<ItemStack> purifyingItemStacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    public int purifyingTime;
    public int currentPurifyingTime;
    public int clearTime;
    public int totalClearTime;
    private String name;
    private IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.purifyingItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.purifyingItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.purifyingItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.purifyingItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.purifyingItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.purifyingItemStacks.get(index);
        boolean burning = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.purifyingItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !burning) {
            this.totalClearTime = 200;
            this.clearTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.name : "container.gaiadimension.purifier";
    }

    public boolean func_145818_k_() {
        return this.name != null && !this.name.isEmpty();
    }

    public void setCustomInventoryName(String name) {
        this.name = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.purifyingItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.purifyingItemStacks);
        this.purifyingTime = compound.func_74762_e("BurnTime");
        this.clearTime = compound.func_74762_e("CookTime");
        this.totalClearTime = compound.func_74762_e("CookTimeTotal");
        this.currentPurifyingTime = TileEntityPurifier.getItemBurnTime((ItemStack)this.purifyingItemStacks.get(1), (ItemStack)this.purifyingItemStacks.get(2), (ItemStack)this.purifyingItemStacks.get(3));
        if (compound.func_150297_b("CustomName", 8)) {
            this.name = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.purifyingTime));
        compound.func_74768_a("CookTime", (int)((short)this.clearTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalClearTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.purifyingItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.name);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClearProgressScaled(int par1) {
        return this.clearTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClearTimeRemainingScaled(int par1) {
        if (this.currentPurifyingTime == 0) {
            this.currentPurifyingTime = 200;
        }
        return this.purifyingTime * par1 / this.currentPurifyingTime;
    }

    public boolean isBurning() {
        return this.purifyingTime > 0;
    }

    public void func_73660_a() {
        boolean burning = this.isBurning();
        boolean burn = false;
        if (this.isBurning()) {
            --this.purifyingTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack goldStack = (ItemStack)this.purifyingItemStacks.get(1);
            ItemStack essenceStack = (ItemStack)this.purifyingItemStacks.get(2);
            ItemStack bismuthStack = (ItemStack)this.purifyingItemStacks.get(3);
            if (this.isBurning() || !goldStack.func_190926_b() && !essenceStack.func_190926_b() && !bismuthStack.func_190926_b() && !((ItemStack)this.purifyingItemStacks.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canChange()) {
                    this.currentPurifyingTime = this.purifyingTime = TileEntityPurifier.getItemBurnTime(goldStack, essenceStack, bismuthStack);
                    if (this.isBurning()) {
                        ItemStack item1;
                        Item item;
                        burn = true;
                        if (!goldStack.func_190926_b()) {
                            item = goldStack.func_77973_b();
                            goldStack.func_190918_g(1);
                            if (goldStack.func_190926_b()) {
                                item1 = item.getContainerItem(goldStack);
                                this.purifyingItemStacks.set(1, (Object)item1);
                            }
                        }
                        if (!essenceStack.func_190926_b()) {
                            item = essenceStack.func_77973_b();
                            essenceStack.func_190918_g(1);
                            if (essenceStack.func_190926_b()) {
                                item1 = item.getContainerItem(essenceStack);
                                this.purifyingItemStacks.set(2, (Object)item1);
                            }
                        }
                        if (!bismuthStack.func_190926_b()) {
                            item = bismuthStack.func_77973_b();
                            bismuthStack.func_190918_g(1);
                            if (bismuthStack.func_190926_b()) {
                                item1 = item.getContainerItem(bismuthStack);
                                this.purifyingItemStacks.set(3, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canChange()) {
                    ++this.clearTime;
                    if (this.clearTime == this.totalClearTime) {
                        this.clearTime = 0;
                        this.totalClearTime = 200;
                        this.changeItem();
                        burn = true;
                    }
                } else {
                    this.clearTime = 0;
                }
            } else if (!this.isBurning() && this.clearTime > 0) {
                this.clearTime = MathHelper.func_76125_a((int)(this.clearTime - 2), (int)0, (int)this.totalClearTime);
            }
            if (burning != this.isBurning()) {
                burn = true;
                GDPurifier.updatePurifyBlockState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (burn) {
            this.func_70296_d();
        }
    }

    private boolean canChange() {
        if (((ItemStack)this.purifyingItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack[] itemstack = PurifierRecipes.instance().getPurifyingResult((ItemStack)this.purifyingItemStacks.get(0));
        ItemStack output = (ItemStack)this.purifyingItemStacks.get(4);
        ItemStack byproduct = (ItemStack)this.purifyingItemStacks.get(5);
        if (itemstack[0].func_190926_b() && itemstack[1].func_190926_b() || itemstack[0].func_190926_b()) {
            return false;
        }
        if (output.func_190926_b() && byproduct.func_190926_b()) {
            return true;
        }
        if (itemstack[1].func_190926_b()) {
            if (output.func_190926_b()) {
                return true;
            }
            if (!output.func_77969_a(itemstack[0])) {
                return false;
            }
            int result = output.func_190916_E() + itemstack[0].func_190916_E();
            return result <= this.func_70297_j_() && result <= output.func_77976_d();
        }
        if (output.func_190926_b() && byproduct.func_190926_b()) {
            return true;
        }
        if (!output.func_190926_b() && !output.func_77969_a(itemstack[0])) {
            return false;
        }
        if (!byproduct.func_190926_b() && !byproduct.func_77969_a(itemstack[1])) {
            return false;
        }
        int result = output.func_190916_E() + itemstack[0].func_190916_E();
        int result2 = byproduct.func_190916_E() + itemstack[1].func_190916_E();
        return result <= this.func_70297_j_() && result2 <= this.func_70297_j_() && result <= output.func_77976_d() && result2 <= byproduct.func_77976_d();
    }

    public void changeItem() {
        if (this.canChange()) {
            ItemStack[] itemstack = PurifierRecipes.instance().getPurifyingResult((ItemStack)this.purifyingItemStacks.get(0));
            if (((ItemStack)this.purifyingItemStacks.get(4)).func_190926_b()) {
                this.purifyingItemStacks.set(4, (Object)itemstack[0].func_77946_l());
            } else if (((ItemStack)this.purifyingItemStacks.get(4)).func_77973_b() == itemstack[0].func_77973_b()) {
                ((ItemStack)this.purifyingItemStacks.get(4)).func_190917_f(itemstack[0].func_190916_E());
            }
            if (!itemstack[1].func_190926_b()) {
                if (((ItemStack)this.purifyingItemStacks.get(5)).func_190926_b()) {
                    this.purifyingItemStacks.set(5, (Object)itemstack[1].func_77946_l());
                } else if (((ItemStack)this.purifyingItemStacks.get(5)).func_77973_b() == itemstack[1].func_77973_b()) {
                    ((ItemStack)this.purifyingItemStacks.get(5)).func_190917_f(itemstack[1].func_190916_E());
                }
            }
            ((ItemStack)this.purifyingItemStacks.get(0)).func_190918_g(1);
            if (((ItemStack)this.purifyingItemStacks.get(0)).func_190916_E() <= 0) {
                this.purifyingItemStacks.set(0, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static int getItemBurnTime(ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        return (TileEntityPurifier.getFuelBurnTime(stack1) + TileEntityPurifier.getSecondFuelBurnTime(stack2) + TileEntityPurifier.getThirdFuelBurnTime(stack3)) / 3;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityPurifier.getFuelBurnTime(stack) > 0 || TileEntityPurifier.getSecondFuelBurnTime(stack) > 0 || TileEntityPurifier.getThirdFuelBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 4 && index != 5 && (index == 0 || TileEntityPurifier.isItemFuel(stack));
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return slotsBottom;
        }
        return side == EnumFacing.UP ? slotsTop : slotsSides;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 1 || index == 2 || index == 3) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.purifyingItemStacks.clear();
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public static int getFuelBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151074_bl) {
            return 20;
        }
        if (item == Items.field_151043_k) {
            return 200;
        }
        if (item == Items.field_151006_E || item == Items.field_151013_M || item == Items.field_151005_D || item == Items.field_151011_C || item == Items.field_151010_B) {
            return 150;
        }
        if (item == Items.field_151169_ag || item == Items.field_151171_ah || item == Items.field_151149_ai || item == Items.field_151151_aj) {
            return 500;
        }
        if (item == Items.field_151136_bY) {
            return 1000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150340_R)) {
            return 2000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150352_o)) {
            return 150;
        }
        if (item == GDItems.pyrite) {
            return 500;
        }
        if (item == Item.func_150898_a((Block)GDBlocks.pyrite_block)) {
            return 5000;
        }
        if (item == GDItems.sweet_muckball) {
            return 250;
        }
        if (item == Item.func_150898_a((Block)GDBlocks.frail_glitter_block)) {
            return 1000;
        }
        if (item == Item.func_150898_a((Block)GDBlocks.thick_glitter_block)) {
            return 2000;
        }
        if (item == Item.func_150898_a((Block)GDBlocks.gummy_glitter_block)) {
            return 4000;
        }
        if (item == Items.field_151065_br) {
            return 1200;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return 0;
    }

    public static int getSecondFuelBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == GDItems.pink_essence) {
            return 100;
        }
        if (item == GDItems.pink_goo) {
            return 900;
        }
        if (item == Item.func_150898_a((Block)GDBlocks.pink_sludge_block)) {
            return 8100;
        }
        if (item == GDItems.aura_residue) {
            return 200;
        }
        if (item == GDItems.aura_cluster) {
            return 1800;
        }
        if (item == Item.func_150898_a((Block)GDBlocks.aura_block)) {
            return 16200;
        }
        return 0;
    }

    public static int getThirdFuelBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == GDItems.bismuth_residue) {
            return 200;
        }
        if (item == GDItems.bismuth_crystal) {
            return 1800;
        }
        if (item == Item.func_150898_a((Block)GDBlocks.bismuth_block)) {
            return 16200;
        }
        if (item == GDItems.black_residue) {
            return 100;
        }
        if (item == GDItems.tektite) {
            return 900;
        }
        if (item == Item.func_150898_a((Block)GDBlocks.tektite_block)) {
            return 8100;
        }
        return 0;
    }
}

