/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei;

import androsa.gaiadimension.block.tileentity.TileEntityPurifier;
import androsa.gaiadimension.block.tileentity.TileEntityRestructurer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.item.ItemStack;

public class JEICompatUtils {
    private final ImmutableList<ItemStack> goldFuels;
    private final ImmutableList<ItemStack> shineFuels;
    private final ImmutableList<ItemStack> nullFuels;

    public JEICompatUtils(IIngredientRegistry registry) {
        ArrayList<ItemStack> goldList = new ArrayList<ItemStack>();
        ArrayList<ItemStack> shineList = new ArrayList<ItemStack>();
        ArrayList<ItemStack> nullList = new ArrayList<ItemStack>();
        for (ItemStack stack : registry.getAllIngredients(VanillaTypes.ITEM)) {
            this.addItemStack(stack, "gaiadimension.gold_fuel", goldList);
            this.addItemStack(stack, "gaiadimension.shine_fuel", shineList);
            this.addItemStack(stack, "gaiadimension.nulling_fuel", nullList);
        }
        this.goldFuels = ImmutableList.copyOf(goldList);
        this.shineFuels = ImmutableList.copyOf(shineList);
        this.nullFuels = ImmutableList.copyOf(nullList);
    }

    public ImmutableList<ItemStack> getGoldFuels() {
        return this.goldFuels;
    }

    public ImmutableList<ItemStack> getShineFuels() {
        return this.shineFuels;
    }

    public ImmutableList<ItemStack> getNullFuels() {
        return this.nullFuels;
    }

    private void addItemStack(ItemStack stack, String type, List<ItemStack> fuel) {
        switch (type) {
            case "gaiadimension.gold_fuel": {
                if (TileEntityRestructurer.getFuelBurnTime(stack) <= 0 && TileEntityPurifier.getFuelBurnTime(stack) <= 0) break;
                fuel.add(stack);
                break;
            }
            case "gaiadimension.shine_fuel": {
                if (TileEntityRestructurer.getSecondFuelBurnTime(stack) > 0 || TileEntityPurifier.getSecondFuelBurnTime(stack) > 0) {
                    fuel.add(stack);
                }
            }
            case "gaiadimension.nulling_fuel": {
                if (TileEntityPurifier.getThirdFuelBurnTime(stack) <= 0) break;
                fuel.add(stack);
            }
        }
    }
}

