/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.purifier;

import com.google.common.base.Preconditions;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class NullFuelRecipe
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final String smeltCountString;
    private final IDrawableAnimated flame;
    private final ResourceLocation firetex = new ResourceLocation("gaiadimension", "textures/gui/jei/nulling.png");

    public NullFuelRecipe(IGuiHelper guiHelper, Collection<ItemStack> input, int burnTime) {
        Preconditions.checkArgument((burnTime > 0 ? 1 : 0) != 0, (Object)"burn time must be greater than 0");
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>(input);
        this.inputs = Collections.singletonList(inputList);
        if (burnTime == 200) {
            this.smeltCountString = I18n.func_135052_a((String)"gui.gaiadimension.category.fuel.smeltAverage.singleAverage", (Object[])new Object[0]);
        } else {
            NumberFormat numberInstance = NumberFormat.getNumberInstance();
            numberInstance.setMaximumFractionDigits(2);
            String smeltCount = numberInstance.format((float)burnTime / 200.0f);
            this.smeltCountString = I18n.func_135052_a((String)"gui.gaiadimension.category.fuel.smeltAverage", (Object[])new Object[]{smeltCount});
        }
        this.flame = guiHelper.drawableBuilder(this.firetex, 0, 0, 14, 14).setTextureSize(14, 14).buildAnimated(burnTime, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.flame.draw(minecraft, 1, 0);
        minecraft.field_71466_p.func_78276_b(this.smeltCountString, 24, 13, 0x808080);
    }
}

