/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.purifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class PurifyingRecipe
implements IRecipeWrapper {
    private final List<List<ItemStack>> input;
    private final List<ItemStack> outputs;
    private final String experienceString;

    public PurifyingRecipe(List<ItemStack> input, ItemStack output1, ItemStack output2, float exp) {
        this.input = Collections.singletonList(input);
        this.outputs = new ArrayList<ItemStack>();
        Collections.addAll(this.outputs, output1, output2);
        this.experienceString = exp > 0.0f ? I18n.func_135052_a((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(exp)}) : null;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.input);
        ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
    }

    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.experienceString != null) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(this.experienceString);
            fontRenderer.func_78276_b(this.experienceString, recipeWidth - stringWidth, 5, 0x808080);
        }
    }
}

