/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.restructurer;

import androsa.gaiadimension.block.tileentity.TileEntityPurifier;
import androsa.gaiadimension.block.tileentity.TileEntityRestructurer;
import androsa.gaiadimension.compat.jei.JEICompatUtils;
import androsa.gaiadimension.compat.jei.restructurer.GlitterFuelRecipe;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class GlitterFuelRecipeMaker {
    public static List<GlitterFuelRecipe> getGlitterRecipes(JEICompatUtils registry, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IStackHelper stackHelper = helpers.getStackHelper();
        ImmutableList<ItemStack> fuel = registry.getGoldFuels();
        ArrayList<GlitterFuelRecipe> glitterFuel = new ArrayList<GlitterFuelRecipe>(fuel.size());
        HashSet<String> oreDictNames = new HashSet<String>();
        for (ItemStack stack : fuel) {
            if (fuel == null) continue;
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
            if (oreIDs.length > 0) {
                for (int oreID : oreIDs) {
                    String name = OreDictionary.getOreName((int)oreID);
                    if (oreDictNames.contains(name)) continue;
                    oreDictNames.add(name);
                    NonNullList oreDictFuel = OreDictionary.getOres((String)name);
                    List oreDictFuelSet = stackHelper.getAllSubtypes((Iterable)oreDictFuel);
                    GlitterFuelRecipeMaker.removeNonFuel(oreDictFuelSet);
                    if (oreDictFuelSet.isEmpty()) continue;
                    int burnTimeR = GlitterFuelRecipeMaker.getGlitterTimeR((ItemStack)oreDictFuelSet.get(0));
                    int burnTimeP = GlitterFuelRecipeMaker.getGlitterTimeP((ItemStack)oreDictFuelSet.get(0));
                    if (burnTimeR > 0) {
                        glitterFuel.add(new GlitterFuelRecipe(guiHelper, oreDictFuelSet, burnTimeR));
                        continue;
                    }
                    if (burnTimeP <= 0) continue;
                    glitterFuel.add(new GlitterFuelRecipe(guiHelper, oreDictFuelSet, burnTimeP));
                }
                continue;
            }
            List subtypes = stackHelper.getSubtypes(stack);
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            for (ItemStack subtype : subtypes) {
                if (TileEntityRestructurer.getFuelBurnTime(subtype) > 0) {
                    fuels.add(subtype);
                    continue;
                }
                if (TileEntityPurifier.getFuelBurnTime(subtype) <= 0) continue;
                fuels.add(subtype);
            }
            if (fuels.isEmpty()) continue;
            int burnTimeR = GlitterFuelRecipeMaker.getGlitterTimeR((ItemStack)fuels.get(0));
            int burnTimeP = GlitterFuelRecipeMaker.getGlitterTimeP((ItemStack)fuels.get(0));
            if (burnTimeR > 0) {
                glitterFuel.add(new GlitterFuelRecipe(guiHelper, fuels, burnTimeR));
                continue;
            }
            if (burnTimeP <= 0) continue;
            glitterFuel.add(new GlitterFuelRecipe(guiHelper, fuels, burnTimeP));
        }
        return glitterFuel;
    }

    private static void removeNonFuel(Collection<ItemStack> stacks) {
        stacks.removeIf(stack -> GlitterFuelRecipeMaker.getGlitterTimeR(stack) == 0 || GlitterFuelRecipeMaker.getGlitterTimeP(stack) == 0);
    }

    private static int getGlitterTimeR(ItemStack stack) {
        return TileEntityRestructurer.getFuelBurnTime(stack);
    }

    private static int getGlitterTimeP(ItemStack stack) {
        return TileEntityPurifier.getFuelBurnTime(stack);
    }
}

