/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.restructurer;

import androsa.gaiadimension.block.tileentity.TileEntityPurifier;
import androsa.gaiadimension.block.tileentity.TileEntityRestructurer;
import androsa.gaiadimension.compat.jei.JEICompatUtils;
import androsa.gaiadimension.compat.jei.restructurer.ShineFuelRecipe;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ShineFuelRecipeMaker {
    public static List<ShineFuelRecipe> getShineRecipes(JEICompatUtils registry, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IStackHelper stackHelper = helpers.getStackHelper();
        ImmutableList<ItemStack> fuel = registry.getShineFuels();
        ArrayList<ShineFuelRecipe> shineFuel = new ArrayList<ShineFuelRecipe>(fuel.size());
        HashSet<String> oreDictNames = new HashSet<String>();
        for (ItemStack stack : fuel) {
            if (fuel == null) continue;
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
            if (oreIDs.length > 0) {
                for (int oreID : oreIDs) {
                    String name = OreDictionary.getOreName((int)oreID);
                    if (oreDictNames.contains(name)) continue;
                    oreDictNames.add(name);
                    NonNullList oreDictFuel = OreDictionary.getOres((String)name);
                    List oreDictFuelSet = stackHelper.getAllSubtypes((Iterable)oreDictFuel);
                    ShineFuelRecipeMaker.removeNonFuel(oreDictFuelSet);
                    if (oreDictFuelSet.isEmpty()) continue;
                    int burnTimeR = ShineFuelRecipeMaker.getShineTimeR((ItemStack)oreDictFuelSet.get(0));
                    int burnTimeP = ShineFuelRecipeMaker.getShineTimeP((ItemStack)oreDictFuelSet.get(0));
                    if (burnTimeR > 0) {
                        shineFuel.add(new ShineFuelRecipe(guiHelper, oreDictFuelSet, burnTimeR));
                        continue;
                    }
                    if (burnTimeP <= 0) continue;
                    shineFuel.add(new ShineFuelRecipe(guiHelper, oreDictFuelSet, burnTimeP));
                }
                continue;
            }
            List subtypes = stackHelper.getSubtypes(stack);
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            for (ItemStack subtype : subtypes) {
                if (TileEntityRestructurer.getSecondFuelBurnTime(subtype) > 0) {
                    fuels.add(subtype);
                    continue;
                }
                if (TileEntityPurifier.getSecondFuelBurnTime(subtype) <= 0) continue;
                fuels.add(subtype);
            }
            if (fuels.isEmpty()) continue;
            int burnTimeR = ShineFuelRecipeMaker.getShineTimeR((ItemStack)fuels.get(0));
            int burnTimeP = ShineFuelRecipeMaker.getShineTimeP((ItemStack)fuels.get(0));
            if (burnTimeR > 0) {
                shineFuel.add(new ShineFuelRecipe(guiHelper, fuels, burnTimeR));
                continue;
            }
            if (burnTimeP <= 0) continue;
            shineFuel.add(new ShineFuelRecipe(guiHelper, fuels, burnTimeP));
        }
        return shineFuel;
    }

    private static void removeNonFuel(Collection<ItemStack> stacks) {
        stacks.removeIf(stack -> ShineFuelRecipeMaker.getShineTimeR(stack) == 0 || ShineFuelRecipeMaker.getShineTimeP(stack) == 0);
    }

    private static int getShineTimeR(ItemStack stack) {
        return TileEntityRestructurer.getSecondFuelBurnTime(stack);
    }

    private static int getShineTimeP(ItemStack stack) {
        return TileEntityPurifier.getSecondFuelBurnTime(stack);
    }
}

