/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.biomes.GDBlueAgateTaiga;
import androsa.gaiadimension.biomes.GDCrystalPlains;
import androsa.gaiadimension.biomes.GDGreenAgateJungle;
import androsa.gaiadimension.biomes.GDPinkAgateForest;
import androsa.gaiadimension.biomes.GDPurpleAgateSwamp;
import androsa.gaiadimension.registry.GDBiomes;
import androsa.gaiadimension.registry.GDBlocks;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class GDGrowthSapper
extends EntityCreature
implements IAnimals {
    private static final DataParameter<Integer> SAPPER_VARIANT = EntityDataManager.func_187226_a(GDGrowthSapper.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final ResourceLocation PINK_TABLE = new ResourceLocation("gaiadimension", "entities/common_sapper");
    public static final ResourceLocation BLUE_TABLE = new ResourceLocation("gaiadimension", "entities/chilled_sapper");
    public static final ResourceLocation GREN_TABLE = new ResourceLocation("gaiadimension", "entities/nutrient_sapper");
    public static final ResourceLocation PURP_TABLE = new ResourceLocation("gaiadimension", "entities/mystified_sapper");

    public GDGrowthSapper(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70728_aV = 1 + this.field_70146_Z.nextInt(3);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SAPPER_VARIANT, (Object)0);
    }

    protected final void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
    }

    public int getEntityVariant() {
        return (Integer)this.field_70180_af.func_187225_a(SAPPER_VARIANT);
    }

    public void setSapperVariant(int type) {
        this.field_70180_af.func_187227_b(SAPPER_VARIANT, (Object)type);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SapperVariant", this.getEntityVariant());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSapperVariant(compound.func_74762_e("SapperVariant"));
    }

    public float func_70047_e() {
        return 0.7f;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingData) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingData);
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        if (biome instanceof GDPinkAgateForest || biome instanceof GDCrystalPlains) {
            this.setSapperVariant(0);
        } else if (biome instanceof GDBlueAgateTaiga) {
            this.setSapperVariant(1);
        } else if (biome instanceof GDGreenAgateJungle) {
            this.setSapperVariant(2);
        } else if (biome instanceof GDPurpleAgateSwamp) {
            this.setSapperVariant(3);
        } else {
            Random rand = new Random();
            this.setSapperVariant(rand.nextInt(4));
        }
        return data;
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(x, y, z);
        switch (this.getEntityVariant()) {
            case 0: {
                return this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == GDBlocks.glitter_grass && this.field_70170_p.func_175699_k(blockpos) > 8 && this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.pink_agate_forest || this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.crystal_plains || this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.mutant_agate_wildwood;
            }
            case 1: {
                return this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == GDBlocks.glitter_grass && this.field_70170_p.func_175699_k(blockpos) > 8 && this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.blue_agate_taiga || this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.mutant_agate_wildwood;
            }
            case 2: {
                return this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == GDBlocks.glitter_grass && this.field_70170_p.func_175699_k(blockpos) > 8 && this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.green_agate_jungle || this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.mutant_agate_wildwood;
            }
            case 3: {
                return this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == GDBlocks.glitter_grass && this.field_70170_p.func_175699_k(blockpos) > 8 && this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.purple_agate_swamp || this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == GDBiomes.mutant_agate_wildwood;
            }
        }
        return false;
    }

    public ResourceLocation func_184647_J() {
        switch (this.getEntityVariant()) {
            case 0: {
                return PINK_TABLE;
            }
            case 1: {
                return BLUE_TABLE;
            }
            case 2: {
                return GREN_TABLE;
            }
            case 3: {
                return PURP_TABLE;
            }
        }
        return null;
    }
}

