/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.fluid;

import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.registry.GDTabs;
import androsa.gaiadimension.registry.ModelRegisterCallback;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class GDFluidBlock
extends BlockFluidClassic
implements ModelRegisterCallback {
    private final MapColor mapColor;

    public GDFluidBlock(Fluid fluid, Material material, MapColor color) {
        super(fluid, material);
        this.func_149713_g(4);
        this.func_149647_a(GDTabs.tabBlock);
        this.mapColor = color;
    }

    @Deprecated
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.mapColor;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.mixFluids(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighbourPos) {
        super.func_189540_a(state, world, pos, neighborBlock, neighbourPos);
        this.mixFluids(world, pos);
    }

    public void mixFluids(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            IBlockState offset;
            if (side == EnumFacing.DOWN || !(offset = world.func_180495_p(pos.func_177972_a(side))).func_185904_a().func_76224_d() || offset.func_185904_a() != Material.field_151587_i || offset.func_177230_c() == GDBlocks.superhot_magma_block || !(offset.func_177230_c() instanceof BlockFluidBase) && !(offset.func_177230_c() instanceof BlockLiquid)) continue;
            world.func_175656_a(pos, GDBlocks.gaia_cobblestone.func_176223_P());
            this.playSound(world, pos);
            break;
        }
    }

    protected void playSound(World worldIn, BlockPos pos) {
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        worldIn.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0 + Math.random(), d1 + 1.2, d2 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        Item item = Item.func_150898_a((Block)this);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        String domain = this.getRegistryName() == null ? "minecraft" : this.getRegistryName().func_110624_b();
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation(domain + ":fluids", this.getFluid().getName());
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelResourceLocation);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return modelResourceLocation;
            }
        });
    }
}

