/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.item;

import androsa.gaiadimension.fluid.GDFluidHandlerBucket;
import androsa.gaiadimension.registry.ModelRegisterCallback;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public class GDScaynyxBucket
extends UniversalBucket
implements ModelRegisterCallback {
    private final ItemStack empty = new ItemStack((Item)this);

    public GDScaynyxBucket() {
        this(1000);
    }

    public GDScaynyxBucket(int capacity) {
        super(capacity, ItemStack.field_190927_a, true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)this.empty);
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fStack = new FluidStack(fluid, this.getCapacity());
            ItemStack stack = new ItemStack((Item)this);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandler == null || fluidHandler.fill(fStack, true) != fStack.amount) continue;
            ItemStack filled = fluidHandler.getContainer();
            subItems.add((Object)filled);
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        String unlocalizedName = this.func_77657_g(stack);
        if (fluidStack == null) {
            return I18n.func_74838_a((String)(unlocalizedName + ".name")).trim();
        }
        String fluidUnlocalisedName = unlocalizedName + ".filled." + fluidStack.getFluid().getName() + ".name";
        if (I18n.func_94522_b((String)fluidUnlocalisedName)) {
            return I18n.func_74838_a((String)fluidUnlocalisedName);
        }
        return I18n.func_74837_a((String)(unlocalizedName + ".filled.name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        FluidStack fluidStack = this.getFluid(heldItem);
        if (fluidStack != null) {
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult target = this.func_77621_a(world, player, true);
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        BlockPos pos = target.func_178782_a();
        ItemStack singleBucket = heldItem.func_77946_l();
        singleBucket.func_190920_e(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        if (filledResult.isSuccess()) {
            ItemStack filledBucket = filledResult.result;
            if (player.field_71075_bZ.field_75098_d) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
            }
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)filledBucket);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledBucket);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
    }

    @Nullable
    public FluidStack getFluid(ItemStack container) {
        return FluidUtil.getFluidContained((ItemStack)container);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new GDFluidHandlerBucket(stack, this.getCapacity());
    }
}

