/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.recipe;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PurifierRecipes {
    private static final PurifierRecipes purifyingBase = new PurifierRecipes();
    private final Map<ItemStack, ItemStack[]> purifyingList = new HashMap<ItemStack, ItemStack[]>();
    private final Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static PurifierRecipes instance() {
        return purifyingBase;
    }

    private PurifierRecipes() {
    }

    public void purifying(Block input, ItemStack output1, ItemStack output2, float xp) {
        this.purifying(Item.func_150898_a((Block)input), output1, output2, xp);
    }

    public void purifying(Item input, ItemStack output1, ItemStack output2, float xp) {
        this.purifying(new ItemStack(input, 1, Short.MAX_VALUE), output1, output2, xp);
    }

    public void purifying(ItemStack input, ItemStack output1, ItemStack output2, float xp) {
        this.purifyingList.put(input, new ItemStack[]{output1, output2});
        this.experienceList.put(output1, Float.valueOf(xp));
    }

    public ItemStack[] getPurifyingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack[]> entry : this.purifyingList.entrySet()) {
            if (!this.areStacksEqual(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean areStacksEqual(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == par1ItemStack.func_77973_b() && (par2ItemStack.func_77952_i() == Short.MAX_VALUE || par2ItemStack.func_77952_i() == par1ItemStack.func_77952_i());
    }

    public Map<ItemStack, ItemStack[]> getPurifyingList() {
        return this.purifyingList;
    }

    public float getExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.areStacksEqual(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

