/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry;

import androsa.gaiadimension.world.GaiaWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.MapGenBase;

public class GDFeature {
    public static final GDFeature[] featureList = new GDFeature[256];
    public static final GDFeature nothing = new GDFeature(0, 0, "no_feature").enableDecorations().disableStructure();
    public static final GDFeature malachiteWatchtower = new GDFeature(1, 2, "malachite_watchtower").enableDecorations().enableTerrainAlteration();
    public int featureID;
    public int size;
    public String name;
    public boolean areChunkDecorationsEnabled;
    public boolean isStructureEnabled;
    public boolean isTerrainAltered;
    private List<List<Biome.SpawnListEntry>> spawnableMonsterLists;
    private List<Biome.SpawnListEntry> ambientCreatureList;
    private List<Biome.SpawnListEntry> waterCreatureList;
    private static int maxSize;

    public GDFeature(int parID, int parSize, String parName) {
        this.featureID = parID;
        GDFeature.featureList[parID] = this;
        this.size = parSize;
        this.name = parName;
        this.areChunkDecorationsEnabled = false;
        this.isStructureEnabled = true;
        this.isTerrainAltered = false;
        this.spawnableMonsterLists = new ArrayList<List<Biome.SpawnListEntry>>();
        this.ambientCreatureList = new ArrayList<Biome.SpawnListEntry>();
        this.waterCreatureList = new ArrayList<Biome.SpawnListEntry>();
        this.ambientCreatureList.add(new Biome.SpawnListEntry(EntityBat.class, 10, 8, 8));
        maxSize = Math.max(maxSize, parSize);
    }

    public static int getMaxSize() {
        return maxSize;
    }

    public static GDFeature getFeatureByName(String name) {
        for (GDFeature feature : featureList) {
            if (feature == null || !feature.name.equalsIgnoreCase(name)) continue;
            return feature;
        }
        return nothing;
    }

    public static GDFeature getFeatureByName(ResourceLocation name) {
        if (name.func_110624_b().equalsIgnoreCase("gaiadimension")) {
            return GDFeature.getFeatureByName(name.func_110623_a());
        }
        return nothing;
    }

    public static GDFeature getFeatureByID(int id) {
        for (GDFeature feature : featureList) {
            if (feature == null || feature.featureID != id) continue;
            return feature;
        }
        return nothing;
    }

    public static int getFeatureID(int mapX, int mapZ, World world) {
        return GDFeature.getFeatureAt((int)mapX, (int)mapZ, (World)world).featureID;
    }

    public static GDFeature getFeatureAt(int mapX, int mapZ, World world) {
        return GDFeature.generateFeature(mapX >> 4, mapZ >> 4, world);
    }

    public static boolean isInFeatureChunk(World world, int mapX, int mapZ) {
        int chunkX = mapX >> 4;
        int chunkZ = mapZ >> 4;
        BlockPos cc = GDFeature.getNearestCenterXYZ(chunkX, chunkZ, world);
        return chunkX == cc.func_177958_n() >> 4 && chunkZ == cc.func_177952_p() >> 4;
    }

    public GDFeature enableDecorations() {
        this.areChunkDecorationsEnabled = true;
        return this;
    }

    public GDFeature disableStructure() {
        this.isStructureEnabled = false;
        return this;
    }

    public GDFeature enableTerrainAlteration() {
        this.isTerrainAltered = true;
        return this;
    }

    public GDFeature addMonster(Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public GDFeature addMonster(int listIndex, Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new Biome.SpawnListEntry(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public GDFeature addWaterCreature(Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new Biome.SpawnListEntry(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public static GDFeature getFeatureDirectlyAt(int chunkX, int chunkZ, World world) {
        return nothing;
    }

    public static GDFeature generateFeature(int chunkX, int chunkZ, World world) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        Biome biomeAt = world.func_180494_b(new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8));
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        return nothing;
    }

    public static GDFeature getNearestFeature(int cx, int cz, World world) {
        for (int rad = 1; rad <= 4; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    GDFeature directlyAt = GDFeature.getFeatureDirectlyAt(x + cx, z + cz, world);
                    if (directlyAt.size != rad) continue;
                    return directlyAt;
                }
            }
        }
        return nothing;
    }

    public static BlockPos findNearestFeaturePosBySpacing(World worldIn, GDFeature feature, BlockPos blockPos, int p_191069_3_, int p_191069_4_, int p_191069_5_, boolean p_191069_6_, int p_191069_7_, boolean findUnexplored) {
        int i = blockPos.func_177958_n() >> 4;
        int j = blockPos.func_177952_p() >> 4;
        Random random = new Random();
        block0: for (int k = 0; k <= p_191069_7_; ++k) {
            for (int l = -k; l <= k; ++l) {
                boolean flag = l == -k || l == k;
                for (int i1 = -k; i1 <= k; ++i1) {
                    boolean flag1;
                    boolean bl = flag1 = i1 == -k || i1 == k;
                    if (!flag && !flag1) continue;
                    int j1 = i + p_191069_3_ * l;
                    int k1 = j + p_191069_3_ * i1;
                    if (j1 < 0) {
                        j1 -= p_191069_3_ - 1;
                    }
                    if (k1 < 0) {
                        k1 -= p_191069_3_ - 1;
                    }
                    int l1 = j1 / p_191069_3_;
                    int i2 = k1 / p_191069_3_;
                    Random random1 = worldIn.func_72843_D(l1, i2, p_191069_5_);
                    l1 *= p_191069_3_;
                    i2 *= p_191069_3_;
                    if (p_191069_6_) {
                        l1 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                        i2 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                    } else {
                        l1 += random1.nextInt(p_191069_3_ - p_191069_4_);
                        i2 += random1.nextInt(p_191069_3_ - p_191069_4_);
                    }
                    MapGenBase.func_191068_a((long)worldIn.func_72905_C(), (Random)random, (int)l1, (int)i2);
                    random.nextInt();
                    if (GDFeature.getFeatureAt(l1 << 4, i2 << 4, worldIn) == feature) {
                        if (findUnexplored && worldIn.func_190526_b(l1, i2)) continue;
                        return new BlockPos((l1 << 4) + 8, 64, (i2 << 4) + 8);
                    }
                    if (k == 0) break;
                }
                if (k == 0) continue block0;
            }
        }
        return null;
    }

    public static GDFeature getFeatureForRegion(int chunkX, int chunkZ, World world) {
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        int featureZ = Math.round((float)chunkZ / 16.0f) * 16;
        return GDFeature.generateFeature(featureX, featureZ, world);
    }

    public static int[] getNearestCenter(int cx, int cz, World world) {
        for (int rad = 1; rad <= 4; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    if (GDFeature.getFeatureDirectlyAt((int)(x + cx), (int)(z + cz), (World)world).size != rad) continue;
                    int[] center = new int[]{x * 16 + 8, z * 16 + 8};
                    return center;
                }
            }
        }
        int[] no = new int[]{0, 0};
        return no;
    }

    public static BlockPos getNearestCenterXYZ(int cx, int cz, World world) {
        int chunkX = cx;
        int chunkZ = cz;
        int regionX = chunkX + 8 >> 4;
        int regionZ = chunkZ + 8 >> 4;
        long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new BlockPos(ccx, GaiaWorld.SEALEVEL, ccz);
    }
}

